/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.Tree;
import echopointng.tree.TreeModel;
import echopointng.tree.TreePath;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointPeer;
import echopointng.ui.syncpeer.TreePeer;
import echopointng.ui.syncpeer.TreeRenderer;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.RenderingContext;
import echopointng.util.TokenizerKit;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webrender.output.CssStyle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TreeTableCellPeer
extends AbstractEchoPointPeer
implements ActionProcessor {
    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        Tree tree = (Tree)component.getRenderProperty("tree");
        TreeModel model = (TreeModel)tree.getRenderProperty("model");
        if (model == null) {
            return;
        }
        String actionName = actionElement.getAttribute("name");
        String actionValue = actionElement.getAttribute("value");
        String[] paths = TokenizerKit.tokenize(actionValue, "[]");
        Object[] nodes = new Object[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            nodes[i] = i == 0 ? model.getRoot() : model.getNodeById(paths[i]);
        }
        TreePath nodePath = new TreePath(nodes);
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, actionName, (Object)nodePath);
    }

    public void renderHtml(RenderingContext rc, final Node parentNode, Component component) {
        Tree tree = (Tree)rc.getRP("tree");
        Style fallbackStyle = EPNG.getFallBackStyle(tree);
        Object treeNode = rc.getRP("treeNode");
        TreePath treeNodePath = (TreePath)rc.getRP("treeNodePath");
        ImageManager imageManager = (ImageManager)this.retreiveRenderState(rc, component);
        if (imageManager == null) {
            imageManager = new ImageManager();
            this.storeRenderState(rc, component, imageManager);
        }
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(TreePeer.TREE_SCRIPT_SERVICE);
        final Component treeTableCell = component;
        TreeRenderer.EventSupportCallBack callback = new TreeRenderer.EventSupportCallBack(){

            public String onExpandoCell(RenderingContext rc, CssStyle cssStyle, Element cellElement, Tree tree, Object treeNode, TreePath treeNodePath) {
                return TreeTableCellPeer.this.addToggleEvents(rc, cssStyle, treeTableCell, tree, treeNode, treeNodePath);
            }

            public String onNodeComponentCell(RenderingContext rc, CssStyle cssStyle, Element cellElement, Tree tree, Object treeNode, TreePath treeNodePath) {
                return null;
            }

            public String onNodeIconCell(RenderingContext rc, CssStyle cssStyle, Element cellElement, Tree tree, Object treeNode, TreePath treeNodePath) {
                return TreeTableCellPeer.this.addSelectEvents(rc, cssStyle, treeTableCell, tree, treeNode, treeNodePath, "icon");
            }

            public String onNodeTextCell(RenderingContext rc, CssStyle cssStyle, Element cellElement, Tree tree, Object treeNode, TreePath treeNodePath) {
                return TreeTableCellPeer.this.addSelectEvents(rc, cssStyle, treeTableCell, tree, treeNode, treeNodePath, "text");
            }

            public void onTreeRow(RenderingContext rc, CssStyle cssStyle, Element treeElement, Tree tree, TreePath treeNodePath) {
                treeElement.setAttribute("id", rc.getElementId());
                parentNode.appendChild(treeElement);
            }
        };
        TreeRenderer treeRenderer = new TreeRenderer(rc, callback, tree, fallbackStyle, imageManager);
        treeRenderer.renderTreeRow(treeNode, treeNodePath);
    }

    private String addSelectEvents(RenderingContext rc, CssStyle cssStyle, Component component, Tree tree, Object treeNode, TreePath treeNodePath, String cellType) {
        String eventElementId = this.createEventId(component, tree, cellType, "select", treeNode, treeNodePath);
        if (component.isRenderEnabled()) {
            cssStyle.setAttribute("cursor", "pointer");
            rc.renderEventAdd("click", eventElementId, "EchoPointTree.EventProcessor.onNodeClick");
        }
        return eventElementId;
    }

    private String addToggleEvents(RenderingContext rc, CssStyle cssStyle, Component component, Tree tree, Object treeNode, TreePath treeNodePath) {
        String eventElementId = this.createEventId(component, tree, "expando", "toggle", treeNode, treeNodePath);
        if (component.isRenderEnabled()) {
            cssStyle.setAttribute("cursor", "pointer");
            rc.renderEventAdd("click", eventElementId, "EchoPointTree.EventProcessor.onNodeClick");
        }
        return eventElementId;
    }

    private String createEventId(Component component, Tree tree, String cellType, String baseAction, Object treeNode, TreePath treeNodePath) {
        TreeModel model = (TreeModel)tree.getRenderProperty("model");
        String pathId = TreeRenderer.createPathId(treeNodePath, model);
        String treeId = "tree|" + ContainerInstance.getElementId((Component)component) + '|' + cellType;
        String eventElementId = treeId + '|' + baseAction + '|' + pathId;
        return eventElementId;
    }
}

