/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.util;

import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlTable {
    private Element table;
    private Element tbody;
    private Element td;
    private Element tr;
    private Document document;

    public HtmlTable(Document document) {
        this(document, 0, 0, 0);
    }

    public HtmlTable(Document document, boolean autoAddTRTD) {
        this(document, autoAddTRTD, 0, 0, 0);
    }

    public HtmlTable(Document document, int cellspacing, int cellpadding) {
        this(document, 0, cellspacing, cellpadding);
    }

    public HtmlTable(Document document, int border, int cellspacing, int cellpadding) {
        this(document, true, border, cellspacing, cellpadding);
    }

    public HtmlTable(Document document, boolean autoAddTRTD, int border, int cellspacing, int cellpadding) {
        this.document = document;
        this.table = document.createElement("table");
        this.setAttribute("border", border);
        this.setAttribute("cellspacing", cellspacing);
        this.setAttribute("cellpadding", cellpadding);
        this.tbody = document.createElement("tbody");
        this.table.appendChild(this.tbody);
        if (autoAddTRTD) {
            this.tr = document.createElement("tr");
            this.tbody.appendChild(this.tr);
            this.td = document.createElement("td");
            this.tr.appendChild(this.td);
        }
    }

    public Element getTABLE() {
        return this.table;
    }

    public Element getTBODY() {
        return this.tbody;
    }

    public Element getTD() {
        return this.td;
    }

    public Element getTR() {
        return this.tr;
    }

    public Element newTD() {
        Element newTD = this.document.createElement("td");
        if (this.tr == null) {
            this.tr = this.newTR(false);
        }
        this.tr.appendChild(newTD);
        this.td = newTD;
        return newTD;
    }

    public Element newTR() {
        return this.newTR(true);
    }

    private Element newTR(boolean autoCreateTD) {
        Element newTR = this.document.createElement("tr");
        this.tbody.appendChild(newTR);
        this.tr = newTR;
        if (autoCreateTD) {
            return this.newTD();
        }
        return newTR;
    }

    public Element newTRnoTD() {
        return this.newTR(false);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.table.appendChild(newChild);
    }

    public Node cloneNode(boolean deep) {
        return this.table.cloneNode(deep);
    }

    public boolean equals(Object obj) {
        return this.table.equals(obj);
    }

    public String getAttribute(String name) {
        return this.table.getAttribute(name);
    }

    public Attr getAttributeNode(String name) {
        return this.table.getAttributeNode(name);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.table.getAttributeNodeNS(namespaceURI, localName);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return this.table.getAttributeNS(namespaceURI, localName);
    }

    public NamedNodeMap getAttributes() {
        return this.table.getAttributes();
    }

    public NodeList getChildNodes() {
        return this.table.getChildNodes();
    }

    public NodeList getElementsByTagName(String name) {
        return this.table.getElementsByTagName(name);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.table.getElementsByTagNameNS(namespaceURI, localName);
    }

    public Node getFirstChild() {
        return this.table.getFirstChild();
    }

    public Node getLastChild() {
        return this.table.getLastChild();
    }

    public String getLocalName() {
        return this.table.getLocalName();
    }

    public String getNamespaceURI() {
        return this.table.getNamespaceURI();
    }

    public Node getNextSibling() {
        return this.table.getNextSibling();
    }

    public String getNodeName() {
        return this.table.getNodeName();
    }

    public short getNodeType() {
        return this.table.getNodeType();
    }

    public String getNodeValue() throws DOMException {
        return this.table.getNodeValue();
    }

    public Document getOwnerDocument() {
        return this.table.getOwnerDocument();
    }

    public Node getParentNode() {
        return this.table.getParentNode();
    }

    public String getPrefix() {
        return this.table.getPrefix();
    }

    public Node getPreviousSibling() {
        return this.table.getPreviousSibling();
    }

    public String getTagName() {
        return this.table.getTagName();
    }

    public boolean hasAttribute(String name) {
        return this.table.hasAttribute(name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.table.hasAttributeNS(namespaceURI, localName);
    }

    public boolean hasAttributes() {
        return this.table.hasAttributes();
    }

    public boolean hasChildNodes() {
        return this.table.hasChildNodes();
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.table.insertBefore(newChild, refChild);
    }

    public boolean isSupported(String feature, String version) {
        return this.table.isSupported(feature, version);
    }

    public void normalize() {
        this.table.normalize();
    }

    public void removeAttribute(String name) throws DOMException {
        this.table.removeAttribute(name);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        return this.table.removeAttributeNode(oldAttr);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.table.removeAttributeNS(namespaceURI, localName);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.table.removeChild(oldChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.table.replaceChild(newChild, oldChild);
    }

    public void setAttribute(String name, String value) throws DOMException {
        this.table.setAttribute(name, value);
    }

    public void setAttribute(String name, int value) throws DOMException {
        this.table.setAttribute(name, String.valueOf(value));
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return this.table.setAttributeNode(newAttr);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.table.setAttributeNodeNS(newAttr);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.table.setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.table.setNodeValue(nodeValue);
    }

    public void setPrefix(String prefix) throws DOMException {
        this.table.setPrefix(prefix);
    }

    public String toString() {
        return this.table.toString();
    }
}

