/*
 * Decompiled with CFR 0.152.
 */
package echopointng.util.collections;

import echopointng.util.collections.ConcurrentReaderHashMap;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ExpiryCache
implements Map {
    public static final long DEFAULT_TIME_TO_LIVE = 3600000L;
    public static final long DEFAULT_ACCESS_TIMEOUT = 300000L;
    private Map cacheMap = new ConcurrentReaderHashMap();
    private long ttl = 3600000L;
    private long ato = 300000L;
    private boolean softReferences;

    public ExpiryCache() {
        this(3600000L, 300000L, true);
    }

    public ExpiryCache(long timeToLive, long accessTimeout) {
        this(timeToLive, accessTimeout, true);
    }

    public ExpiryCache(long timeToLive, long accessTimeout, boolean softReferences) {
        this.ttl = timeToLive;
        this.ato = accessTimeout;
        this.softReferences = softReferences;
    }

    public void setTimeToLive(long milliSecs) {
        this.ttl = milliSecs;
    }

    public void setAccessTimeout(long milliSecs) {
        this.ato = milliSecs;
    }

    public long whenCached(Object key) {
        CacheEntry ce = (CacheEntry)this.cacheMap.get(key);
        if (ce == null) {
            return 0L;
        }
        return ce.timeCached;
    }

    public long whenLastAccessed(Object key) {
        CacheEntry ce = (CacheEntry)this.cacheMap.get(key);
        if (ce == null) {
            return 0L;
        }
        return ce.timeAccessedLast;
    }

    public long whenVersion(Object key) {
        CacheEntry ce = (CacheEntry)this.cacheMap.get(key);
        if (ce == null) {
            return -1L;
        }
        return ce.objVersion;
    }

    public int howManyTimesAccessed(Object key) {
        CacheEntry ce = (CacheEntry)this.cacheMap.get(key);
        if (ce == null) {
            return 0;
        }
        return ce.numberOfAccesses;
    }

    public boolean isSoftReferences() {
        return this.softReferences;
    }

    public void setSoftReferences(boolean newValue) {
        this.softReferences = newValue;
    }

    public void clear() {
        this.cacheMap.clear();
    }

    public boolean containsKey(Object key) {
        return this.cacheMap.containsKey(key);
    }

    public Object remove(Object key) {
        CacheEntry ce = (CacheEntry)this.cacheMap.remove(key);
        if (ce != null) {
            return this.dereferenceCacheEntry(ce);
        }
        return null;
    }

    public int size() {
        return this.cacheMap.size();
    }

    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    public void putAll(Map t) {
        Iterator iter = t.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object objToCache = t.get(key);
            this.put(key, objToCache);
        }
    }

    public Set keySet() {
        return this.cacheMap.keySet();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("public Set entrySet() is an unsupported operation.");
    }

    public Collection values() {
        throw new UnsupportedOperationException("public Collection values() is an unsupported operation.");
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("public boolean containsValue(Object value) is an unsupported operation.");
    }

    public Object put(Object key, Object objToCache) {
        return this.put(key, objToCache, this.ttl, this.ato, -1L);
    }

    public Object put(Object key, Object objToCache, long objVersion) {
        return this.put(key, objToCache, this.ttl, this.ato, objVersion);
    }

    public Object put(Object key, Object objToCache, long timeToLive, long accessTimeout) {
        return this.put(key, objToCache, timeToLive, accessTimeout, -1L);
    }

    public Object put(Object key, Object objToCache, long timeToLive, long accessTimeout, long objVersion) {
        CacheEntry ce = (CacheEntry)this.cacheMap.get(key);
        if (ce == null) {
            this.putCacheEntry(key, objToCache, timeToLive, accessTimeout, objVersion);
            return null;
        }
        Object obj = this.dereferenceCacheEntry(ce);
        if (obj == null) {
            if (objToCache == null) {
                ce.timeCached = (ce.timeAccessedLast = System.currentTimeMillis());
                return null;
            }
            this.putCacheEntry(key, objToCache, timeToLive, accessTimeout, objVersion);
            return null;
        }
        if (obj.equals(objToCache)) {
            ce.timeCached = (ce.timeAccessedLast = System.currentTimeMillis());
            return null;
        }
        this.putCacheEntry(key, objToCache, timeToLive, accessTimeout, objVersion);
        return obj;
    }

    public Object get(Object key) {
        return this._getObject(key, -1L, false);
    }

    public Object get(Object key, long objVersion) {
        return this._getObject(key, objVersion, true);
    }

    Object _getObject(Object key, long objVersion, boolean useVersioning) {
        this.logMessage("get", key);
        CacheEntry ce = (CacheEntry)this.cacheMap.get(key);
        if (ce == null) {
            this.logMessage("miss", key);
            return null;
        }
        long now = System.currentTimeMillis();
        if (ce.hasExpired(now)) {
            this.onExpiredObject(key);
            return null;
        }
        if (useVersioning && ce.objVersion < objVersion) {
            this.onExpiredObject(key);
            return null;
        }
        Object value = this.dereferenceCacheEntry(ce);
        if (value == null && this.isSoftReferences()) {
            this.logMessage("null value possible memory reclaim", key);
        }
        return value;
    }

    protected void onExpiredObject(Object key) {
        this.cacheMap.remove(key);
        this.logMessage("expired", key);
    }

    private void logMessage(String message, Object key) {
    }

    public boolean hasExpired(Object key, long when) {
        CacheEntry ce = (CacheEntry)this.cacheMap.get(key);
        if (ce != null) {
            return ce.hasExpired(when);
        }
        return true;
    }

    private Object dereferenceCacheEntry(CacheEntry ce) {
        Object cachedData = ce.getCachedData();
        if (cachedData instanceof SoftReference) {
            return ((SoftReference)cachedData).get();
        }
        return cachedData;
    }

    private void putCacheEntry(Object key, Object objToCache, long timeToLive, long accessTimeout, long objVersion) {
        this.logMessage("put", key);
        if (this.isSoftReferences()) {
            this.cacheMap.put(key, new CacheEntry(new SoftReference<Object>(objToCache), timeToLive, accessTimeout, objVersion));
        } else {
            this.cacheMap.put(key, new CacheEntry(objToCache, timeToLive, accessTimeout, objVersion));
        }
    }

    private class CacheEntry {
        private Object cachedData;
        private long timeCached;
        private long timeAccessedLast;
        private int numberOfAccesses;
        private long objTTL;
        private long objATO;
        private long objVersion;
        private boolean customTimes;

        private CacheEntry(Object cachedData, long ttl, long ato, long objVersion) {
            long now = System.currentTimeMillis();
            this.cachedData = cachedData;
            this.objVersion = objVersion;
            this.objTTL = ttl;
            this.objATO = ato;
            this.customTimes = true;
            this.timeCached = now;
            this.timeAccessedLast = now;
            ++this.numberOfAccesses;
        }

        private Object getCachedData() {
            this.timeAccessedLast = System.currentTimeMillis();
            ++this.numberOfAccesses;
            return this.cachedData;
        }

        private boolean hasExpired(long now) {
            long usedATO;
            long usedTTL = this.customTimes ? this.objTTL : ExpiryCache.this.ttl;
            long l = usedATO = this.customTimes ? this.objATO : ExpiryCache.this.ato;
            if (usedTTL != -1L && now > (usedTTL = this.timeCached + usedTTL)) {
                return true;
            }
            return usedATO != -1L && now > (usedATO = this.timeAccessedLast + usedATO);
        }

        public String toString() {
            long now = System.currentTimeMillis();
            long usedTTL = this.customTimes ? this.objTTL : ExpiryCache.this.ttl;
            long usedATO = this.customTimes ? this.objATO : ExpiryCache.this.ato;
            StringBuffer buf = new StringBuffer();
            buf.append(String.valueOf(this.cachedData));
            buf.append(" ");
            buf.append("[put version ");
            buf.append(this.objVersion);
            buf.append("] ");
            buf.append("[time to live ");
            buf.append(this.timeCached + usedTTL - now);
            buf.append("ms] ");
            buf.append("[access timeout in ");
            buf.append(this.timeAccessedLast + usedATO - now);
            buf.append("ms]");
            return buf.toString();
        }
    }
}

