/*
 * Decompiled with CFR 0.152.
 */
package echopointng.util.reflect;

import echopointng.util.reflect.ReflectionKit;
import java.lang.reflect.Method;

public class BeanKit {
    private static void assertOK(boolean condition, String message) throws BeanKitException {
        if (!condition) {
            throw new BeanKitException(message);
        }
    }

    private static void assertPropertyType(String propertyName, Class paramType, Method getterSetterMethod) throws BeanKitException {
        String message = propertyName + " is not of type - " + paramType.getName() + " in " + getterSetterMethod.getDeclaringClass().getName();
        if (ReflectionKit.isGetter(getterSetterMethod)) {
            BeanKit.assertOK(getterSetterMethod.getReturnType() == paramType, message);
        } else {
            BeanKit.assertOK(getterSetterMethod.getParameterTypes()[0] == paramType, message);
        }
    }

    private static Method findGetter(Object obj, String propertyName) throws BeanKitException {
        Method[] methods = ReflectionKit.getAllBeanGetterMethods(obj.getClass(), Object.class);
        for (int i = 0; i < methods.length; ++i) {
            String getterPropertyName = ReflectionKit.decapitalize(methods[i].getName());
            if (!getterPropertyName.equals(propertyName)) continue;
            return methods[i];
        }
        throw new BeanKitException("No getter found for propertyName - " + propertyName + " within " + obj.getClass().getName());
    }

    private static Method findSetter(Object obj, String propertyName) throws BeanKitException {
        Method[] methods = ReflectionKit.getAllBeanSetterMethods(obj.getClass(), Object.class);
        for (int i = 0; i < methods.length; ++i) {
            if (!ReflectionKit.decapitalize(methods[i].getName()).equals(propertyName)) continue;
            return methods[i];
        }
        throw new BeanKitException("No setter found for propertyName - " + propertyName + " within " + obj.getClass().getName());
    }

    private static Object invokeGetter(Object obj, Method getter) throws BeanKitException {
        try {
            Object rc = getter.invoke(obj, new Object[0]);
            return rc;
        }
        catch (Exception e) {
            throw new BeanKitException("Could not invoke getter - " + getter.getName(), e);
        }
    }

    private static void invokeSetter(Object obj, Method setter, Object value) throws BeanKitException {
        try {
            setter.invoke(obj, value);
        }
        catch (Exception e) {
            throw new BeanKitException("Could not invoke setter - " + setter.getName(), e);
        }
    }

    private static Object findAndInvokeGetter(String propertyName, Object obj, Class desiredType) throws BeanKitException {
        Method getter = BeanKit.findGetter(obj, propertyName);
        BeanKit.assertPropertyType(propertyName, desiredType, getter);
        Object objReturn = BeanKit.invokeGetter(obj, getter);
        return objReturn;
    }

    private static void findAndInvokeSetter(String propertyName, Object obj, Class desiredType, Object value) throws BeanKitException {
        Method setter = BeanKit.findSetter(obj, propertyName);
        BeanKit.assertPropertyType(propertyName, desiredType, setter);
        BeanKit.invokeSetter(obj, setter, value);
    }

    public static Object getProperty(String propertyName, Object obj, Class propertyType) throws BeanKitException {
        return BeanKit.findAndInvokeGetter(propertyName, obj, propertyType);
    }

    public static void setProperty(String propertyName, Object obj, Class propertyType, Object value) throws BeanKitException {
        BeanKit.findAndInvokeSetter(propertyName, obj, propertyType, value);
    }

    public static boolean getBoolean(String propertyName, Object obj) throws BeanKitException {
        return (Boolean)BeanKit.findAndInvokeGetter(propertyName, obj, Boolean.TYPE);
    }

    public static void setBoolean(String propertyName, Object obj, boolean value) throws BeanKitException {
        BeanKit.findAndInvokeSetter(propertyName, obj, Boolean.TYPE, new Boolean(value));
    }

    public static int getInteger(String propertyName, Object obj) throws BeanKitException {
        return (Integer)BeanKit.findAndInvokeGetter(propertyName, obj, Integer.TYPE);
    }

    public static void setInteger(String propertyName, Object obj, int value) throws BeanKitException {
        BeanKit.findAndInvokeSetter(propertyName, obj, Integer.TYPE, new Integer(value));
    }

    public static String getString(String propertyName, Object obj) throws BeanKitException {
        return (String)BeanKit.findAndInvokeGetter(propertyName, obj, String.class);
    }

    public static void setString(String propertyName, Object obj, String value) throws BeanKitException {
        BeanKit.findAndInvokeSetter(propertyName, obj, String.class, value);
    }

    public static class BeanKitException
    extends Exception {
        public BeanKitException(String message) {
            super(message);
        }

        public BeanKitException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

