/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki;

import ch.uzh.ifi.attempto.acewiki.AceWikiApp;
import ch.uzh.ifi.attempto.acewiki.Logger;
import ch.uzh.ifi.attempto.acewiki.Task;
import ch.uzh.ifi.attempto.acewiki.core.grammar.StandardGrammar;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.NounConcept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OfRole;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Ontology;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.ontology.TrAdjRole;
import ch.uzh.ifi.attempto.acewiki.core.ontology.VerbRole;
import ch.uzh.ifi.attempto.acewiki.core.text.OntologyTextElement;
import ch.uzh.ifi.attempto.acewiki.gui.ListItem;
import ch.uzh.ifi.attempto.acewiki.gui.editor.NounForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.NounOfForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.ProperNameForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.TrAdjForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.VerbForm;
import ch.uzh.ifi.attempto.acewiki.gui.editor.WordEditorWindow;
import ch.uzh.ifi.attempto.acewiki.gui.page.ArticlePage;
import ch.uzh.ifi.attempto.acewiki.gui.page.IndexPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.SearchPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.StartPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.chartparser.Grammar;
import ch.uzh.ifi.attempto.echocomp.GeneralButton;
import ch.uzh.ifi.attempto.echocomp.Label;
import ch.uzh.ifi.attempto.echocomp.MessageWindow;
import ch.uzh.ifi.attempto.echocomp.SmallButton;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import ch.uzh.ifi.attempto.echocomp.Style;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import ch.uzh.ifi.attempto.preditor.PreditorWindow;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Random;
import java.util.Stack;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ContentPane;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.TaskQueueHandle;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.filetransfer.Download;
import nextapp.echo2.app.filetransfer.DownloadProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wiki
implements ActionListener {
    private static final long serialVersionUID = 2777443689044226043L;
    private final Ontology ontology;
    private WikiPage currentPage;
    private ContentPane mainPane = new ContentPane();
    private ContentPane contentPane = new ContentPane();
    private Row navigationButtons = new Row();
    private Logger logger;
    private GeneralButton backButton = new GeneralButton("<Back", (ActionListener)this);
    private GeneralButton forwardButton = new GeneralButton("Forward>", (ActionListener)this);
    private GeneralButton refreshButton = new GeneralButton("Refresh", (ActionListener)this);
    private SmallButton indexButton = new SmallButton("Index", (ActionListener)this, 12);
    private SmallButton homeButton = new SmallButton("Main Page", (ActionListener)this, 12);
    private SmallButton randomButton = new SmallButton("Random Article", (ActionListener)this, 12);
    private SmallButton searchButton = new SmallButton("Search", (ActionListener)this, 12);
    private SmallButton newButton = new SmallButton("New Word...", (ActionListener)this, 12);
    private SmallButton exportButton = new SmallButton("Export", (ActionListener)this, 12);
    private SmallButton logoutButton = new SmallButton("Logout", (ActionListener)this, 12);
    private ListItem logoutListItem;
    private Label logo;
    private StartPage startPage;
    private Stack<WikiPage> history = new Stack();
    private Stack<WikiPage> forward = new Stack();
    private ArrayList<WindowPane> windows = new ArrayList();
    private Grammar grammar = new StandardGrammar();
    private TaskQueueHandle taskQueue;
    private ApplicationInstance application;
    private static Properties properties;

    Wiki(Ontology ontology, String string, String string2, int n) {
        this.ontology = ontology;
        this.logger = new Logger(ontology.getName(), n);
        this.application = ApplicationInstance.getActive();
        this.taskQueue = this.application.createTaskQueue();
        SplitPane splitPane = new SplitPane(5);
        splitPane.setSeparatorPosition(new Extent(50));
        splitPane.setSeparatorHeight(new Extent(0));
        this.navigationButtons.setInsets(new Insets(5, 5, 5, 26));
        this.navigationButtons.setCellSpacing(new Extent(5));
        this.navigationButtons.setBackground(new Color(230, 230, 230));
        this.navigationButtons.add((Component)this.backButton);
        this.navigationButtons.add((Component)this.forwardButton);
        this.navigationButtons.add((Component)this.refreshButton);
        ContentPane contentPane = new ContentPane();
        contentPane.add((Component)this.navigationButtons);
        SplitPane splitPane2 = new SplitPane(3, new Extent(145));
        splitPane2.setSeparatorHeight(new Extent(0));
        ContentPane contentPane2 = new ContentPane();
        contentPane2.setBackground(new Color(230, 230, 230));
        Column column = new Column();
        column.setInsets(new Insets(10, 10));
        this.logo = new Label();
        column.add((Component)this.logo);
        column.add((Component)new VSpace(30));
        SolidLabel solidLabel = new SolidLabel("Navigation:", 2);
        solidLabel.setFont(new Font(Style.fontTypeface, 2, new Extent(10)));
        column.add((Component)solidLabel);
        column.add((Component)new ListItem(new Component[]{this.homeButton}));
        column.add((Component)new ListItem(new Component[]{this.indexButton}));
        column.add((Component)new ListItem(new Component[]{this.randomButton}));
        column.add((Component)new ListItem(new Component[]{this.searchButton}));
        column.add((Component)new VSpace(10));
        SolidLabel solidLabel2 = new SolidLabel("Actions:", 2);
        solidLabel2.setFont(new Font(Style.fontTypeface, 2, new Extent(10)));
        column.add((Component)solidLabel2);
        column.add((Component)new ListItem(new Component[]{this.newButton}));
        column.add((Component)new ListItem(new Component[]{this.exportButton}));
        this.logoutListItem = new ListItem(new Component[]{this.logoutButton});
        this.logoutButton.setWidth(new Extent(110));
        this.logoutListItem.setVisible(false);
        column.add((Component)this.logoutListItem);
        contentPane2.add((Component)column);
        SplitPane splitPane3 = new SplitPane(3);
        splitPane3.setSeparatorWidth(new Extent(1));
        splitPane3.setSeparatorColor(Color.BLACK);
        splitPane3.setSeparatorPosition(new Extent(0));
        splitPane3.add((Component)new Label());
        SplitPane splitPane4 = new SplitPane(5);
        splitPane4.setSeparatorHeight(new Extent(1));
        splitPane4.setSeparatorColor(Color.BLACK);
        splitPane4.setSeparatorPosition(new Extent(0));
        splitPane4.add((Component)new Label());
        splitPane3.add((Component)splitPane4);
        splitPane4.add((Component)this.mainPane);
        splitPane.add((Component)contentPane);
        splitPane.add((Component)splitPane3);
        splitPane2.add((Component)contentPane2);
        splitPane2.add((Component)splitPane);
        this.contentPane.add((Component)splitPane2);
        this.startPage = new StartPage(this, string, string2);
        this.setCurrentPage(this.startPage);
        this.update();
    }

    public ContentPane getContentPane() {
        return this.contentPane;
    }

    public void showWindow(WindowPane windowPane) {
        if (windowPane instanceof WordEditorWindow || windowPane instanceof PreditorWindow) {
            ArrayList<WindowPane> arrayList = new ArrayList<WindowPane>();
            for (WindowPane windowPane2 : this.windows) {
                if (!windowPane2.isVisible()) continue;
                arrayList.add(windowPane2);
            }
            this.windows = arrayList;
            int n = this.windows.size();
            windowPane.setPositionX(new Extent(50 + n % 5 * 40));
            windowPane.setPositionY(new Extent(50 + n % 5 * 20));
            this.windows.add(windowPane);
        }
        this.getContentPane().add((Component)windowPane);
    }

    public void showPage(WikiPage wikiPage) {
        if (!this.currentPage.equals((Object)wikiPage)) {
            this.history.push(this.currentPage);
            this.forward.clear();
        }
        this.setCurrentPage(wikiPage);
        this.log("navi", "goto: " + (Object)((Object)wikiPage));
        this.update();
    }

    public void showPage(OntologyElement ontologyElement) {
        this.showPage(ArticlePage.create(ontologyElement, this));
    }

    public void back() {
        if (this.history.isEmpty()) {
            return;
        }
        this.forward.push(this.currentPage);
        WikiPage wikiPage = this.history.pop();
        this.setCurrentPage(wikiPage);
        this.log("navi", "back: " + (Object)((Object)wikiPage));
        this.update();
    }

    public void forward() {
        if (this.forward.isEmpty()) {
            return;
        }
        this.history.push(this.currentPage);
        WikiPage wikiPage = this.forward.pop();
        this.setCurrentPage(wikiPage);
        this.log("navi", "forw: " + (Object)((Object)wikiPage));
        this.update();
    }

    public void showStartPage() {
        this.showPage(this.startPage);
    }

    public void showIndexPage() {
        this.showPage(new IndexPage(this));
    }

    public void showSearchPage() {
        this.showPage(new SearchPage(this));
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public Collection<OntologyElement> getOntologyElements() {
        return this.ontology.getOntologyElements();
    }

    public void update() {
        this.mainPane.removeAll();
        this.mainPane.add((Component)this.currentPage);
        this.backButton.setEnabled(!this.history.isEmpty());
        this.forwardButton.setEnabled(!this.forward.isEmpty());
        if (this.ontology.isConsistent()) {
            this.logo.setIcon((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/AceWikiLogoSmall.png"));
        } else {
            this.logo.setIcon((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/AceWikiLogoSmallRed.png"));
        }
    }

    private void setCurrentPage(WikiPage wikiPage) {
        this.currentPage = wikiPage;
        this.refresh();
    }

    public void refresh() {
        this.currentPage.update();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.backButton) {
            this.log("page", "pressed: back");
            this.back();
        } else if (actionEvent.getSource() == this.forwardButton) {
            this.log("page", "pressed: forward");
            this.forward();
        } else if (actionEvent.getSource() == this.indexButton) {
            this.log("page", "pressed: index");
            this.showIndexPage();
        } else if (actionEvent.getSource() == this.homeButton) {
            this.log("page", "pressed: main page");
            this.showStartPage();
        } else if (actionEvent.getSource() == this.randomButton) {
            this.log("page", "pressed: random page");
            ArrayList<OntologyElement> arrayList = new ArrayList<OntologyElement>(this.ontology.getOntologyElements());
            if (arrayList.size() > 0) {
                int n = new Random().nextInt(arrayList.size());
                this.showPage(arrayList.get(n));
            } else {
                this.showStartPage();
            }
        } else if (actionEvent.getSource() == this.refreshButton) {
            this.log("page", "pressed: refresh");
            this.update();
            this.refresh();
        } else if (actionEvent.getSource() == this.newButton) {
            this.log("page", "pressed: new word");
            WordEditorWindow wordEditorWindow = WordEditorWindow.createCreatorWindow();
            wordEditorWindow.addTab(new ProperNameForm(new Individual(), wordEditorWindow, this, this));
            wordEditorWindow.addTab(new NounForm(new NounConcept(), 0, wordEditorWindow, this, this));
            wordEditorWindow.addTab(new NounOfForm(new OfRole(), wordEditorWindow, this, this));
            wordEditorWindow.addTab(new VerbForm(new VerbRole(), 0, wordEditorWindow, this, this));
            wordEditorWindow.addTab(new TrAdjForm(new TrAdjRole(), wordEditorWindow, this, this));
            this.showWindow(wordEditorWindow);
        } else if (actionEvent.getSource() == this.searchButton) {
            this.log("page", "pressed: search");
            this.showSearchPage();
        } else if (actionEvent.getSource() == this.exportButton) {
            final String string = this.ontology.getOWLOntologyAsXML();
            DownloadProvider downloadProvider = new DownloadProvider(){

                public String getContentType() {
                    return "application/owl+xml";
                }

                public String getFileName() {
                    return Wiki.this.ontology.getName() + ".owl";
                }

                public int getSize() {
                    return string.length();
                }

                public void writeFile(OutputStream outputStream) throws IOException {
                    outputStream.write(string.getBytes());
                    outputStream.close();
                }
            };
            this.application.enqueueCommand((Command)new Download(downloadProvider, true));
        } else if (actionEvent.getSource() == this.logoutButton) {
            this.showWindow((WindowPane)new MessageWindow("Logout", "Do you really want to log out?", null, (ActionListener)this, new String[]{"Yes", "No"}));
        } else if (actionEvent.getSource() instanceof MessageWindow && actionEvent.getActionCommand().equals("Yes")) {
            ((AceWikiApp)ApplicationInstance.getActive()).logout();
        } else if (actionEvent.getSource() instanceof OntologyTextElement) {
            OntologyTextElement ontologyTextElement = (OntologyTextElement)actionEvent.getSource();
            this.log("edit", "new word: " + ontologyTextElement.getOntologyElement().getWord());
            this.showPage(ontologyTextElement.getOntologyElement());
        }
    }

    public void log(String string, String string2) {
        this.logger.log(string, string2);
    }

    public void setUsername(String string) {
        this.logger.setUsername(string);
        this.logoutButton.setText("Logout: " + string);
        this.logoutListItem.setVisible(true);
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void enqueueTask(Runnable runnable) {
        this.application.enqueueTask(this.taskQueue, runnable);
    }

    public void enqueueTaskShowingWaitWindow(String string, String string2, final Task task) {
        final MessageWindow messageWindow = new MessageWindow(string, new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/wait.gif"), string2, null, null, new String[0]);
        messageWindow.setClosable(false);
        this.showWindow((WindowPane)messageWindow);
        Thread thread = new Thread(){

            public void run() {
                task.run();
                Wiki.this.application.enqueueTask(Wiki.this.taskQueue, new Runnable(){

                    public synchronized void run() {
                        messageWindow.setVisible(false);
                        task.updateGUI();
                    }
                });
            }
        };
        thread.start();
    }

    public static String getInfo(String string) {
        if (properties == null) {
            String string2 = "ch/uzh/ifi/attempto/acewiki/acewiki.properties";
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string2);
            properties = new Properties();
            try {
                properties.load(inputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return properties.getProperty(string);
    }
}

