/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.core.text;

import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.text.OntologyTextElement;
import ch.uzh.ifi.attempto.preditor.text.TextElement;

class OntoTextElem
implements OntologyTextElement {
    private OntologyElement ontologyElement;
    private int wordNumber;
    private String category;
    private boolean capitalize = false;

    OntoTextElem(OntologyElement ontologyElement, int n, String string) {
        if (ontologyElement.getWord(n) == null) {
            throw new RuntimeException(ontologyElement + " has no word number " + n);
        }
        this.ontologyElement = ontologyElement;
        this.wordNumber = n;
        this.category = string;
    }

    public String getUnderscoredText() {
        String string = this.ontologyElement.getWord(this.wordNumber);
        if (this.capitalize) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public String getText() {
        String string = this.ontologyElement.getPrettyWord(this.wordNumber);
        if (this.capitalize) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public int getWordNumber() {
        return this.wordNumber;
    }

    public String getCategory() {
        return this.category;
    }

    public void checkNeighborTextElements(TextElement textElement, TextElement textElement2) {
        this.capitalize = textElement == null || textElement.getText().matches("[.?]");
    }

    public OntologyElement getOntologyElement() {
        return this.ontologyElement;
    }

    public boolean equals(Object object) {
        if (object instanceof OntoTextElem) {
            OntoTextElem ontoTextElem = (OntoTextElem)object;
            return this.ontologyElement == ontoTextElem.ontologyElement && this.wordNumber == ontoTextElem.wordNumber && this.category.equals(ontoTextElem.category);
        }
        return false;
    }
}

