/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Concept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.NounConcept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import ch.uzh.ifi.attempto.acewiki.gui.editor.SentenceEditorHandler;
import ch.uzh.ifi.attempto.acewiki.gui.page.ArticlePage;
import ch.uzh.ifi.attempto.acewiki.gui.page.HierarchyPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.IndividualsPage;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.event.ActionEvent;

public class ConceptPage
extends ArticlePage {
    private static final long serialVersionUID = -505381176379658743L;
    private NounConcept concept;

    protected ConceptPage(Concept concept, Wiki wiki) {
        super(wiki, concept);
        this.concept = (NounConcept)concept;
        this.addTab("Individuals", this);
        this.addTab("Hierarchy", this);
        this.update();
    }

    public OntologyElement getOntologyElement() {
        return this.concept;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if ("Individuals".equals(actionEvent.getActionCommand())) {
            this.getWiki().showPage(new IndividualsPage(this));
        } else if ("Hierarchy".equals(actionEvent.getActionCommand())) {
            this.getWiki().showPage(new HierarchyPage(this));
        }
    }

    protected void doUpdate() {
        super.doUpdate();
        this.getTitle().setText(this.concept.getHeadword());
        Thread thread = new Thread(){

            public void run() {
                ConceptPage.this.getWiki().enqueueTask(new Runnable(){

                    public void run() {
                        if (ConceptPage.this.concept.getOntology().isSatisfiable(ConceptPage.this.concept)) {
                            ConceptPage.this.getTitle().setColor(Color.BLACK);
                        } else {
                            ConceptPage.this.getTitle().setColor(new Color(193, 0, 0));
                        }
                    }
                });
            }
        };
        thread.start();
    }

    public void edit(Sentence sentence) {
        if (this.concept.getSentences().contains(sentence)) {
            this.getWiki().showWindow((WindowPane)SentenceEditorHandler.generatePreditorEditWindow(sentence, this));
        }
    }
}

