/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.core.ontology.Concept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import ch.uzh.ifi.attempto.acewiki.gui.IndexBar;
import ch.uzh.ifi.attempto.acewiki.gui.TextRow;
import ch.uzh.ifi.attempto.acewiki.gui.Title;
import ch.uzh.ifi.attempto.acewiki.gui.page.ConceptPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.IndividualsPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.ReferencesPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WordPage;
import ch.uzh.ifi.attempto.echocomp.DelayedComponent;
import ch.uzh.ifi.attempto.echocomp.Label;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class HierarchyPage
extends WikiPage
implements ActionListener {
    private static final long serialVersionUID = 3126817139010810197L;
    private static final int pageSize = 15;
    private ConceptPage page;
    private Column upHierarchyColumn = new Column();
    private Column downHierarchyColumn = new Column();
    private int upChosenPage = 0;
    private int downChosenPage = 0;

    public HierarchyPage(ConceptPage conceptPage) {
        super(conceptPage.getWiki(), new Title(conceptPage.getOntologyElement().getHeadword(), "- Hierarchy"));
        this.page = conceptPage;
        this.addTab("Article", this);
        this.addTab("Noun", this);
        this.addTab("References", this);
        this.addTab("Individuals", this);
        this.addSelectedTab("Hierarchy");
        this.add((Component)new VSpace(12));
        this.addHeadline("Upward");
        this.add((Component)new VSpace(5));
        this.add((Component)this.upHierarchyColumn);
        this.addHeadline("Downward");
        this.add((Component)new VSpace(5));
        this.add((Component)this.downHierarchyColumn);
    }

    protected void doUpdate() {
        this.getTitle().setText(this.page.getOntologyElement().getHeadword());
        this.upHierarchyColumn.removeAll();
        this.downHierarchyColumn.removeAll();
        Column column = new Column();
        column.setInsets(new Insets(10, 0, 0, 0));
        column.add((Component)new Label((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/wait.gif")));
        Concept concept = (Concept)this.page.getOntologyElement();
        if (concept.areSuperConceptsCached()) {
            this.upHierarchyColumn.add((Component)new HierarchyComponent(true));
        } else {
            this.upHierarchyColumn.add((Component)new DelayedComponent((Component)column){
                private static final long serialVersionUID = -5068057863490522605L;

                public Component initComponent() {
                    return new HierarchyComponent(true);
                }
            });
        }
        Column column2 = new Column();
        column2.setInsets(new Insets(10, 0, 0, 0));
        column2.add((Component)new Label((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/wait.gif")));
        if (concept.areSubConceptsCached()) {
            this.downHierarchyColumn.add((Component)new HierarchyComponent(false));
        } else {
            this.downHierarchyColumn.add((Component)new DelayedComponent((Component)column2){
                private static final long serialVersionUID = 2782291841490690030L;

                public Component initComponent() {
                    return new HierarchyComponent(false);
                }
            });
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Article".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: article");
            this.getWiki().showPage(this.page);
        } else if ("Noun".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: word");
            this.getWiki().showPage(new WordPage(this.page));
        } else if ("References".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: references");
            this.getWiki().showPage(new ReferencesPage(this.page));
        } else if ("Individuals".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: individuals");
            this.getWiki().showPage(new IndividualsPage(this.page));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof HierarchyPage) {
            return this.page.equals((Object)((HierarchyPage)((Object)object)).page);
        }
        return false;
    }

    public boolean isExpired() {
        return this.page.isExpired();
    }

    public String toString() {
        return "-IND- " + this.page.getOntologyElement().getWord();
    }

    private class HierarchyComponent
    extends Column
    implements ActionListener {
        private static final long serialVersionUID = 6461817187189387351L;
        private boolean up;
        private Column column = new Column();
        private IndexBar indexBar;
        private ArrayList<Sentence> sentences;

        public HierarchyComponent(boolean bl) {
            this.up = bl;
            this.indexBar = new IndexBar("Page:", 0, this);
            this.add((Component)this.indexBar);
            this.column.setInsets(new Insets(10, 2, 5, 10));
            this.column.setCellSpacing(new Extent(2));
            this.add((Component)this.column);
            Concept concept = (Concept)HierarchyPage.this.page.getOntologyElement();
            List<Concept> list = bl ? concept.getSuperConcepts() : concept.getSubConcepts();
            this.sentences = new ArrayList();
            Collections.sort(list);
            for (Concept concept2 : list) {
                if (bl) {
                    this.sentences.add(new Sentence("Every " + concept.getWord() + " is a " + concept2.getWord() + ".", concept.getOntology()));
                    continue;
                }
                this.sentences.add(new Sentence("Every " + concept2.getWord() + " is a " + concept.getWord() + ".", concept.getOntology()));
            }
            this.updatePage();
        }

        private void updatePage() {
            int n;
            int n2;
            String string;
            this.column.removeAll();
            if (this.up) {
                string = "upward";
                n2 = HierarchyPage.this.upChosenPage;
            } else {
                string = "downward";
                n2 = HierarchyPage.this.downChosenPage;
            }
            if (this.sentences.size() == 0) {
                this.indexBar.setVisible(false);
                this.column.add((Component)new SolidLabel("(" + string + " hierarchy is empty)", 2, 10));
            } else {
                n = (this.sentences.size() - 1) / 15 + 1;
                if (n2 > n) {
                    n2 = 0;
                }
                this.indexBar.setNumbers(n);
                this.indexBar.setActiveButton(n2);
            }
            this.indexBar.setVisible(this.sentences.size() > 15);
            n = this.sentences.size();
            if (n > (n2 + 1) * 15) {
                n = (n2 + 1) * 15;
            }
            for (int i = n2 * 15; i < n; ++i) {
                Row row = new Row();
                row.add((Component)new TextRow(this.sentences.get(i), HierarchyPage.this));
                this.column.add((Component)row);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.indexBar) {
                if (this.up) {
                    HierarchyPage.this.upChosenPage = Integer.parseInt(actionEvent.getActionCommand()) - 1;
                    HierarchyPage.this.log("page", "pressed: page up:" + (HierarchyPage.this.upChosenPage + 1));
                    this.updatePage();
                } else {
                    HierarchyPage.this.downChosenPage = Integer.parseInt(actionEvent.getActionCommand()) - 1;
                    HierarchyPage.this.log("page", "pressed: page down:" + (HierarchyPage.this.downChosenPage + 1));
                    this.updatePage();
                }
            }
        }
    }
}

