/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.gui.ListItem;
import ch.uzh.ifi.attempto.acewiki.gui.Title;
import ch.uzh.ifi.attempto.acewiki.gui.WikiLink;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.echocomp.Label;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import ch.uzh.ifi.attempto.echocomp.Style;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class StartPage
extends WikiPage
implements ActionListener {
    private static final long serialVersionUID = -1528040616289818728L;
    private Column linksColumn = new Column();

    public StartPage(Wiki wiki, String string, String string2) {
        super(wiki, new Title(string == null || string.length() == 0 ? "Untitled Wiki" : string, true));
        Row row;
        this.addSelectedTab("Main Page");
        this.addTab("Index", this);
        this.addTab("Search", this);
        this.add((Component)new VSpace(10));
        if (string2 != null && string2.length() > 0) {
            this.addHeadline("Description");
            row = new Row();
            row.setInsets(new Insets(10, 10, 0, 15));
            row.add((Component)new Label(string2, 2));
            this.add((Component)row);
        }
        this.addHeadline("Largest Articles");
        this.linksColumn.setInsets(new Insets(10, 10, 0, 15));
        this.add((Component)this.linksColumn);
        this.add((Component)new VSpace(20));
        this.addHorizontalLine();
        row = new Row();
        row.setInsets(new Insets(10, 10, 0, 20));
        String string3 = Wiki.getInfo("acewiki-version");
        String string4 = Wiki.getInfo("acewiki-release-stage");
        String string5 = Wiki.getInfo("acewiki-developer");
        String string6 = Wiki.getInfo("acewiki-build-date");
        SolidLabel solidLabel = new SolidLabel("AceWiki " + string3 + " (" + string4 + "), " + string5 + ", " + string6, 2);
        solidLabel.setFont(new Font(Style.fontTypeface, 2, new Extent(10)));
        solidLabel.setForeground(Color.DARKGRAY);
        row.add((Component)solidLabel);
        this.add((Component)row);
        this.update();
    }

    protected void doUpdate() {
        this.linksColumn.removeAll();
        ArrayList<OntologyElement> arrayList = new ArrayList<OntologyElement>(this.getWiki().getOntology().getOntologyElements());
        Collections.sort(arrayList, new Comparator<OntologyElement>(){

            @Override
            public int compare(OntologyElement ontologyElement, OntologyElement ontologyElement2) {
                return ontologyElement2.getSentences().size() - ontologyElement.getSentences().size();
            }
        });
        int n = arrayList.size() > 10 ? 10 : arrayList.size();
        for (int i = 0; i < n; ++i) {
            Row row = new Row();
            row.add((Component)new ListItem(new Component[]{new WikiLink(arrayList.get(i), this.getWiki())}));
            this.linksColumn.add((Component)row);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Index".equals(actionEvent.getActionCommand())) {
            this.getWiki().showIndexPage();
        } else if ("Search".equals(actionEvent.getActionCommand())) {
            this.getWiki().showSearchPage();
        }
    }

    public boolean equals(Object object) {
        return object instanceof StartPage;
    }

    public String toString() {
        return "-MAIN-";
    }
}

