/*
 * Decompiled with CFR 0.152.
 */
package jpl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jpl.Atom;
import jpl.Compound;
import jpl.Float;
import jpl.Integer;
import jpl.JPLException;
import jpl.PrologException;
import jpl.Term;
import jpl.Util;
import jpl.Variable;
import jpl.fli.Prolog;
import jpl.fli.engine_t;
import jpl.fli.predicate_t;
import jpl.fli.qid_t;
import jpl.fli.term_t;

public class Query
implements Enumeration {
    private static Map m = new Hashtable();
    protected final Compound goal_;
    protected final String hostModule = "user";
    protected final String contextModule = "user";
    private boolean open = false;
    private engine_t engine = null;
    private Query subQuery = null;
    private predicate_t predicate = null;
    private term_t term0 = null;
    private qid_t qid = null;

    public final String name() {
        return this.goal_.name();
    }

    public final Term[] args() {
        return this.goal_.args();
    }

    public final Compound goal() {
        return this.goal_;
    }

    public Query(Term term) {
        this.goal_ = this.Query1(term);
    }

    private Compound Query1(Term term) {
        if (term instanceof Compound) {
            return (Compound)term;
        }
        if (term instanceof Integer) {
            throw new JPLException("a Query's goal must be an Atom or Compound (not an Integer)");
        }
        if (term instanceof Float) {
            throw new JPLException("a Query's goal must be an Atom or Compound (not a Float)");
        }
        if (term instanceof Variable) {
            throw new JPLException("a Query's goal must be an Atom or Compound (not a Variable)");
        }
        throw new JPLException("a Query's goal must be an Atom or Compound");
    }

    public Query(String string, Term[] termArray) {
        this(Query.Query1(string, termArray));
    }

    public Query(String string, Term term) {
        this(Query.Query1(string, new Term[]{term}));
    }

    private static Term Query1(String string, Term[] termArray) {
        Term term = Util.textToTerm(string);
        if (term instanceof Atom) {
            return new Compound(string, termArray);
        }
        return term.putParams(termArray);
    }

    public Query(String string) {
        this(Util.textToTerm(string));
    }

    public final synchronized boolean hasMoreSolutions() {
        if (!this.open) {
            this.open();
        }
        return this.get1();
    }

    public final synchronized void open() {
        Term term;
        String string;
        if (this.open) {
            throw new JPLException("Query is already open");
        }
        this.engine = Prolog.thread_self() == -1 ? Prolog.attach_pool_engine() : Prolog.current_engine();
        this.subQuery = m.containsKey(new Long(this.engine.value)) ? (Query)m.get(new Long(this.engine.value)) : null;
        m.put(new Long(this.engine.value), this);
        if (this.goal_.hasFunctor(":", 2)) {
            if (!this.goal_.arg(1).isAtom()) {
                if (this.goal_.arg(1).isVariable()) {
                    throw new PrologException(Util.textParamsToTerm("error(instantiation_error,?)", new Term[]{this.goal_}));
                }
                throw new PrologException(Util.textParamsToTerm("error(type_error(atom,?),?)", new Term[]{this.goal_.arg(1), this.goal_}));
            }
            string = this.goal_.arg(1).name();
            term = this.goal_.arg(2);
        } else {
            string = "user";
            term = this.goal_;
        }
        this.predicate = Prolog.predicate(term.name(), term.arity(), string);
        Hashtable hashtable = new Hashtable();
        this.term0 = Term.putTerms(hashtable, term.args());
        this.qid = Prolog.open_query(Prolog.new_module(Prolog.new_atom("user")), 8, this.predicate, this.term0);
        this.open = true;
    }

    private final boolean get1() {
        if (Prolog.next_solution(this.qid)) {
            return true;
        }
        term_t term_t2 = Prolog.exception(this.qid);
        if (term_t2.value != 0L) {
            Term term = Term.getTerm(new Hashtable(), term_t2);
            this.close();
            throw new PrologException(term);
        }
        this.close();
        return false;
    }

    public final synchronized Hashtable getSolution() {
        if (this.get1()) {
            return this.get2();
        }
        return null;
    }

    public final synchronized Hashtable getSubstWithNameVars() {
        if (this.get1()) {
            return this.get2WithNameVars();
        }
        return null;
    }

    public final synchronized Hashtable nextSolution() {
        return this.get2();
    }

    private final Hashtable get2() {
        if (!this.open) {
            throw new JPLException("Query is not open");
        }
        Hashtable hashtable = new Hashtable();
        Term.getSubsts(hashtable, new Hashtable(), this.goal_.args);
        return hashtable;
    }

    private final Hashtable get2WithNameVars() {
        if (!this.open) {
            throw new JPLException("Query is not open");
        }
        Term[] termArray = this.goal_.args;
        Term term = termArray[termArray.length - 1];
        String string = ((Variable)term).name;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        termArray[termArray.length - 1].getSubst(hashtable, hashtable2);
        Hashtable hashtable3 = new Hashtable();
        Term term2 = (Term)hashtable.get(string);
        Map map = Util.namevarsToMap(term2);
        for (int i = 0; i < termArray.length - 1; ++i) {
            termArray[i].getSubst(hashtable3, map);
        }
        return hashtable3;
    }

    public final synchronized boolean hasMoreElements() {
        return this.hasMoreSolutions();
    }

    public final synchronized Object nextElement() {
        return this.nextSolution();
    }

    public final synchronized void rewind() {
        this.close();
    }

    public final synchronized void close() {
        if (!this.open) {
            return;
        }
        if (Prolog.thread_self() == -1) {
            throw new JPLException("no engine is attached to this thread");
        }
        if (Prolog.current_engine().value != this.engine.value) {
            throw new JPLException("this Query's engine is not that which is attached to this thread");
        }
        Query query = (Query)m.get(new Long(this.engine.value));
        if (query != this) {
            throw new JPLException("this Query (" + this.hashCode() + ":" + this.toString() + ") is not topmost (" + query.hashCode() + ":" + query.toString() + ") within its engine[" + this.engine.value + "]");
        }
        Prolog.close_query(this.qid);
        this.qid = null;
        m.remove(new Long(this.engine.value));
        if (this.subQuery == null) {
            if (Prolog.current_engine_is_pool()) {
                Prolog.release_pool_engine();
            }
        } else {
            m.put(new Long(this.engine.value), this.subQuery);
        }
        this.open = false;
        this.engine = null;
        this.subQuery = null;
    }

    public final synchronized Hashtable[] allSolutions() {
        if (this.open) {
            throw new JPLException("Query is already open");
        }
        Vector<Hashtable> vector = new Vector<Hashtable>();
        while (this.hasMoreSolutions()) {
            vector.addElement(this.nextSolution());
        }
        Object[] objectArray = new Hashtable[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static final Hashtable[] allSolutions(Term term) {
        return new Query(term).allSolutions();
    }

    public static final Hashtable[] allSolutions(String string) {
        return new Query(string).allSolutions();
    }

    public static final Hashtable[] allSolutions(String string, Term[] termArray) {
        return new Query(string, termArray).allSolutions();
    }

    public final synchronized Hashtable[] nSolutions(long l) {
        if (this.open) {
            throw new JPLException("Query is already open");
        }
        Vector<Hashtable> vector = new Vector<Hashtable>();
        long l2 = 0L;
        while (l2++ < l && this.hasMoreSolutions()) {
            vector.addElement(this.nextSolution());
        }
        Object[] objectArray = new Hashtable[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static final Hashtable[] nSolutions(Term term, long l) {
        return new Query(term).nSolutions(l);
    }

    public static final Hashtable[] nSolutions(String string, long l) {
        return new Query(string).nSolutions(l);
    }

    public static final Hashtable[] nSolutions(String string, Term[] termArray, long l) {
        return new Query(string, termArray).nSolutions(l);
    }

    public final synchronized Hashtable oneSolution() {
        Hashtable hashtable;
        if (this.open) {
            throw new JPLException("Query is already open");
        }
        if (this.hasMoreSolutions()) {
            hashtable = this.nextSolution();
            this.close();
        } else {
            hashtable = null;
        }
        return hashtable;
    }

    public static final Hashtable oneSolution(Term term) {
        return new Query(term).oneSolution();
    }

    public static final Hashtable oneSolution(String string) {
        return new Query(string).oneSolution();
    }

    public static final Hashtable oneSolution(String string, Term[] termArray) {
        return new Query(string, termArray).oneSolution();
    }

    public final synchronized boolean query() {
        return this.oneSolution() != null;
    }

    public final synchronized boolean hasSolution() {
        return this.oneSolution() != null;
    }

    public static final boolean hasSolution(Term term) {
        return new Query(term).hasSolution();
    }

    public static final boolean hasSolution(String string) {
        return new Query(string).hasSolution();
    }

    public static final boolean hasSolution(String string, Term[] termArray) {
        return new Query(string, termArray).hasSolution();
    }

    public final int abort() {
        if (this.open) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            return 0;
        }
        System.out.println("q.abort(): query is not open");
        return -1;
    }

    public String toString() {
        return this.goal_.name + "( " + Term.toString(this.goal_.args) + " )";
    }

    public String debugString() {
        return "(Query " + this.goal_.name + " " + Term.debugString(this.goal_.args) + ")";
    }

    static /* synthetic */ engine_t access$000(Query query) {
        return query.engine;
    }
}

