/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.preditor;

import ch.uzh.ifi.attempto.chartparser.ChartParser;
import ch.uzh.ifi.attempto.chartparser.Grammar;
import ch.uzh.ifi.attempto.echocomp.GeneralButton;
import ch.uzh.ifi.attempto.echocomp.Label;
import ch.uzh.ifi.attempto.echocomp.Style;
import ch.uzh.ifi.attempto.echocomp.TextField;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import ch.uzh.ifi.attempto.preditor.MenuBlock;
import ch.uzh.ifi.attempto.preditor.MenuBlockContent;
import ch.uzh.ifi.attempto.preditor.MenuCreator;
import ch.uzh.ifi.attempto.preditor.MenuEntry;
import ch.uzh.ifi.attempto.preditor.text.TextContainer;
import ch.uzh.ifi.attempto.preditor.text.TextElement;
import echopointng.KeyStrokeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.TextArea;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreditorWindow
extends WindowPane
implements ActionListener {
    private static final long serialVersionUID = -7815494421993305554L;
    private List<MenuBlockContent> menuBlockContents = new ArrayList<MenuBlockContent>();
    private List<MenuBlock> menuBlocksTop = new ArrayList<MenuBlock>();
    private List<MenuBlock> menuBlocksBottom = new ArrayList<MenuBlock>();
    private List<SplitPane> menuSplitPanesTop = new ArrayList<SplitPane>();
    private List<SplitPane> menuSplitPanesBottom = new ArrayList<SplitPane>();
    private TextArea textArea = new TextArea();
    private TextField textField;
    private SplitPane menuBlockPane = new SplitPane(3, new Extent(0));
    private SplitPane doubleColumnMenuPane = new SplitPane(5, new Extent(258));
    private GeneralButton deleteButton = new GeneralButton("< Delete", 70, this);
    private KeyStrokeListener keyStrokeListener = new KeyStrokeListener();
    private TextContainer newTextContainer = new TextContainer();
    private MenuCreator menuCreator;
    private ChartParser parser;
    private Button okButton = new GeneralButton("OK", 70, this);
    private Button cancelButton = new GeneralButton("Cancel", 70, this);
    private ArrayList<ActionListener> actionListeners = new ArrayList();

    public PreditorWindow(String string, Grammar grammar, MenuCreator menuCreator) {
        SplitPane splitPane;
        MenuBlock menuBlock;
        int n;
        this.parser = new ChartParser(grammar);
        this.menuCreator = menuCreator;
        this.setModal(true);
        this.setTitle(string);
        this.setTitleFont(new Font(Style.fontTypeface, 2, new Extent(13)));
        this.setWidth(new Extent(753));
        this.setHeight(new Extent(503));
        this.setResizable(false);
        this.setTitleBackground(Style.windowTitleBackground);
        this.setStyleName("Default");
        Row row = new Row();
        row.setAlignment(new Alignment(5, 4));
        row.setInsets(new Insets(10, 17, 10, 10));
        row.setCellSpacing(new Extent(5));
        row.add((Component)this.okButton);
        row.add((Component)this.cancelButton);
        SplitPane splitPane2 = new SplitPane(6, new Extent(47));
        splitPane2.add((Component)row);
        this.add((Component)splitPane2);
        SplitPane splitPane3 = new SplitPane(5, new Extent(148));
        Column column = new Column();
        column.setInsets(new Insets(10, 10, 0, 0));
        column.setCellSpacing(new Extent(10));
        Column column2 = new Column();
        this.textArea.setWidth(new Extent(702));
        this.textArea.setHeight(new Extent(42));
        this.textArea.setEnabled(false);
        this.textArea.setFont(new Font(Style.fontTypeface, 0, new Extent(12)));
        this.textArea.setBorder(new Border(1, new Color(180, 180, 180), 1));
        this.textArea.setInsets(new Insets(4, 4));
        this.textArea.setBackground(new Color(255, 255, 255));
        this.textArea.setFocusTraversalParticipant(false);
        column2.add((Component)this.textArea);
        Row row2 = new Row();
        row2.setAlignment(new Alignment(5, 4));
        row2.setInsets(new Insets(0, 5, 10, 0));
        row2.setCellSpacing(new Extent(5));
        this.deleteButton.setFocusTraversalParticipant(false);
        row2.add((Component)this.deleteButton);
        column2.add((Component)row2);
        column.add((Component)column2);
        Column column3 = new Column();
        column3.setCellSpacing(new Extent(1));
        Label label = new Label("text", 2, 11);
        column3.add((Component)label);
        this.textField = new TextField(this);
        this.textField.setWidth(new Extent(708));
        this.textField.setFocusTraversalParticipant(true);
        this.textField.setFocusTraversalIndex(0);
        this.textField.setDisabledBackground(Style.lightDisabled);
        Row row3 = new Row();
        row3.add((Component)this.textField);
        TextField textField = new TextField();
        textField.setWidth(new Extent(1));
        textField.setBorder(new Border(0, null, 0));
        textField.setBackground(Color.WHITE);
        row3.add((Component)textField);
        column3.add((Component)row3);
        this.keyStrokeListener.addKeyCombination(9, "Tab");
        this.keyStrokeListener.addKeyCombination(39, "Tab");
        this.keyStrokeListener.addActionListener((ActionListener)this);
        column3.add((Component)this.keyStrokeListener);
        column.add((Component)column3);
        splitPane3.add((Component)column);
        this.menuBlockPane.setSeparatorWidth(new Extent(10));
        this.menuBlockPane.setSeparatorColor(Color.WHITE);
        this.menuBlockPane.add((Component)new Label());
        SplitPane splitPane4 = this.doubleColumnMenuPane;
        for (n = 0; n < 10; ++n) {
            menuBlock = new MenuBlock(this, this);
            this.menuBlocksTop.add(menuBlock);
            splitPane = new SplitPane(3);
            splitPane.setSeparatorWidth(new Extent(10));
            splitPane.setSeparatorColor(Color.WHITE);
            splitPane.setVisible(false);
            splitPane.add((Component)menuBlock);
            this.menuSplitPanesTop.add(splitPane);
            splitPane4.add((Component)splitPane);
            splitPane4 = splitPane;
        }
        splitPane4 = this.doubleColumnMenuPane;
        for (n = 0; n < 10; ++n) {
            menuBlock = new MenuBlock(this, this);
            this.menuBlocksBottom.add(menuBlock);
            splitPane = new SplitPane(3);
            splitPane.setSeparatorWidth(new Extent(10));
            splitPane.setSeparatorColor(Color.WHITE);
            splitPane.setVisible(false);
            splitPane.add((Component)menuBlock);
            this.menuSplitPanesBottom.add(splitPane);
            splitPane4.add((Component)splitPane);
            splitPane4 = splitPane;
        }
        this.doubleColumnMenuPane.setSeparatorHeight(new Extent(12));
        this.doubleColumnMenuPane.setSeparatorColor(Color.WHITE);
        this.menuBlockPane.add((Component)this.doubleColumnMenuPane);
        splitPane3.add((Component)this.menuBlockPane);
        splitPane2.add((Component)splitPane3);
        this.update();
    }

    public TextContainer getTextContainer() {
        return this.newTextContainer;
    }

    public TextElement getPossibleNextToken(String string) {
        for (MenuBlockContent menuBlockContent : this.menuBlockContents) {
            TextElement textElement = menuBlockContent.getEntry(string);
            if (textElement == null) continue;
            return textElement;
        }
        return null;
    }

    public void addTextElement(TextElement textElement) {
        this.textElementSelected(textElement);
        this.textField.setText("");
        this.update();
    }

    public void addText(String string) {
        this.handleTextInput(this.tokenize(string));
        this.update();
    }

    private void textElementSelected(TextElement textElement) {
        this.newTextContainer.addElement(textElement);
        this.parser.addToken(textElement.getCategory());
        this.log("edit", "words added: " + textElement.getText());
    }

    private int getElementsCount() {
        int n = 0;
        for (MenuBlockContent menuBlockContent : this.menuBlockContents) {
            n += menuBlockContent.getEntries().size();
        }
        return n;
    }

    private String getStartString() {
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MenuBlockContent menuBlockContent : this.menuBlockContents) {
            String string2 = menuBlockContent.getStartString();
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        String string3 = (String)arrayList.get(0);
        arrayList.remove(0);
        if (arrayList.isEmpty()) {
            return string3;
        }
        for (int i = 0; i < string3.length(); ++i) {
            char c = string3.charAt(i);
            boolean bl = false;
            for (String string4 : arrayList) {
                if (string4.length() > i && string4.charAt(i) == c) continue;
                bl = true;
            }
            if (bl) break;
            string = string + c;
        }
        return string;
    }

    private void update() {
        this.updateMenuBlockContents();
        this.setFilter(this.textField.getText());
        int n = this.menuBlockContents.size();
        if (n < 5) {
            int n2 = 720 / (n > 3 ? n : 3) - 10;
            for (int i = 0; i < this.menuBlocksTop.size(); ++i) {
                if (this.menuBlockContents.size() > i) {
                    this.menuBlocksTop.get(i).setContent(this.menuBlockContents.get(i), n2, 16);
                    this.menuSplitPanesTop.get(i).setSeparatorPosition(new Extent(n2));
                    this.menuSplitPanesTop.get(i).setVisible(true);
                    continue;
                }
                this.menuSplitPanesTop.get(i).setVisible(false);
            }
            this.doubleColumnMenuPane.setSeparatorPosition(new Extent(258));
        } else {
            int n3;
            int n4 = (n + 1) / 2;
            int n5 = 720 / n4 - 10;
            for (n3 = 0; n3 < this.menuBlocksTop.size(); ++n3) {
                if (n3 < n4) {
                    this.menuBlocksTop.get(n3).setContent(this.menuBlockContents.get(n3), n5, 7);
                    this.menuSplitPanesTop.get(n3).setSeparatorPosition(new Extent(n5));
                    this.menuSplitPanesTop.get(n3).setVisible(true);
                    continue;
                }
                this.menuSplitPanesTop.get(n3).setVisible(false);
            }
            for (n3 = 0; n3 < this.menuBlocksBottom.size(); ++n3) {
                if (n4 + n3 < n) {
                    this.menuBlocksBottom.get(n3).setContent(this.menuBlockContents.get(n4 + n3), n5, 7);
                    this.menuSplitPanesBottom.get(n3).setSeparatorPosition(new Extent(n5));
                    this.menuSplitPanesBottom.get(n3).setVisible(true);
                    continue;
                }
                this.menuSplitPanesBottom.get(n3).setVisible(false);
            }
            this.doubleColumnMenuPane.setSeparatorPosition(new Extent(123));
        }
        this.textField.setEnabled(this.menuBlockContents.size() > 0 || !this.textField.getText().equals(""));
        ApplicationInstance.getActive().setFocusedComponent((Component)this.textField);
        this.deleteButton.setEnabled(this.textArea.getText().length() > 0);
    }

    private void updateMenuBlockContents() {
        this.textArea.setText(this.newTextContainer.getText());
        this.menuBlockContents.clear();
        List<MenuBlockContent> list = this.menuCreator.createMenu(this.parser, this.newTextContainer);
        for (MenuBlockContent menuBlockContent : list) {
            if (menuBlockContent.isEmpty()) continue;
            this.menuBlockContents.add(menuBlockContent);
        }
    }

    private void setFilter(String string) {
        for (MenuBlockContent menuBlockContent : this.menuBlockContents) {
            menuBlockContent.setFilter(string);
        }
    }

    private void handleTextInput() {
        this.addText(this.textField.getText());
    }

    private void handleTextInput(ArrayList<String> arrayList) {
        TextElement object = null;
        String string = "";
        int n = 0;
        for (String object2 : arrayList) {
            this.setFilter(string + object2);
            TextElement textElement = this.getPossibleNextToken(string + object2);
            if (textElement != null) {
                object = textElement;
                ++n;
                break;
            }
            if (this.getElementsCount() == 0) break;
            string = string + object2 + " ";
            ++n;
        }
        this.setFilter(null);
        if (object != null) {
            this.textElementSelected(object);
            this.updateMenuBlockContents();
            for (int i = 0; i < n; ++i) {
                arrayList.remove(0);
            }
            this.handleTextInput(arrayList);
        } else {
            Object object4 = "";
            for (String string2 : arrayList) {
                if (((String)object4).length() > 0) {
                    object4 = (String)object4 + " ";
                }
                object4 = (String)object4 + string2;
            }
            this.textField.setText((String)object4);
        }
    }

    private ArrayList<String> tokenize(String string) {
        string = string.replaceAll("\\.", " . ");
        string = string.replaceAll("\\?", " ? ");
        string = string.replaceAll("\\!", " ! ");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string.split(" ")));
        while (arrayList.contains("")) {
            arrayList.remove("");
        }
        return arrayList;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    public void removeAllActionListeners() {
        this.actionListeners.clear();
    }

    private void notifyActionListeners(ActionEvent actionEvent) {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getSource() == this.cancelButton) {
            this.log("edit", "pressed: cancel");
            this.notifyActionListeners(new ActionEvent((Object)this, "Cancel"));
            return;
        }
        if (actionEvent.getSource() == this.okButton) {
            this.log("edit", "pressed: ok");
            this.handleTextInput();
            this.update();
            this.notifyActionListeners(new ActionEvent((Object)this, "OK"));
            return;
        }
        if (actionEvent.getSource() == this.deleteButton) {
            this.log("edit", "pressed: < delete");
            this.newTextContainer.removeLastElement();
            this.parser.removeToken();
            this.textField.setText("");
        } else if (actionEvent.getSource() instanceof MenuEntry) {
            object = ((MenuEntry)actionEvent.getSource()).getTextElement();
            this.log("edit", "pressed: menu-entry " + object.getText());
            this.textElementSelected((TextElement)object);
            this.textField.setText("");
        } else if (actionEvent.getSource() == this.textField) {
            this.log("edit", "pressed: enter-key");
            this.handleTextInput();
        } else if ("Tab".equals(actionEvent.getActionCommand())) {
            this.log("edit", "pressed: tab-key");
            this.handleTextInput();
        }
        this.update();
        if ("Tab".equals(actionEvent.getActionCommand()) && (object = this.getStartString()) != null) {
            this.textField.setText((String)object);
        }
    }

    private void log(String string, String string2) {
    }

    public String toString() {
        return "sentence: " + this.newTextContainer.getText();
    }
}

