/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webrender.output;

import nextapp.echo2.webrender.output.XmlDocument;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class HtmlDocument
extends XmlDocument {
    public static final String XHTML_1_0_TRANSITIONAL_PUBLIC_ID = "-//W3C//DTD XHTML 1.0 Transitional//EN";
    public static final String XHTML_1_0_TRANSITIONAL_SYSTSEM_ID = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    public static final String XHTML_1_0_NAMESPACE_URI = "http://www.w3.org/1999/xhtml";

    public HtmlDocument(String publicId, String systemId, String namespaceUri) {
        super("html", publicId, systemId, namespaceUri);
        Document document = this.getDocument();
        Element htmlElement = document.getDocumentElement();
        Element headElement = document.createElement("head");
        Element titleElement = document.createElement("title");
        titleElement.appendChild(document.createTextNode(" "));
        Element bodyElement = document.createElement("body");
        htmlElement.appendChild(headElement);
        headElement.appendChild(titleElement);
        htmlElement.appendChild(bodyElement);
    }

    public void addJavaScriptText(String code) {
        Document document = this.getDocument();
        Element headElement = (Element)document.getElementsByTagName("head").item(0);
        Element scriptElement = document.createElement("script");
        Text textNode = document.createTextNode(code);
        scriptElement.appendChild(textNode);
        scriptElement.setAttribute("type", "text/javascript");
        headElement.appendChild(scriptElement);
    }

    public void addJavaScriptInclude(String uri) {
        Document document = this.getDocument();
        Element headElement = (Element)document.getElementsByTagName("head").item(0);
        Element scriptElement = document.createElement("script");
        Text textNode = document.createTextNode(" ");
        scriptElement.appendChild(textNode);
        scriptElement.setAttribute("type", "text/javascript");
        scriptElement.setAttribute("src", uri);
        headElement.appendChild(scriptElement);
    }

    public Element getBodyElement() {
        return (Element)this.getDocument().getElementsByTagName("body").item(0);
    }

    public Element getHeadElement() {
        return (Element)this.getDocument().getElementsByTagName("head").item(0);
    }

    public void setGenarator(String value) {
        Element metaGeneratorElement = this.getDocument().createElement("meta");
        metaGeneratorElement.setAttribute("name", "generator");
        metaGeneratorElement.setAttribute("content", value);
        this.getHeadElement().appendChild(metaGeneratorElement);
    }

    public void setTitle(String value) {
        NodeList titles = this.getDocument().getElementsByTagName("title");
        if (titles.getLength() == 1) {
            DomUtil.setElementText((Element)titles.item(0), value == null ? "" : value);
        }
    }
}

