/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webrender.service;

import java.io.IOException;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.util.GZipCompressor;
import nextapp.echo2.webrender.util.JavaScriptCompressor;
import nextapp.echo2.webrender.util.Resource;

public class JavaScriptService
implements Service {
    private String id;
    private String content;
    private byte[] gzipContent;

    public static JavaScriptService forResource(String id, String resourceName) {
        String content = Resource.getResourceAsString(resourceName);
        return new JavaScriptService(id, content);
    }

    public JavaScriptService(String id, String content) {
        this.id = id;
        this.content = JavaScriptCompressor.compress(content);
        try {
            this.gzipContent = GZipCompressor.compress(this.content);
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception compressing JavaScript source.", ex);
        }
    }

    public String getId() {
        return this.id;
    }

    public int getVersion() {
        return -1;
    }

    public void service(Connection conn) throws IOException {
        String userAgent = conn.getRequest().getHeader("user-agent");
        if (userAgent == null || userAgent.indexOf("MSIE") != -1) {
            this.servicePlain(conn);
        } else {
            String acceptEncoding = conn.getRequest().getHeader("accept-encoding");
            if (acceptEncoding != null && acceptEncoding.indexOf("gzip") != -1) {
                this.serviceGZipCompressed(conn);
            } else {
                this.servicePlain(conn);
            }
        }
    }

    private void serviceGZipCompressed(Connection conn) throws IOException {
        conn.getResponse().setContentType("text/plain");
        conn.getResponse().setHeader("Content-Encoding", "gzip");
        conn.getOutputStream().write(this.gzipContent);
    }

    private void servicePlain(Connection conn) throws IOException {
        conn.getResponse().setContentType("text/plain");
        conn.getWriter().print(this.content);
    }
}

