/*
 * Decompiled with CFR 0.152.
 */
package org.coode.manchesterowlsyntax;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.coode.manchesterowlsyntax.ManchesterOWLSyntax;
import org.semanticweb.owl.expression.OWLEntityChecker;
import org.semanticweb.owl.expression.ParserException;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLPropertyExpression;
import org.semanticweb.owl.model.OWLQuantifiedRestriction;
import org.semanticweb.owl.model.SetOntologyURI;
import org.semanticweb.owl.util.CollectionFactory;
import org.semanticweb.owl.util.NamespaceUtil;
import org.semanticweb.owl.vocab.Namespaces;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterOWLSyntaxEditorParser {
    private OWLDataFactory dataFactory;
    private OWLEntityChecker owlEntityChecker;
    private final String EOF = "<EOF>";
    private Set<Character> skip = new HashSet<Character>();
    private Set<Character> delims = new HashSet<Character>();
    private Set<Character> escapeChars = new HashSet<Character>();
    private String base;
    private Set<String> classNames;
    private Set<String> objectPropertyNames;
    private Set<String> dataPropertyNames;
    private Set<String> individualNames;
    private Set<String> dataTypeNames;
    private Set<String> annotationURIs;
    private Set<String> restrictionKeywords;
    private Map<String, URI> namespaceMap;
    private int col = 0;
    private int tokenStartCol = 0;
    private int line = 0;
    private int tokenStartPos;
    private String token;
    private String bufferedToken = null;
    private String buffer;
    private int pos;
    private static final String AND = ManchesterOWLSyntax.AND.toString();
    private static final String OR = ManchesterOWLSyntax.OR.toString();
    private static final String INV = ManchesterOWLSyntax.INVERSE.toString();
    private static final String SOME = ManchesterOWLSyntax.SOME.toString();
    private static final String SELF = ManchesterOWLSyntax.SELF.toString();
    private static final String ONLY = ManchesterOWLSyntax.ONLY.toString();
    private static final String VALUE = ManchesterOWLSyntax.VALUE.toString();
    private static final String MIN = ManchesterOWLSyntax.MIN.toString();
    private static final String MAX = ManchesterOWLSyntax.MAX.toString();
    private static final String EXACTLY = ManchesterOWLSyntax.EXACTLY.toString();
    private static final String ONLYSOME = ManchesterOWLSyntax.ONLYSOME.toString();
    private static final String NOT = ManchesterOWLSyntax.NOT.toString();
    private static final String CLASS = ManchesterOWLSyntax.CLASS.toString() + ":";
    private static final String SUB_CLASS_OF = ManchesterOWLSyntax.SUBCLASS_OF.toString() + ":";
    private static final String EQUIVALENT_TO = ManchesterOWLSyntax.EQUIVALENT_TO.toString() + ":";
    private static final String DISJOINT_WITH = ManchesterOWLSyntax.DISJOINT_WITH.toString() + ":";
    private static final String OBJECT_PROPERTY = ManchesterOWLSyntax.OBJECT_PROPERTY.toString() + ":";
    private static final String DATA_PROPERTY = ManchesterOWLSyntax.DATA_PROPERTY.toString() + ":";
    private static final String SUB_PROPERTY_OF = ManchesterOWLSyntax.SUB_PROPERTY_OF.toString() + ":";
    private static final String DOMAIN = ManchesterOWLSyntax.DOMAIN.toString() + ":";
    private static final String RANGE = ManchesterOWLSyntax.RANGE.toString() + ":";
    private static final String CHARACTERISTICS = ManchesterOWLSyntax.CHARACTERISTICS.toString() + ":";
    private static final String INDIVIDUAL = ManchesterOWLSyntax.INDIVIDUAL.toString() + ":";
    private static final String ANNOTATIONS = ManchesterOWLSyntax.ANNOTATIONS.toString() + ":";
    private static final String TYPES = ManchesterOWLSyntax.TYPES.toString() + ":";
    private static final String FACTS = ManchesterOWLSyntax.FACTS.toString() + ":";
    private static final String SAME_AS = ManchesterOWLSyntax.SAME_AS.toString() + ":";
    private static final String DIFFERENT_FROM = ManchesterOWLSyntax.DIFFERENT_FROM.toString() + ":";
    private static final String VALUE_PARTITION = "ValuePartition:";
    private static final String ONTOLOGY = ManchesterOWLSyntax.ONTOLOGY.toString() + ":";
    private static final String NAMESPACE = ManchesterOWLSyntax.NAMESPACE.toString() + ":";
    private static final String IMPORTS = ManchesterOWLSyntax.IMPORTS.toString() + ":";
    private static final String FUNCTIONAL = ManchesterOWLSyntax.FUNCTIONAL.toString();
    private static final String INVERSE_FUNCTIONAL = ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString();
    private static final String SYMMETRIC = ManchesterOWLSyntax.SYMMETRIC.toString();
    private static final String ANTI_SYMMETRIC = ManchesterOWLSyntax.ANTI_SYMMETRIC.toString();
    private static final String TRANSITIVE = ManchesterOWLSyntax.TRANSITIVE.toString();
    private static final String REFLEXIVE = ManchesterOWLSyntax.REFLEXIVE.toString();
    private static final String IRREFLEXIVE = ManchesterOWLSyntax.IRREFLEXIVE.toString();
    private static final String INVERSE_OF = (Object)((Object)ManchesterOWLSyntax.INVERSE_OF) + ":";
    private Set<String> potentialKeywords;
    private Map<String, URI> nameURIMap = new HashMap<String, URI>();

    public ManchesterOWLSyntaxEditorParser(OWLDataFactory dataFactory, String s) {
        this.dataFactory = dataFactory;
        this.skip.add(Character.valueOf(' '));
        this.skip.add(Character.valueOf('\n'));
        this.skip.add(Character.valueOf('\t'));
        this.delims.add(Character.valueOf('('));
        this.delims.add(Character.valueOf(')'));
        this.delims.add(Character.valueOf('['));
        this.delims.add(Character.valueOf(']'));
        this.delims.add(Character.valueOf(','));
        this.delims.add(Character.valueOf('{'));
        this.delims.add(Character.valueOf('}'));
        this.delims.add(Character.valueOf('^'));
        this.delims.add(Character.valueOf('@'));
        this.escapeChars.add(Character.valueOf('\''));
        this.escapeChars.add(Character.valueOf('\"'));
        this.potentialKeywords = new HashSet<String>();
        this.restrictionKeywords = new HashSet<String>();
        this.restrictionKeywords.add(ManchesterOWLSyntax.SOME.toString());
        this.restrictionKeywords.add(ManchesterOWLSyntax.ONLY.toString());
        this.restrictionKeywords.add(ManchesterOWLSyntax.MIN.toString());
        this.restrictionKeywords.add(ManchesterOWLSyntax.MAX.toString());
        this.restrictionKeywords.add(ManchesterOWLSyntax.EXACTLY.toString());
        this.restrictionKeywords.add(ManchesterOWLSyntax.VALUE.toString());
        this.restrictionKeywords.add(ManchesterOWLSyntax.THAT.toString());
        this.classNames = new HashSet<String>();
        this.objectPropertyNames = new HashSet<String>();
        this.dataPropertyNames = new HashSet<String>();
        this.individualNames = new HashSet<String>();
        this.dataTypeNames = new HashSet<String>();
        this.annotationURIs = new HashSet<String>();
        this.namespaceMap = new HashMap<String, URI>();
        NamespaceUtil u = new NamespaceUtil();
        for (URI uri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTIES) {
            String[] res = u.split(uri.toString(), null);
            this.annotationURIs.add(u.getPrefix(res[0]) + ":" + res[1]);
        }
        this.pos = 0;
        this.buffer = s;
        this.base = "http://www.semanticweb.org#";
        this.owlEntityChecker = new DefaultEntityChecker();
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public OWLEntityChecker getOWLEntityChecker() {
        return this.owlEntityChecker;
    }

    public void setOWLEntityChecker(OWLEntityChecker owlEntityChecker) {
        this.owlEntityChecker = owlEntityChecker;
    }

    public boolean isClassName(String name) {
        if (this.classNames.contains(name)) {
            return true;
        }
        return this.owlEntityChecker != null && this.owlEntityChecker.getOWLClass(name) != null;
    }

    public boolean isObjectPropertyName(String name) {
        if (this.objectPropertyNames.contains(name)) {
            return true;
        }
        return this.owlEntityChecker != null && this.owlEntityChecker.getOWLObjectProperty(name) != null;
    }

    public boolean isAnnotationURI(String name) {
        return this.annotationURIs.contains(name);
    }

    public boolean isDataPropertyName(String name) {
        if (this.dataPropertyNames.contains(name)) {
            return true;
        }
        return this.owlEntityChecker != null && this.owlEntityChecker.getOWLDataProperty(name) != null;
    }

    public boolean isIndividualName(String name) {
        if (this.individualNames.contains(name)) {
            return true;
        }
        return this.owlEntityChecker != null && this.owlEntityChecker.getOWLIndividual(name) != null;
    }

    public boolean isDatatypeName(String name) {
        if (this.dataTypeNames.contains(name)) {
            return true;
        }
        return this.owlEntityChecker != null && this.owlEntityChecker.getOWLDataType(name) != null;
    }

    public OWLClass getOWLClass(String name) {
        return this.owlEntityChecker.getOWLClass(name);
    }

    public OWLObjectProperty getOWLObjectProperty(String name) {
        return this.owlEntityChecker.getOWLObjectProperty(name);
    }

    public OWLIndividual getOWLIndividual(String name) {
        return this.owlEntityChecker.getOWLIndividual(name);
    }

    public OWLDataProperty getOWLDataProperty(String name) {
        return this.owlEntityChecker.getOWLDataProperty(name);
    }

    public OWLDataType getDataType(String name) {
        return this.dataFactory.getOWLDataType(URI.create((Object)((Object)Namespaces.XSD) + name));
    }

    public URI getAnnotationURI(String name) {
        if (name.startsWith("rdfs:")) {
            return URI.create((Object)((Object)Namespaces.RDFS) + name.substring(5, name.length()));
        }
        if (name.startsWith("owl:")) {
            return URI.create((Object)((Object)Namespaces.RDFS) + name.substring(4, name.length()));
        }
        return URI.create(this.base + name);
    }

    private String getLastToken() {
        return this.token;
    }

    private String peekToken() {
        String tok;
        this.bufferedToken = tok = this.readToken();
        return tok;
    }

    private String readToken() {
        char ch;
        if (this.bufferedToken != null) {
            this.token = this.bufferedToken;
            this.bufferedToken = null;
            return this.token;
        }
        while (this.pos < this.buffer.length() && this.skip.contains(Character.valueOf(ch = this.buffer.charAt(this.pos)))) {
            if (ch == '\n') {
                ++this.line;
                this.col = 0;
            }
            ++this.col;
            ++this.pos;
        }
        this.tokenStartPos = this.pos;
        this.tokenStartCol = this.col;
        if (this.pos >= this.buffer.length()) {
            this.token = "<EOF>";
        } else if (this.pos + 1 == this.buffer.length() && this.escapeChars.contains(Character.valueOf(this.buffer.charAt(this.pos)))) {
            this.token = "<EOF>";
        } else if (this.delims.contains(Character.valueOf(this.buffer.charAt(this.pos)))) {
            ++this.pos;
            ++this.col;
            this.token = this.buffer.substring(this.pos - 1, this.pos);
        } else {
            int start = this.pos;
            boolean inEscapedString = false;
            while (this.pos < this.buffer.length()) {
                char ch2 = this.buffer.charAt(this.pos);
                if (this.escapeChars.contains(Character.valueOf(ch2)) && !inEscapedString) {
                    inEscapedString = true;
                    ++start;
                } else {
                    if (this.escapeChars.contains(Character.valueOf(ch2)) && inEscapedString) {
                        this.token = ch2 == '\'' ? this.buffer.substring(start, this.pos) : this.buffer.substring(start - 1, this.pos + 1);
                        inEscapedString = false;
                        ++this.pos;
                        return this.token;
                    }
                    if (!inEscapedString && (this.skip.contains(Character.valueOf(ch2)) || this.delims.contains(Character.valueOf(ch2)))) {
                        this.token = this.buffer.substring(start, this.pos);
                        return this.token;
                    }
                }
                ++this.col;
                ++this.pos;
            }
            if (start != this.pos) {
                this.token = this.buffer.substring(start, this.pos);
            }
        }
        return this.token;
    }

    public OWLDescription parseDescription() throws ParserException {
        OWLDescription desc = this.parseIntersection();
        if (!this.readToken().equals("<EOF>")) {
            this.throwException("<EOF>");
        }
        return desc;
    }

    public OWLDescription parseIntersection() throws ParserException {
        HashSet<OWLDescription> ops = new HashSet<OWLDescription>();
        String kw = AND;
        while (kw.equalsIgnoreCase(AND)) {
            this.potentialKeywords.remove(AND);
            ops.add(this.parseUnion());
            this.potentialKeywords.add(AND);
            kw = this.peekToken();
            if (kw.equalsIgnoreCase(AND)) {
                kw = this.readToken();
                continue;
            }
            if (!kw.equalsIgnoreCase("that")) continue;
            this.readToken();
            kw = AND;
        }
        if (ops.size() == 1) {
            return (OWLDescription)ops.iterator().next();
        }
        return this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    public OWLDescription parseUnion() throws ParserException {
        HashSet<OWLDescription> ops = new HashSet<OWLDescription>();
        String kw = OR;
        while (kw.equalsIgnoreCase(OR)) {
            this.potentialKeywords.remove(OR);
            ops.add(this.parseNonNaryDescription());
            this.potentialKeywords.add(OR);
            kw = this.peekToken();
            if (!kw.equalsIgnoreCase(OR)) continue;
            kw = this.readToken();
        }
        if (ops.size() == 1) {
            return (OWLDescription)ops.iterator().next();
        }
        return this.dataFactory.getOWLObjectUnionOf(ops);
    }

    public OWLObjectPropertyExpression parseObjectPropertyExpression(boolean allowUndeclared) throws ParserException {
        String tok = this.readToken();
        if (tok.equalsIgnoreCase(INV)) {
            String open = this.readToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.readToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLObjectPropertyInverse(prop);
        }
        if (!allowUndeclared && !this.isObjectPropertyName(tok)) {
            this.throwException(false, true, false, false, false, INV);
        }
        return this.getOWLObjectProperty(tok);
    }

    public OWLObjectPropertyExpression parseObjectPropertyExpression() throws ParserException {
        return this.parseObjectPropertyExpression(false);
    }

    public OWLDescription parseRestriction() throws ParserException {
        String tok = this.peekToken();
        if (this.isObjectPropertyName(tok) || tok.equalsIgnoreCase(INV)) {
            return this.parseObjectRestriction();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataRestriction();
        }
        this.readToken();
        this.throwException(false, true, true, false);
        return null;
    }

    public OWLDescription parseNonNaryDescription() throws ParserException {
        String tok = this.peekToken();
        if (tok.equalsIgnoreCase(NOT)) {
            this.readToken();
            OWLDescription complemented = this.parseNestedClassExpression();
            return this.dataFactory.getOWLObjectComplementOf(complemented);
        }
        if (this.isObjectPropertyName(tok) || tok.equalsIgnoreCase(INV)) {
            return this.parseObjectRestriction();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataRestriction();
        }
        if (tok.equals("{")) {
            return this.parseObjectOneOf();
        }
        if (tok.equals("(")) {
            return this.parseNestedClassExpression();
        }
        if (this.isClassName(tok)) {
            this.readToken();
            OWLClass desc = this.getOWLClass(tok);
            return desc;
        }
        this.readToken();
        this.throwException(true, true, true, false, false, "(", "{", NOT, INV);
        return null;
    }

    private OWLDescription parseObjectRestriction() throws ParserException {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        String kw = this.readToken();
        if (kw.equalsIgnoreCase(SOME)) {
            String possSelfToken = this.peekToken();
            if (possSelfToken.equalsIgnoreCase(SELF)) {
                this.readToken();
                return this.dataFactory.getOWLObjectSelfRestriction(prop);
            }
            OWLDescription filler = null;
            try {
                filler = this.parseNestedClassExpression();
            }
            catch (ParserException e) {
                HashSet<String> keywords = new HashSet<String>();
                keywords.addAll(e.getExpectedKeywords());
                keywords.add(SELF);
                this.throwException(e.isClassNameExpected(), e.isObjectPropertyNameExpected(), e.isDataPropertyNameExpected(), e.isIndividualNameExpected(), e.isDatatypeNameExpected(), keywords.toArray(new String[keywords.size()]));
            }
            return this.dataFactory.getOWLObjectSomeRestriction(prop, filler);
        }
        if (kw.equalsIgnoreCase(ONLY)) {
            OWLDescription filler = this.parseNestedClassExpression();
            return this.dataFactory.getOWLObjectAllRestriction(prop, filler);
        }
        if (kw.equalsIgnoreCase(VALUE)) {
            String indName = this.readToken();
            if (!this.isIndividualName(indName)) {
                this.throwException(false, false, false, true);
            }
            return this.dataFactory.getOWLObjectValueRestriction(prop, this.getOWLIndividual(indName));
        }
        if (kw.equalsIgnoreCase(MIN)) {
            int card = this.parseInteger();
            OWLDescription filler = this.parseNestedClassExpression();
            return this.dataFactory.getOWLObjectMinCardinalityRestriction(prop, card, filler);
        }
        if (kw.equalsIgnoreCase(MAX)) {
            int card = this.parseInteger();
            OWLDescription filler = this.parseNestedClassExpression();
            return this.dataFactory.getOWLObjectMaxCardinalityRestriction(prop, card, filler);
        }
        if (kw.equalsIgnoreCase(EXACTLY)) {
            int card = this.parseInteger();
            OWLDescription filler = this.parseNestedClassExpression();
            return this.dataFactory.getOWLObjectExactCardinalityRestriction(prop, card, filler);
        }
        if (kw.equalsIgnoreCase(ONLYSOME)) {
            String tok = this.peekToken();
            HashSet<OWLDescription> descs = new HashSet<OWLDescription>();
            if (!tok.equals("[")) {
                descs.add(this.parseIntersection());
            } else {
                descs.addAll(this.parseDescriptionList("[", "]"));
            }
            HashSet<OWLQuantifiedRestriction<OWLObjectPropertyExpression, OWLDescription>> ops = new HashSet<OWLQuantifiedRestriction<OWLObjectPropertyExpression, OWLDescription>>();
            for (OWLDescription desc : descs) {
                ops.add(this.dataFactory.getOWLObjectSomeRestriction(prop, desc));
            }
            OWLDescription filler = descs.size() == 1 ? (OWLDescription)descs.iterator().next() : this.dataFactory.getOWLObjectUnionOf(descs);
            ops.add(this.dataFactory.getOWLObjectAllRestriction(prop, filler));
            return this.dataFactory.getOWLObjectIntersectionOf(ops);
        }
        this.throwException(SOME, ONLY, VALUE, MIN, MAX, EXACTLY);
        return null;
    }

    public OWLDescription parseDataRestriction() throws ParserException {
        OWLDataProperty prop = this.parseDataProperty();
        String kw = this.readToken();
        if (kw.equalsIgnoreCase(SOME)) {
            OWLDataRange rng = this.parseDataRange();
            return this.dataFactory.getOWLDataSomeRestriction(prop, rng);
        }
        if (kw.equalsIgnoreCase(ONLY)) {
            OWLDataRange rng = this.parseDataRange();
            return this.dataFactory.getOWLDataAllRestriction(prop, rng);
        }
        if (kw.equalsIgnoreCase(VALUE)) {
            OWLConstant con = this.parseConstant();
            return this.dataFactory.getOWLDataValueRestriction(prop, con);
        }
        if (kw.equalsIgnoreCase(MIN)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            return this.dataFactory.getOWLDataMinCardinalityRestriction(prop, card, rng);
        }
        if (kw.equalsIgnoreCase(EXACTLY)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            return this.dataFactory.getOWLDataExactCardinalityRestriction(prop, card, rng);
        }
        if (kw.equalsIgnoreCase(MAX)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            return this.dataFactory.getOWLDataMaxCardinalityRestriction(prop, card, rng);
        }
        this.throwException(SOME, ONLY, VALUE, MIN, EXACTLY, MAX);
        return null;
    }

    public OWLDataRange parseDataRange() throws ParserException {
        String tok = this.peekToken();
        if (this.isDatatypeName(tok)) {
            this.readToken();
            OWLDataType dataType = this.getDataType(tok);
            String next = this.peekToken();
            if (next.equals("[")) {
                this.readToken();
                String sep = ",";
                HashSet<OWLDataRangeFacetRestriction> facetRestrictions = new HashSet<OWLDataRangeFacetRestriction>();
                while (sep.equals(",")) {
                    String facet = this.readToken();
                    OWLRestrictedDataRangeFacetVocabulary fv = OWLRestrictedDataRangeFacetVocabulary.getFacetBySymbolicName(facet);
                    if (fv == null) {
                        this.throwException(OWLRestrictedDataRangeFacetVocabulary.getFacets().toArray(new String[OWLRestrictedDataRangeFacetVocabulary.getFacetURIs().size()]));
                    }
                    OWLConstant con = this.parseConstant();
                    facetRestrictions.add(this.dataFactory.getOWLDataRangeFacetRestriction(fv, con.asOWLTypedConstant()));
                    sep = this.readToken();
                }
                if (!sep.equals("]")) {
                    this.throwException("]");
                }
                return this.dataFactory.getOWLDataRangeRestriction((OWLDataRange)dataType, facetRestrictions);
            }
            return dataType;
        }
        if (tok.equalsIgnoreCase(NOT)) {
            return this.parseDataComplementOf();
        }
        if (tok.equals("{")) {
            return this.parseDataOneOf();
        }
        this.readToken();
        this.throwException(false, false, false, false, true, NOT, "{");
        return null;
    }

    private Set<OWLDataRange> parseDataRangeList() throws ParserException {
        String sep = ",";
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            OWLDataRange rng = this.parseDataRange();
            ranges.add(rng);
            this.potentialKeywords.add(",");
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.readToken();
        }
        return ranges;
    }

    private OWLDataRange parseDataOneOf() throws ParserException {
        this.readToken();
        HashSet<OWLConstant> cons = new HashSet<OWLConstant>();
        String sep = ",";
        while (sep.equals(",")) {
            OWLConstant con = this.parseConstant();
            cons.add(con);
            sep = this.readToken();
        }
        if (!sep.equals("}")) {
            this.throwException(",", "}");
        }
        return this.dataFactory.getOWLDataOneOf(cons);
    }

    private OWLDataRange parseDataComplementOf() throws ParserException {
        this.readToken();
        String open = this.readToken();
        if (!open.equals("(")) {
            this.throwException("(");
        }
        OWLDataRange complementedDataRange = this.parseDataRange();
        String close = this.readToken();
        if (!close.equals(")")) {
            this.throwException(")");
        }
        return this.dataFactory.getOWLDataComplementOf(complementedDataRange);
    }

    public OWLConstant parseConstant() throws ParserException {
        String tok = this.readToken();
        if (tok.startsWith("\"")) {
            String lit = tok.substring(1, tok.length() - 1);
            if (this.peekToken().equals("^")) {
                this.readToken();
                String type = this.readToken();
                String dataType = this.readToken();
                return this.dataFactory.getOWLTypedConstant(lit, this.getDataType(dataType));
            }
            if (this.peekToken().equals("@")) {
                this.readToken();
                String lang = this.readToken();
                return this.dataFactory.getOWLUntypedConstant(lit, lang);
            }
            return this.dataFactory.getOWLUntypedConstant(lit);
        }
        try {
            Integer.parseInt(tok);
            return this.dataFactory.getOWLTypedConstant(tok, this.dataFactory.getOWLDataType(XSDVocabulary.INT.getURI()));
        }
        catch (NumberFormatException e) {
            try {
                Double.parseDouble(tok);
                return this.dataFactory.getOWLTypedConstant(tok, this.dataFactory.getOWLDataType(XSDVocabulary.DOUBLE.getURI()));
            }
            catch (NumberFormatException e2) {
                try {
                    Float.parseFloat(tok);
                    return this.dataFactory.getOWLTypedConstant(tok, this.dataFactory.getOWLDataType(XSDVocabulary.FLOAT.getURI()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(false, false, false, false, false, "\"<Literal>\"", "\"<Literal>\"^^<datatype>", "\"<Literal>\"@<lang>");
                    return null;
                }
            }
        }
    }

    public int parseInteger() throws ParserException {
        String i = this.readToken();
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException e) {
            throw new ParserException(this.token, this.tokenStartPos, this.line, true, this.tokenStartCol);
        }
    }

    public String getLineCol() {
        return "Encountered " + this.getLastToken() + " at " + this.line + ":" + this.col + " ";
    }

    private OWLDescription parseNestedClassExpression() throws ParserException {
        String tok = this.peekToken();
        if (tok.equals("(")) {
            this.readToken();
            OWLDescription desc = this.parseIntersection();
            String closeBracket = this.readToken();
            if (!closeBracket.equals(")")) {
                this.throwException(")");
            }
            return desc;
        }
        if (tok.equals("{")) {
            return this.parseObjectOneOf();
        }
        if (this.isClassName(tok)) {
            String name = this.readToken();
            return this.getOWLClass(name);
        }
        this.readToken();
        this.throwException(true, false, false, false, false, "(", "{");
        return null;
    }

    public OWLDescription parseObjectOneOf() throws ParserException {
        String open = this.readToken();
        if (!open.equals("{")) {
            this.throwException("{");
        }
        String sep = ",";
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        while (sep.equals(",")) {
            OWLIndividual ind = this.parseIndividual();
            inds.add(ind);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.readToken();
        }
        String close = this.readToken();
        if (!close.equals("}")) {
            this.throwException("}", ",");
        }
        return this.dataFactory.getOWLObjectOneOf(inds);
    }

    public Set<OWLAxiom> parseFrames() throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        while (true) {
            String tok;
            if ((tok = this.peekToken()).equalsIgnoreCase(CLASS)) {
                axioms.addAll(this.parseClassFrame());
                continue;
            }
            if (tok.equalsIgnoreCase(OBJECT_PROPERTY)) {
                axioms.addAll(this.parseObjectPropertyFrame());
                continue;
            }
            if (tok.equalsIgnoreCase(DATA_PROPERTY)) {
                axioms.addAll(this.parseDataPropertyFrame());
                continue;
            }
            if (tok.equalsIgnoreCase(INDIVIDUAL)) {
                axioms.addAll(this.parseIndividualFrame());
                continue;
            }
            if (tok.equalsIgnoreCase(VALUE_PARTITION)) {
                this.parseValuePartitionFrame();
                continue;
            }
            if (tok.equals("<EOF>")) break;
            this.throwException(CLASS, OBJECT_PROPERTY, DATA_PROPERTY, INDIVIDUAL, VALUE_PARTITION);
        }
        return axioms;
    }

    public Set<OWLAnnotation> parseAnnotations() throws ParserException {
        HashSet<OWLAnnotation> annos = new HashSet<OWLAnnotation>();
        String header = this.readToken();
        if (!header.equals(ANNOTATIONS)) {
            this.throwException(ANNOTATIONS);
        }
        String sep = ",";
        while (sep.equals(",")) {
            OWLAnnotation<OWLIndividual> anno;
            String obj;
            String prop = this.readToken();
            if (!this.isAnnotationURI(prop)) {
                this.throwException(this.annotationURIs.toArray(new String[this.annotationURIs.size()]));
            }
            if (this.isIndividualName(obj = this.peekToken())) {
                OWLIndividual ind = this.parseIndividual();
                anno = this.dataFactory.getOWLObjectAnnotation(this.getAnnotationURI(prop), ind);
                annos.add(anno);
            } else {
                OWLConstant con = this.parseConstant();
                anno = this.dataFactory.getOWLConstantAnnotation(this.getAnnotationURI(prop), con);
                annos.add(anno);
            }
            if (!(sep = this.peekToken()).equals(",")) continue;
            this.readToken();
        }
        return annos;
    }

    public Set<OWLAxiom> parseAnnotations(OWLEntity subject) throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (OWLAnnotation anno : this.parseAnnotations()) {
            axioms.add(this.dataFactory.getOWLEntityAnnotationAxiom(subject, anno));
        }
        return axioms;
    }

    public Set<OWLAxiom> parseClassFrame() throws ParserException {
        return this.parseClassFrame(false);
    }

    public Set<OWLAxiom> parseClassFrameEOF() throws ParserException {
        return this.parseClassFrame(true);
    }

    private Set<OWLAxiom> parseClassFrame(boolean eof) throws ParserException {
        String subj;
        String tok = this.readToken();
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        if (!tok.equalsIgnoreCase(CLASS)) {
            this.throwException(CLASS);
        }
        if (!this.isClassName(subj = this.readToken())) {
            this.throwException(true, false, false, false);
        }
        OWLClass cls = this.getOWLClass(subj);
        block0: while (true) {
            OWLDescription desc;
            Iterator<OWLDescription> i$;
            Set<OWLDescription> descs;
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(SUB_CLASS_OF)) {
                this.potentialKeywords.clear();
                this.readToken();
                descs = this.parseDescriptionList();
                i$ = descs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    desc = i$.next();
                    axioms.add(this.dataFactory.getOWLSubClassAxiom(cls, desc));
                }
            }
            if (sect.equalsIgnoreCase(EQUIVALENT_TO)) {
                this.potentialKeywords.clear();
                this.readToken();
                descs = this.parseDescriptionList();
                i$ = descs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    desc = i$.next();
                    axioms.add(this.dataFactory.getOWLEquivalentClassesAxiom(CollectionFactory.createSet(cls, desc)));
                }
            }
            if (sect.equalsIgnoreCase(DISJOINT_WITH)) {
                this.potentialKeywords.clear();
                this.readToken();
                descs = this.parseDescriptionList();
                i$ = descs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    desc = i$.next();
                    axioms.add(this.dataFactory.getOWLDisjointClassesAxiom((OWLDescription)cls, desc));
                }
            }
            if (sect.equals(ANNOTATIONS)) {
                this.potentialKeywords.clear();
                axioms.addAll(this.parseAnnotations(cls));
                continue;
            }
            if (!eof || sect.equals("<EOF>")) break;
            this.throwException(SUB_CLASS_OF, EQUIVALENT_TO, DISJOINT_WITH, ANNOTATIONS);
        }
        return axioms;
    }

    public Set<OWLAxiom> parseObjectPropertyFrame() throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        OWLObjectPropertyExpression prop = null;
        String tok = this.readToken();
        if (!tok.equalsIgnoreCase(OBJECT_PROPERTY)) {
            this.throwException(OBJECT_PROPERTY);
        }
        String subj = this.peekToken();
        this.objectPropertyNames.add(subj);
        prop = this.parseObjectPropertyExpression();
        block0: while (true) {
            OWLObjectPropertyExpression pe;
            Iterator<OWLObject> i$;
            Set<OWLObjectPropertyExpression> props;
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(SUB_PROPERTY_OF)) {
                this.potentialKeywords.clear();
                this.readToken();
                props = this.parseObjectPropertyList();
                i$ = props.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    pe = i$.next();
                    axioms.add(this.dataFactory.getOWLSubObjectPropertyAxiom(prop, pe));
                }
            }
            if (sect.equalsIgnoreCase(EQUIVALENT_TO)) {
                this.potentialKeywords.clear();
                this.readToken();
                props = this.parseObjectPropertyList();
                i$ = props.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    pe = i$.next();
                    axioms.add(this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet(prop, pe)));
                }
            }
            if (sect.equalsIgnoreCase(DISJOINT_WITH)) {
                this.potentialKeywords.clear();
                this.readToken();
                props = this.parseObjectPropertyList();
                i$ = props.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    pe = i$.next();
                    axioms.add(this.dataFactory.getOWLDisjointObjectPropertiesAxiom(CollectionFactory.createSet(prop, pe)));
                }
            }
            if (sect.equalsIgnoreCase(DOMAIN)) {
                this.potentialKeywords.clear();
                this.readToken();
                Set<OWLDescription> domains = this.parseDescriptionList();
                i$ = domains.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLDescription dom = (OWLDescription)i$.next();
                    axioms.add(this.dataFactory.getOWLObjectPropertyDomainAxiom(prop, dom));
                }
            }
            if (sect.equalsIgnoreCase(RANGE)) {
                this.potentialKeywords.clear();
                this.readToken();
                Set<OWLDescription> ranges = this.parseDescriptionList();
                i$ = ranges.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLDescription rng = (OWLDescription)i$.next();
                    axioms.add(this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, rng));
                }
            }
            if (sect.equalsIgnoreCase(INVERSE_OF)) {
                this.potentialKeywords.clear();
                this.readToken();
                Set<OWLObjectPropertyExpression> inverses = this.parseObjectPropertyList();
                i$ = inverses.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLObjectPropertyExpression inv = (OWLObjectPropertyExpression)i$.next();
                    axioms.add(this.dataFactory.getOWLInverseObjectPropertiesAxiom(prop, inv));
                }
            }
            if (sect.equalsIgnoreCase(CHARACTERISTICS)) {
                this.potentialKeywords.clear();
                this.readToken();
                axioms.addAll(this.parseObjectPropertyCharacteristicList(prop));
                continue;
            }
            if (!sect.equalsIgnoreCase(ANNOTATIONS)) break;
            this.potentialKeywords.clear();
            axioms.addAll(this.parseAnnotations(prop.asOWLObjectProperty()));
        }
        return axioms;
    }

    public Set<OWLAxiom> parseDataPropertyFrame() throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        String tok = this.readToken();
        if (!tok.equalsIgnoreCase(DATA_PROPERTY)) {
            this.throwException(DATA_PROPERTY);
        }
        String subj = this.readToken();
        this.dataPropertyNames.add(subj);
        OWLDataProperty prop = this.getOWLDataProperty(subj);
        block0: while (true) {
            OWLDataProperty pe;
            Iterator<OWLObject> i$;
            Set<OWLDataProperty> props;
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(SUB_PROPERTY_OF)) {
                this.potentialKeywords.clear();
                this.readToken();
                props = this.parseDataPropertyList();
                i$ = props.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    pe = i$.next();
                    axioms.add(this.dataFactory.getOWLSubDataPropertyAxiom(prop, pe));
                }
            }
            if (sect.equalsIgnoreCase(EQUIVALENT_TO)) {
                this.potentialKeywords.clear();
                this.readToken();
                props = this.parseDataPropertyList();
                i$ = props.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    pe = i$.next();
                    axioms.add(this.dataFactory.getOWLEquivalentDataPropertiesAxiom(CollectionFactory.createSet(prop, pe)));
                }
            }
            if (sect.equalsIgnoreCase(DISJOINT_WITH)) {
                this.potentialKeywords.clear();
                this.readToken();
                props = this.parseDataPropertyList();
                i$ = props.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    pe = i$.next();
                    axioms.add(this.dataFactory.getOWLDisjointDataPropertiesAxiom(CollectionFactory.createSet(prop, pe)));
                }
            }
            if (sect.equalsIgnoreCase(DOMAIN)) {
                this.potentialKeywords.clear();
                this.readToken();
                Set<OWLDescription> domains = this.parseDescriptionList();
                i$ = domains.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLDescription dom = (OWLDescription)i$.next();
                    axioms.add(this.dataFactory.getOWLDataPropertyDomainAxiom(prop, dom));
                }
            }
            if (sect.equalsIgnoreCase(RANGE)) {
                this.potentialKeywords.clear();
                this.readToken();
                Set<OWLDataRange> ranges = this.parseDataRangeList();
                i$ = ranges.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLDataRange rng = (OWLDataRange)i$.next();
                    axioms.add(this.dataFactory.getOWLDataPropertyRangeAxiom(prop, rng));
                }
            }
            if (sect.equalsIgnoreCase(CHARACTERISTICS)) {
                this.potentialKeywords.clear();
                String characteristic = this.readToken();
                if (!characteristic.equals(FUNCTIONAL)) {
                    this.throwException(FUNCTIONAL);
                }
                axioms.add(this.dataFactory.getOWLFunctionalDataPropertyAxiom(prop));
                continue;
            }
            if (!sect.equalsIgnoreCase(ANNOTATIONS)) break;
            this.potentialKeywords.clear();
            axioms.addAll(this.parseAnnotations(prop));
        }
        return axioms;
    }

    public Set<OWLAxiom> parseIndividualFrame() throws ParserException {
        String tok = this.readToken();
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        if (!tok.equalsIgnoreCase(INDIVIDUAL)) {
            this.throwException(INDIVIDUAL);
        }
        String subj = this.readToken();
        OWLIndividual ind = this.getOWLIndividual(subj);
        block2: while (true) {
            Set<OWLIndividual> inds;
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(TYPES)) {
                this.potentialKeywords.clear();
                this.readToken();
                Set<OWLDescription> descs = this.parseDescriptionList();
                Iterator<OWLDescription> i$ = descs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block2;
                    OWLDescription desc = i$.next();
                    axioms.add(this.dataFactory.getOWLClassAssertionAxiom(ind, desc));
                }
            }
            if (sect.equalsIgnoreCase(FACTS)) {
                this.potentialKeywords.clear();
                this.readToken();
                String sep = ",";
                while (true) {
                    OWLPropertyExpression<OWLDataPropertyExpression, OWLDataRange> p;
                    if (!sep.equals(",")) continue block2;
                    String prop = this.peekToken();
                    if (this.isDataPropertyName(prop)) {
                        p = this.parseDataProperty();
                        OWLConstant con = this.parseConstant();
                        axioms.add(this.dataFactory.getOWLDataPropertyAssertionAxiom(ind, (OWLDataPropertyExpression)p, con));
                    } else if (this.isObjectPropertyName(prop)) {
                        p = this.parseObjectPropertyExpression();
                        OWLIndividual obj = this.parseIndividual();
                        axioms.add(this.dataFactory.getOWLObjectPropertyAssertionAxiom(ind, (OWLObjectPropertyExpression)p, obj));
                    } else if (this.isAnnotationURI(prop)) {
                        OWLAnnotation<OWLIndividual> annotation;
                        URI annotationURI = this.getAnnotationURI(prop);
                        String object = this.peekToken();
                        if (this.individualNames.contains(object)) {
                            annotation = this.dataFactory.getOWLObjectAnnotation(annotationURI, this.getOWLIndividual(object));
                        } else {
                            OWLConstant con = null;
                            try {
                                con = this.parseConstant();
                            }
                            catch (ParserException e) {
                                this.throwException(e.isClassNameExpected(), e.isObjectPropertyNameExpected(), e.isDataPropertyNameExpected(), true, e.isDatatypeNameExpected(), e.getExpectedKeywords().toArray(new String[e.getExpectedKeywords().size()]));
                            }
                            annotation = this.dataFactory.getOWLConstantAnnotation(annotationURI, con);
                        }
                        axioms.add(this.dataFactory.getOWLEntityAnnotationAxiom(ind, annotation));
                    } else {
                        this.throwException(false, true, true, false, false, ",");
                    }
                    if (!(sep = this.peekToken()).equals(",")) continue;
                    this.readToken();
                }
            }
            if (sect.equalsIgnoreCase(SAME_AS)) {
                this.potentialKeywords.clear();
                this.readToken();
                inds = this.parseIndividualList();
                inds.add(ind);
                axioms.add(this.dataFactory.getOWLSameIndividualsAxiom(inds));
                continue;
            }
            if (sect.equalsIgnoreCase(DIFFERENT_FROM)) {
                this.potentialKeywords.clear();
                this.readToken();
                inds = this.parseIndividualList();
                inds.add(ind);
                axioms.add(this.dataFactory.getOWLDifferentIndividualsAxiom(inds));
                continue;
            }
            if (!sect.equalsIgnoreCase(ANNOTATIONS)) break;
            this.potentialKeywords.clear();
            axioms.addAll(this.parseAnnotations(ind));
        }
        return axioms;
    }

    public Set<OWLAxiom> parseValuePartitionFrame() throws ParserException {
        String name;
        String section = this.readToken();
        if (!section.equalsIgnoreCase(VALUE_PARTITION)) {
            this.throwException(VALUE_PARTITION);
        }
        if ((name = this.readToken()).equals("<EOF>")) {
            this.throwException(false, true, false, false, false, new String[0]);
        }
        OWLObjectProperty prop = this.dataFactory.getOWLObjectProperty(this.getURI(name));
        String clsName = this.readToken();
        if (clsName.equals("<EOF>")) {
            this.throwException(false, true, false, false, false, new String[0]);
        }
        OWLClass cls = this.getOWLClass(clsName);
        Set<OWLDescription> values = this.parseDescriptionList("[", "]");
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (OWLDescription val : values) {
            axioms.add(this.dataFactory.getOWLSubClassAxiom(val, cls));
        }
        axioms.add(this.dataFactory.getOWLSubClassAxiom(cls, this.dataFactory.getOWLObjectUnionOf(values)));
        axioms.add(this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop));
        axioms.add(this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, cls));
        return axioms;
    }

    public Set<OWLAxiom> parseObjectPropertyCharacteristicList(OWLObjectPropertyExpression prop) throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        String sep = ",";
        while (sep.equals(",")) {
            String characteristic = this.readToken();
            if (characteristic.equalsIgnoreCase(FUNCTIONAL)) {
                axioms.add(this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop));
            } else if (characteristic.equalsIgnoreCase(INVERSE_FUNCTIONAL)) {
                axioms.add(this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop));
            } else if (characteristic.equalsIgnoreCase(SYMMETRIC)) {
                axioms.add(this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop));
            } else if (characteristic.equalsIgnoreCase(ANTI_SYMMETRIC)) {
                axioms.add(this.dataFactory.getOWLAntiSymmetricObjectPropertyAxiom(prop));
            } else if (characteristic.equalsIgnoreCase(TRANSITIVE)) {
                axioms.add(this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop));
            } else if (characteristic.equalsIgnoreCase(REFLEXIVE)) {
                axioms.add(this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop));
            } else if (characteristic.equalsIgnoreCase(IRREFLEXIVE)) {
                axioms.add(this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop));
            } else {
                this.throwException(FUNCTIONAL, INVERSE_FUNCTIONAL, SYMMETRIC, ANTI_SYMMETRIC, TRANSITIVE, REFLEXIVE, IRREFLEXIVE);
            }
            if (!(sep = this.peekToken()).equals(",")) continue;
            sep = this.readToken();
        }
        return axioms;
    }

    public Set<OWLDescription> parseDescriptionList() throws ParserException {
        HashSet<OWLDescription> descs = new HashSet<OWLDescription>();
        String sep = ",";
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            descs.add(this.parseIntersection());
            this.potentialKeywords.add(",");
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            sep = this.readToken();
        }
        return descs;
    }

    public Set<OWLDescription> parseDescriptionList(String expectedOpen, String expectedClose) throws ParserException {
        String open = this.readToken();
        HashSet<OWLDescription> descs = new HashSet<OWLDescription>();
        if (!open.equals(expectedOpen)) {
            this.throwException(expectedOpen);
        }
        String sep = ",";
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            OWLDescription desc = this.parseIntersection();
            this.potentialKeywords.add(",");
            descs.add(desc);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            sep = this.readToken();
        }
        String close = this.readToken();
        if (!close.equals(expectedClose)) {
            this.throwException(expectedClose);
        }
        return descs;
    }

    public Set<OWLDataProperty> parseDataPropertyList() throws ParserException {
        HashSet<OWLDataProperty> props = new HashSet<OWLDataProperty>();
        String sep = ",";
        while (sep.equals(",")) {
            sep = this.peekToken();
            OWLDataProperty prop = this.parseDataProperty();
            props.add(prop);
            if (!sep.equals(",")) continue;
            this.readToken();
        }
        return props;
    }

    public Set<OWLObjectPropertyExpression> parseObjectPropertyList() throws ParserException {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        String sep = ",";
        while (sep.equals(",")) {
            sep = this.peekToken();
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            props.add(prop);
            if (!sep.equals(",")) continue;
            this.readToken();
        }
        return props;
    }

    public Set<OWLIndividual> parseIndividualList() throws ParserException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        String sep = ",";
        while (sep.equals(",")) {
            inds.add(this.parseIndividual());
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.readToken();
        }
        return inds;
    }

    public List<OWLObjectPropertyExpression> parseObjectPropertyChain() throws ParserException {
        String delim = "o";
        ArrayList<OWLObjectPropertyExpression> properties = new ArrayList<OWLObjectPropertyExpression>();
        while (delim.equals("o")) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            properties.add(prop);
            delim = this.peekToken();
            if (!delim.equals("o")) continue;
            this.readToken();
        }
        return properties;
    }

    public OWLObjectPropertyChainSubPropertyAxiom parsePropertyChainSubPropertyAxiom() throws ParserException {
        List<OWLObjectPropertyExpression> props = this.parseObjectPropertyChain();
        String imp = this.readToken();
        if (!imp.equals("->")) {
            this.throwException("->", "o");
        }
        OWLObjectPropertyExpression superProp = this.parseObjectPropertyExpression();
        return this.dataFactory.getOWLObjectPropertyChainSubPropertyAxiom(props, superProp);
    }

    public OWLClassAxiom parseClassAxiom() throws ParserException {
        OWLDescription lhs = this.parseDescription();
        String kw = this.readToken();
        if (kw.equalsIgnoreCase(ManchesterOWLSyntax.SUBCLASS_OF.toString())) {
            OWLDescription rhs = this.parseDescription();
            return this.dataFactory.getOWLSubClassAxiom(lhs, rhs);
        }
        if (kw.equalsIgnoreCase(ManchesterOWLSyntax.EQUIVALENT_TO.toString())) {
            OWLDescription rhs = this.parseDescription();
            return this.dataFactory.getOWLEquivalentClassesAxiom(lhs, rhs);
        }
        if (kw.equalsIgnoreCase(ManchesterOWLSyntax.DISJOINT_WITH.toString())) {
            OWLDescription rhs = this.parseDescription();
            return this.dataFactory.getOWLDisjointClassesAxiom(lhs, rhs);
        }
        this.throwException(SUB_CLASS_OF, EQUIVALENT_TO, DISJOINT_WITH);
        return null;
    }

    public OWLObjectPropertyAxiom parseObjectPropertyAxiom() throws ParserException {
        String tok = this.peekToken();
        if (tok.equals((Object)ManchesterOWLSyntax.FUNCTIONAL)) {
            this.readToken();
            String open = this.readToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.readToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop);
        }
        if (tok.equals((Object)ManchesterOWLSyntax.INVERSE_FUNCTIONAL)) {
            this.readToken();
            String open = this.readToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.readToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop);
        }
        if (tok.equals((Object)ManchesterOWLSyntax.TRANSITIVE)) {
            this.readToken();
            String open = this.readToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.readToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);
        }
        if (tok.equals((Object)ManchesterOWLSyntax.SYMMETRIC)) {
            this.readToken();
            String open = this.readToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.readToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop);
        }
        if (tok.equals((Object)ManchesterOWLSyntax.REFLEXIVE)) {
            this.readToken();
            String open = this.readToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.readToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop);
        }
        if (tok.equals((Object)ManchesterOWLSyntax.IRREFLEXIVE)) {
            this.readToken();
            String open = this.readToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.readToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop);
        }
        if (tok.equals((Object)ManchesterOWLSyntax.ANTI_SYMMETRIC)) {
            this.readToken();
            String open = this.readToken();
            if (!open.equals("(")) {
                this.throwException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.readToken();
            if (!close.equals(")")) {
                this.throwException(")");
            }
            return this.dataFactory.getOWLAntiSymmetricObjectPropertyAxiom(prop);
        }
        return null;
    }

    public OWLIndividual parseIndividual() throws ParserException {
        String name = this.readToken();
        if (!this.isIndividualName(name)) {
            this.throwException(false, false, false, true);
        }
        return this.getOWLIndividual(name);
    }

    public OWLDataProperty parseDataProperty() throws ParserException {
        String name = this.readToken();
        if (!this.isDataPropertyName(name)) {
            this.throwException(false, false, true, false);
        }
        return this.getOWLDataProperty(name);
    }

    public Map<String, URI> parseNamespace() throws ParserException {
        String nsTok = this.readToken();
        if (!nsTok.equals(NAMESPACE)) {
            this.throwException(NAMESPACE);
        }
        String tok = this.readToken();
        HashMap<String, URI> map = new HashMap<String, URI>(2);
        if (tok.equals("=")) {
            URI uri = this.parseURI();
            map.put("", uri);
        } else {
            String prefix = tok;
            String delim = this.readToken();
            if (!delim.equals("=")) {
                this.throwException("=");
            }
            URI uri = this.parseURI();
            map.put(prefix, uri);
        }
        return map;
    }

    public OWLImportsDeclaration parseImportsDeclaration(OWLOntology ont) throws ParserException {
        String section = this.readToken();
        if (!section.equalsIgnoreCase(IMPORTS)) {
            this.throwException(IMPORTS);
        }
        URI importedOntologyURI = this.parseURI();
        return this.dataFactory.getOWLImportsDeclarationAxiom(ont, importedOntologyURI);
    }

    public URI parseURI() throws ParserException {
        String quotedURI = this.readToken();
        if (!quotedURI.startsWith("<") || !quotedURI.endsWith(">")) {
            this.throwException("<URI>");
        }
        return URI.create(quotedURI.substring(1, quotedURI.length() - 1));
    }

    private void processDeclaredEntities() {
        ManchesterOWLSyntaxEditorParser.addNamesToSet(this.buffer, CLASS, this.classNames);
        ManchesterOWLSyntaxEditorParser.addNamesToSet(this.buffer, DATA_PROPERTY, this.dataPropertyNames);
        ManchesterOWLSyntaxEditorParser.addNamesToSet(this.buffer, OBJECT_PROPERTY, this.objectPropertyNames);
        ManchesterOWLSyntaxEditorParser.addNamesToSet(this.buffer, INDIVIDUAL, this.individualNames);
    }

    private static void addNamesToSet(String buffer, String sectionName, Set<String> names) {
        Pattern p = Pattern.compile("(" + sectionName + "\\s*)(\\S*)");
        Matcher matcher = p.matcher(buffer);
        while (matcher.find()) {
            names.add(matcher.group(2));
        }
    }

    public void parseOntology(OWLOntologyManager manager, OWLOntology ont) throws ParserException, OWLOntologyCreationException, OWLOntologyChangeException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        URI ontologyURI = null;
        this.processDeclaredEntities();
        block0: while (true) {
            String section = this.peekToken();
            if (ontologyURI == null && section.equals(ONTOLOGY)) {
                this.readToken();
                ontologyURI = this.parseURI();
                this.setBase(ontologyURI + "#");
                block1: while (true) {
                    if (!this.peekToken().equals(ANNOTATIONS)) continue block0;
                    Set<OWLAnnotation> annos = this.parseAnnotations();
                    Iterator<OWLAnnotation> i$ = annos.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block1;
                        OWLAnnotation anno = i$.next();
                        axioms.add(this.dataFactory.getOWLOntologyAnnotationAxiom(ont, anno));
                    }
                    break;
                }
            }
            if (section.equals(CLASS)) {
                axioms.addAll(this.parseClassFrame());
                continue;
            }
            if (section.equals(OBJECT_PROPERTY)) {
                axioms.addAll(this.parseObjectPropertyFrame());
                continue;
            }
            if (section.equals(DATA_PROPERTY)) {
                axioms.addAll(this.parseDataPropertyFrame());
                continue;
            }
            if (section.equals(INDIVIDUAL)) {
                axioms.addAll(this.parseIndividualFrame());
                continue;
            }
            if (section.equals(VALUE_PARTITION)) {
                axioms.addAll(this.parseValuePartitionFrame());
                continue;
            }
            if (section.equals(IMPORTS)) {
                OWLImportsDeclaration decl = this.parseImportsDeclaration(ont);
                axioms.add(decl);
                manager.makeLoadImportRequest(decl);
                continue;
            }
            if (section.equals(NAMESPACE)) {
                Map<String, URI> nsMap = this.parseNamespace();
                this.namespaceMap.putAll(nsMap);
                continue;
            }
            if (section.equals("<EOF>")) break;
            this.throwException(CLASS, OBJECT_PROPERTY, DATA_PROPERTY, INDIVIDUAL, IMPORTS, VALUE_PARTITION);
        }
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>(axioms.size());
        for (OWLAxiom ax : axioms) {
            changes.add(new AddAxiom(ont, ax));
        }
        changes.add(new SetOntologyURI(ont, ontologyURI));
        manager.applyChanges(changes);
    }

    private void throwException(String ... keywords) throws ParserException {
        HashSet<String> theKeywords = new HashSet<String>();
        theKeywords.addAll(Arrays.asList(keywords));
        theKeywords.addAll(this.potentialKeywords);
        this.potentialKeywords.clear();
        throw new ParserException(this.token, this.tokenStartPos, this.line, this.tokenStartCol, false, false, false, false, false, theKeywords);
    }

    private void throwException(boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, String ... keywords) throws ParserException {
        HashSet<String> theKeywords = new HashSet<String>();
        theKeywords.addAll(Arrays.asList(keywords));
        if (objectPropertyNameExpected) {
            theKeywords.add(INV);
        }
        theKeywords.addAll(this.potentialKeywords);
        this.potentialKeywords.clear();
        throw new ParserException(this.token, this.tokenStartPos, this.line, this.tokenStartCol, classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, datatypeNameExpected, theKeywords);
    }

    private void throwException(boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected) throws ParserException {
        HashSet<String> keywords = new HashSet<String>();
        if (objectPropertyNameExpected) {
            keywords.add(INV);
        }
        keywords.addAll(this.potentialKeywords);
        this.potentialKeywords.clear();
        throw new ParserException(this.token, this.tokenStartPos, this.line, this.tokenStartCol, classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, false, keywords);
    }

    public URI getURI(String name) {
        String prefix;
        URI ns;
        URI uri = this.nameURIMap.get(name);
        if (uri != null) {
            return uri;
        }
        int colonIndex = name.indexOf(58);
        if (colonIndex != -1 && (ns = this.namespaceMap.get(prefix = name.substring(0, colonIndex))) != null) {
            uri = URI.create(ns + name);
            this.nameURIMap.put(name, uri);
            return uri;
        }
        uri = URI.create(this.base + name);
        this.nameURIMap.put(name, uri);
        return uri;
    }

    private class DefaultEntityChecker
    implements OWLEntityChecker {
        private Map<String, OWLDataType> dataTypeNameMap = new HashMap<String, OWLDataType>();

        public DefaultEntityChecker() {
            for (XSDVocabulary v : XSDVocabulary.values()) {
                this.dataTypeNameMap.put(v.getURI().getFragment(), ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataType(v.getURI()));
                this.dataTypeNameMap.put("xsd:" + v.getURI().getFragment(), ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataType(v.getURI()));
            }
        }

        public OWLClass getOWLClass(String name) {
            if (name.equals("Thing")) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLThing();
            }
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLClass(ManchesterOWLSyntaxEditorParser.this.getURI(name));
        }

        public OWLObjectProperty getOWLObjectProperty(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.objectPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLObjectProperty(ManchesterOWLSyntaxEditorParser.this.getURI(name));
            }
            return null;
        }

        public OWLDataProperty getOWLDataProperty(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.dataPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataProperty(ManchesterOWLSyntaxEditorParser.this.getURI(name));
            }
            return null;
        }

        public OWLIndividual getOWLIndividual(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.individualNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLIndividual(ManchesterOWLSyntaxEditorParser.this.getURI(name));
            }
            return null;
        }

        public OWLDataType getOWLDataType(String name) {
            return this.dataTypeNameMap.get(name);
        }
    }
}

