/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import edu.unika.aifb.rdf.api.syntax.RDFConsumer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.coode.owl.rdfxml.parser.AbstractLiteralTripleHandler;
import org.coode.owl.rdfxml.parser.AbstractResourceTripleHandler;
import org.coode.owl.rdfxml.parser.AnonymousNodeChecker;
import org.coode.owl.rdfxml.parser.BuiltInTypeHandler;
import org.coode.owl.rdfxml.parser.DataPropertyListItemTranslator;
import org.coode.owl.rdfxml.parser.DescriptionListItemTranslator;
import org.coode.owl.rdfxml.parser.DescriptionTranslator;
import org.coode.owl.rdfxml.parser.DescriptionTranslatorSelector;
import org.coode.owl.rdfxml.parser.GTPAnnotationLiteralHandler;
import org.coode.owl.rdfxml.parser.GTPAnnotationResourceTripleHandler;
import org.coode.owl.rdfxml.parser.GTPDataPropertyAssertionHandler;
import org.coode.owl.rdfxml.parser.GTPObjectPropertyAssertionHandler;
import org.coode.owl.rdfxml.parser.IndividualListItemTranslator;
import org.coode.owl.rdfxml.parser.OWLRDFParserException;
import org.coode.owl.rdfxml.parser.ObjectPropertyListItemTranslator;
import org.coode.owl.rdfxml.parser.OptimisedListTranslator;
import org.coode.owl.rdfxml.parser.SWRLRuleTranslator;
import org.coode.owl.rdfxml.parser.TPAllValuesFromHandler;
import org.coode.owl.rdfxml.parser.TPComplementOfHandler;
import org.coode.owl.rdfxml.parser.TPDataPropertDomainHandler;
import org.coode.owl.rdfxml.parser.TPDataPropertyRangeHandler;
import org.coode.owl.rdfxml.parser.TPDeclaredAsHandler;
import org.coode.owl.rdfxml.parser.TPDifferentFromHandler;
import org.coode.owl.rdfxml.parser.TPDisjointDataPropertiesHandler;
import org.coode.owl.rdfxml.parser.TPDisjointObjectPropertiesHandler;
import org.coode.owl.rdfxml.parser.TPDisjointUnionHandler;
import org.coode.owl.rdfxml.parser.TPDisjointWithHandler;
import org.coode.owl.rdfxml.parser.TPDistinctMembersHandler;
import org.coode.owl.rdfxml.parser.TPEquivalentClassHandler;
import org.coode.owl.rdfxml.parser.TPEquivalentDataPropertyHandler;
import org.coode.owl.rdfxml.parser.TPEquivalentObjectPropertyHandler;
import org.coode.owl.rdfxml.parser.TPEquivalentPropertyHandler;
import org.coode.owl.rdfxml.parser.TPFirstLiteralHandler;
import org.coode.owl.rdfxml.parser.TPFirstResourceHandler;
import org.coode.owl.rdfxml.parser.TPImportsHandler;
import org.coode.owl.rdfxml.parser.TPIntersectionOfHandler;
import org.coode.owl.rdfxml.parser.TPInverseOfHandler;
import org.coode.owl.rdfxml.parser.TPObjectPropertyDomainHandler;
import org.coode.owl.rdfxml.parser.TPObjectPropertyRangeHandler;
import org.coode.owl.rdfxml.parser.TPOnPropertyHandler;
import org.coode.owl.rdfxml.parser.TPOneOfHandler;
import org.coode.owl.rdfxml.parser.TPPropertyDomainHandler;
import org.coode.owl.rdfxml.parser.TPPropertyRangeHandler;
import org.coode.owl.rdfxml.parser.TPRestHandler;
import org.coode.owl.rdfxml.parser.TPSameAsHandler;
import org.coode.owl.rdfxml.parser.TPSomeValuesFromHandler;
import org.coode.owl.rdfxml.parser.TPSubClassOfHandler;
import org.coode.owl.rdfxml.parser.TPSubDataPropertyOfHandler;
import org.coode.owl.rdfxml.parser.TPSubObjectPropertyOfHandler;
import org.coode.owl.rdfxml.parser.TPSubPropertyOfHandler;
import org.coode.owl.rdfxml.parser.TPTypeHandler;
import org.coode.owl.rdfxml.parser.TPUnionOfHandler;
import org.coode.owl.rdfxml.parser.TriplePredicateHandler;
import org.coode.owl.rdfxml.parser.TypeAllDifferentHandler;
import org.coode.owl.rdfxml.parser.TypeAllDisjointClassesHandler;
import org.coode.owl.rdfxml.parser.TypeAllDisjointPropertiesHandler;
import org.coode.owl.rdfxml.parser.TypeAnnotationPropertyHandler;
import org.coode.owl.rdfxml.parser.TypeAntisymmetricPropertyHandler;
import org.coode.owl.rdfxml.parser.TypeAxiomHandler;
import org.coode.owl.rdfxml.parser.TypeClassHandler;
import org.coode.owl.rdfxml.parser.TypeDataPropertyHandler;
import org.coode.owl.rdfxml.parser.TypeDataRangeHandler;
import org.coode.owl.rdfxml.parser.TypeDataRestrictionHandler;
import org.coode.owl.rdfxml.parser.TypeDatatypeHandler;
import org.coode.owl.rdfxml.parser.TypeDeprecatedClassHandler;
import org.coode.owl.rdfxml.parser.TypeFunctionalDataPropertyHandler;
import org.coode.owl.rdfxml.parser.TypeFunctionalObjectPropertyHandler;
import org.coode.owl.rdfxml.parser.TypeFunctionalPropertyHandler;
import org.coode.owl.rdfxml.parser.TypeInverseFunctionalPropertyHandler;
import org.coode.owl.rdfxml.parser.TypeIrreflexivePropertyHandler;
import org.coode.owl.rdfxml.parser.TypeListHandler;
import org.coode.owl.rdfxml.parser.TypeNegativeDataPropertyAssertionHandler;
import org.coode.owl.rdfxml.parser.TypeNegativeObjectPropertyAssertionHandler;
import org.coode.owl.rdfxml.parser.TypeObjectPropertyHandler;
import org.coode.owl.rdfxml.parser.TypeObjectRestrictionHandler;
import org.coode.owl.rdfxml.parser.TypeOntologyHandler;
import org.coode.owl.rdfxml.parser.TypePropertyHandler;
import org.coode.owl.rdfxml.parser.TypeRDFPropertyHandler;
import org.coode.owl.rdfxml.parser.TypeRDFSClassHandler;
import org.coode.owl.rdfxml.parser.TypeReflexivePropertyHandler;
import org.coode.owl.rdfxml.parser.TypeRestrictionHandler;
import org.coode.owl.rdfxml.parser.TypeSWRLAtomListHandler;
import org.coode.owl.rdfxml.parser.TypeSWRLBuiltInAtomHandler;
import org.coode.owl.rdfxml.parser.TypeSWRLBuiltInHandler;
import org.coode.owl.rdfxml.parser.TypeSWRLClassAtomHandler;
import org.coode.owl.rdfxml.parser.TypeSWRLDataRangeAtomHandler;
import org.coode.owl.rdfxml.parser.TypeSWRLDataValuedPropertyAtomHandler;
import org.coode.owl.rdfxml.parser.TypeSWRLDifferentIndividualsAtomHandler;
import org.coode.owl.rdfxml.parser.TypeSWRLImpHandler;
import org.coode.owl.rdfxml.parser.TypeSWRLIndividualPropertyAtomHandler;
import org.coode.owl.rdfxml.parser.TypeSWRLSameIndividualAtomHandler;
import org.coode.owl.rdfxml.parser.TypeSWRLVariableHandler;
import org.coode.owl.rdfxml.parser.TypeSelfRestrictionHandler;
import org.coode.owl.rdfxml.parser.TypeSymmetricPropertyHandler;
import org.coode.owl.rdfxml.parser.TypeTransitivePropertyHandler;
import org.coode.owl.rdfxml.parser.TypedConstantListItemTranslator;
import org.semanticweb.owl.io.RDFXMLOntologyFormat;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.SetOntologyURI;
import org.semanticweb.owl.util.CollectionFactory;
import org.semanticweb.owl.util.OWLDataUtil;
import org.semanticweb.owl.vocab.DublinCoreVocabulary;
import org.semanticweb.owl.vocab.Namespaces;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLRDFConsumer
implements RDFConsumer {
    private static final Logger logger = Logger.getLogger(OWLRDFConsumer.class.getName());
    private static final Logger tripleProcessor = Logger.getLogger("Triple processor");
    private OWLOntologyManager owlOntologyManager;
    private URI xmlBase;
    private AnonymousNodeChecker anonymousNodeChecker;
    private Set<URI> owlClassURIs;
    private Set<URI> objectPropertyURIs;
    private Set<URI> dataPropertyURIs;
    private Set<URI> propertyURIs;
    private Set<URI> individualURIs;
    private Set<URI> annotationPropertyURIs;
    private Set<URI> ontologyPropertyURIs;
    private Set<URI> dataRangeURIs;
    private URI firstOntologyURI;
    private Set<URI> ontologyURIs;
    private Set<URI> restrictionURIs;
    private Set<URI> selfRestrictionURIs;
    private Set<URI> objectRestrictionURIs;
    private Set<URI> dataRestrictionURIs;
    private Set<URI> listURIs;
    private Map<URI, URI> listRestTripleMap;
    private Map<URI, URI> listFirstResourceTripleMap;
    private Map<URI, OWLConstant> listFirstLiteralTripleMap;
    private Map<URI, OWLAxiom> reifiedAxiomsMap;
    private OptimisedListTranslator<OWLDescription> descriptionListTranslator;
    private OptimisedListTranslator<OWLIndividual> individualListTranslator;
    private OptimisedListTranslator<OWLObjectPropertyExpression> objectPropertyListTranslator;
    private OptimisedListTranslator<OWLConstant> constantListTranslator;
    private OptimisedListTranslator<OWLDataPropertyExpression> dataPropertyListTranslator;
    private Map<URI, BuiltInTypeHandler> builtInTypeTripleHandlers;
    private Map<URI, TriplePredicateHandler> predicateHandlers;
    private List<AbstractLiteralTripleHandler> literalTripleHandlers;
    private List<AbstractResourceTripleHandler> resourceTripleHandlers;
    private OWLOntology ontology;
    private RDFXMLOntologyFormat rdfxmlOntologyFormat;
    private OWLDataFactory dataFactory;
    private DescriptionTranslatorSelector descriptionTranslatorSelector;
    private OWLAxiom lastAddedAxiom;
    private Map<URI, URI> synonymMap;
    private Set<URI> swrlRules;
    private Set<URI> swrlIndividualPropertyAtoms;
    private Set<URI> swrlDataValuedPropertyAtoms;
    private Set<URI> swrlClassAtoms;
    private Set<URI> swrlDataRangeAtoms;
    private Set<URI> swrlBuiltInAtoms;
    private Set<URI> swrlVariables;
    private Set<URI> swrlSameAsAtoms;
    private Set<URI> swrlDifferentFromAtoms;
    private Map<String, URI> uriMap = CollectionFactory.createMap();
    int currentBaseCount = 0;
    private long t0;
    private int count = 0;
    private int addCount = 0;
    private Map<URI, OWLDescription> translatedDescriptions = new HashMap<URI, OWLDescription>();
    private Map<URI, Map<URI, Set<URI>>> resTriplesBySubject = CollectionFactory.createMap();
    private Map<URI, Map<URI, URI>> singleValuedResTriplesByPredicate = CollectionFactory.createMap();
    private Map<URI, Map<URI, Set<OWLConstant>>> litTriplesBySubject = CollectionFactory.createMap();
    private Map<URI, Map<URI, OWLConstant>> singleValuedLitTriplesByPredicate = CollectionFactory.createMap();

    public OWLRDFConsumer(OWLOntologyManager owlOntologyManager, OWLOntology ontology, AnonymousNodeChecker checker) {
        this.descriptionTranslatorSelector = new DescriptionTranslatorSelector(this);
        this.owlOntologyManager = owlOntologyManager;
        this.ontology = ontology;
        this.dataFactory = owlOntologyManager.getOWLDataFactory();
        this.anonymousNodeChecker = checker;
        this.owlClassURIs = CollectionFactory.createSet();
        this.objectPropertyURIs = CollectionFactory.createSet();
        this.dataPropertyURIs = CollectionFactory.createSet();
        this.individualURIs = CollectionFactory.createSet();
        this.annotationPropertyURIs = CollectionFactory.createSet();
        this.annotationPropertyURIs.addAll(OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTIES);
        this.ontologyPropertyURIs = CollectionFactory.createSet();
        this.ontologyPropertyURIs.add(OWLRDFVocabulary.OWL_PRIOR_VERSION.getURI());
        this.ontologyPropertyURIs.add(OWLRDFVocabulary.OWL_BACKWARD_COMPATIBLE_WITH.getURI());
        this.ontologyPropertyURIs.add(OWLRDFVocabulary.OWL_INCOMPATIBLE_WITH.getURI());
        this.addDublinCoreAnnotationURIs();
        this.dataRangeURIs = CollectionFactory.createSet();
        this.propertyURIs = CollectionFactory.createSet();
        this.restrictionURIs = CollectionFactory.createSet();
        this.selfRestrictionURIs = CollectionFactory.createSet();
        this.dataRestrictionURIs = CollectionFactory.createSet();
        this.ontologyURIs = CollectionFactory.createSet();
        this.objectRestrictionURIs = CollectionFactory.createSet();
        this.listURIs = CollectionFactory.createSet();
        this.listFirstLiteralTripleMap = CollectionFactory.createMap();
        this.listFirstResourceTripleMap = CollectionFactory.createMap();
        this.listRestTripleMap = CollectionFactory.createMap();
        this.reifiedAxiomsMap = CollectionFactory.createMap();
        this.descriptionListTranslator = new OptimisedListTranslator<OWLDescription>(this, new DescriptionListItemTranslator(this));
        this.individualListTranslator = new OptimisedListTranslator<OWLIndividual>(this, new IndividualListItemTranslator(this));
        this.constantListTranslator = new OptimisedListTranslator<OWLConstant>(this, new TypedConstantListItemTranslator(this));
        this.objectPropertyListTranslator = new OptimisedListTranslator<OWLObjectPropertyExpression>(this, new ObjectPropertyListItemTranslator(this));
        this.dataPropertyListTranslator = new OptimisedListTranslator<OWLDataPropertyExpression>(this, new DataPropertyListItemTranslator(this));
        this.builtInTypeTripleHandlers = CollectionFactory.createMap();
        this.setupTypeTripleHandlers();
        this.setupPredicateHandlers();
        this.literalTripleHandlers = new ArrayList<AbstractLiteralTripleHandler>();
        this.literalTripleHandlers.add(new GTPAnnotationLiteralHandler(this));
        this.literalTripleHandlers.add(new GTPDataPropertyAssertionHandler(this));
        this.literalTripleHandlers.add(new TPFirstLiteralHandler(this));
        this.resourceTripleHandlers = new ArrayList<AbstractResourceTripleHandler>();
        this.resourceTripleHandlers.add(new GTPAnnotationResourceTripleHandler(this));
        this.resourceTripleHandlers.add(new GTPObjectPropertyAssertionHandler(this));
        this.dataRangeURIs.addAll(XSDVocabulary.ALL_DATATYPES);
        this.dataRangeURIs.add(OWLRDFVocabulary.RDFS_LITERAL.getURI());
        this.swrlRules = new HashSet<URI>();
        this.swrlIndividualPropertyAtoms = new HashSet<URI>();
        this.swrlDataValuedPropertyAtoms = new HashSet<URI>();
        this.swrlClassAtoms = new HashSet<URI>();
        this.swrlDataRangeAtoms = new HashSet<URI>();
        this.swrlBuiltInAtoms = new HashSet<URI>();
        this.swrlVariables = new HashSet<URI>();
        this.swrlSameAsAtoms = new HashSet<URI>();
        this.swrlDifferentFromAtoms = new HashSet<URI>();
        this.setupSynonymMap();
        this.setupSinglePredicateMaps();
    }

    private void addSingleValuedResPredicate(OWLRDFVocabulary v) {
        Map map = CollectionFactory.createMap();
        this.singleValuedResTriplesByPredicate.put(v.getURI(), map);
    }

    private void addDublinCoreAnnotationURIs() {
        for (URI uri : DublinCoreVocabulary.ALL_URIS) {
            this.annotationPropertyURIs.add(uri);
        }
    }

    private void setupSinglePredicateMaps() {
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ON_PROPERTY);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_SOME_VALUES_FROM);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ALL_VALUES_FROM);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ON_CLASS);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ON_DATA_RANGE);
    }

    private void setupSynonymMap() {
        this.synonymMap = CollectionFactory.createMap();
        this.synonymMap.put(URI.create((Object)((Object)Namespaces.OWL) + "valuesFrom"), OWLRDFVocabulary.OWL_ON_CLASS.getURI());
        this.synonymMap.put(URI.create((Object)((Object)Namespaces.OWL) + "qualifiedMinCardinality"), OWLRDFVocabulary.OWL_MIN_CARDINALITY.getURI());
        this.synonymMap.put(URI.create((Object)((Object)Namespaces.OWL) + "qualifiedMaxCardinality"), OWLRDFVocabulary.OWL_MAX_CARDINALITY.getURI());
        this.synonymMap.put(URI.create((Object)((Object)Namespaces.OWL) + "qualifiedExactCardinality"), OWLRDFVocabulary.OWL_CARDINALITY.getURI());
        this.synonymMap.put(URI.create((Object)((Object)Namespaces.OWL) + "cardinalityType"), OWLRDFVocabulary.OWL_ON_CLASS.getURI());
        this.synonymMap.put(URI.create((Object)((Object)Namespaces.OWL) + "dataComplementOf"), OWLRDFVocabulary.OWL_COMPLEMENT_OF.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#subClassOf"), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#imports"), OWLRDFVocabulary.OWL_IMPORTS.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#range"), OWLRDFVocabulary.RDFS_RANGE.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#hasValue"), OWLRDFVocabulary.OWL_HAS_VALUE.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#type"), OWLRDFVocabulary.RDF_TYPE.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#domain"), OWLRDFVocabulary.RDFS_DOMAIN.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#versionInfo"), OWLRDFVocabulary.OWL_VERSION_INFO.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#comment"), OWLRDFVocabulary.RDFS_COMMENT.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#onProperty"), OWLRDFVocabulary.OWL_ON_PROPERTY.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#toClass"), OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#hasClass"), OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#Restriction"), OWLRDFVocabulary.OWL_RESTRICTION.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#Class"), OWLRDFVocabulary.OWL_CLASS.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#Thing"), OWLRDFVocabulary.OWL_THING.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#Nothing"), OWLRDFVocabulary.OWL_NOTHING.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#minCardinality"), OWLRDFVocabulary.OWL_MIN_CARDINALITY.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#cardinality"), OWLRDFVocabulary.OWL_CARDINALITY.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#maxCardinality"), OWLRDFVocabulary.OWL_MAX_CARDINALITY.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#inverseOf"), OWLRDFVocabulary.OWL_INVERSE_OF.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#samePropertyAs"), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#hasClassQ"), OWLRDFVocabulary.OWL_ON_CLASS.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#cardinalityQ"), OWLRDFVocabulary.OWL_CARDINALITY.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#maxCardinalityQ"), OWLRDFVocabulary.OWL_MAX_CARDINALITY.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#minCardinalityQ"), OWLRDFVocabulary.OWL_MIN_CARDINALITY.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#complementOf"), OWLRDFVocabulary.OWL_COMPLEMENT_OF.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#unionOf"), OWLRDFVocabulary.OWL_UNION_OF.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#intersectionOf"), OWLRDFVocabulary.OWL_INTERSECTION_OF.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#label"), OWLRDFVocabulary.RDFS_LABEL.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#ObjectProperty"), OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getURI());
        this.synonymMap.put(URI.create("http://www.daml.org/2001/03/daml+oil#DatatypeProperty"), OWLRDFVocabulary.OWL_DATA_PROPERTY.getURI());
        this.setupLegacyOWL11Stuff();
    }

    private void setupLegacyOWL11Stuff() {
        for (OWLRDFVocabulary oWLRDFVocabulary : OWLRDFVocabulary.values()) {
            this.addLegacyMapping(oWLRDFVocabulary);
        }
        for (Enum enum_ : OWLRestrictedDataRangeFacetVocabulary.values()) {
            this.synonymMap.put(URI.create(Namespaces.OWL.toString() + ((OWLRestrictedDataRangeFacetVocabulary)enum_).getShortName()), ((OWLRestrictedDataRangeFacetVocabulary)enum_).getURI());
            this.synonymMap.put(URI.create(Namespaces.OWL11.toString() + ((OWLRestrictedDataRangeFacetVocabulary)enum_).getShortName()), ((OWLRestrictedDataRangeFacetVocabulary)enum_).getURI());
        }
    }

    private void addLegacyMapping(OWLRDFVocabulary v) {
        if (v.getNamespace().equals((Object)Namespaces.OWL2)) {
            this.synonymMap.put(URI.create(Namespaces.OWL.toString() + v.getShortName()), v.getURI());
            this.synonymMap.put(URI.create(Namespaces.OWL11.toString() + v.getShortName()), v.getURI());
        }
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public RDFXMLOntologyFormat getOntologyFormat() {
        return this.rdfxmlOntologyFormat;
    }

    public void setOntologyFormat(RDFXMLOntologyFormat format) {
        this.rdfxmlOntologyFormat = format;
    }

    private void addBuiltInTypeTripleHandler(BuiltInTypeHandler handler) {
        this.builtInTypeTripleHandlers.put(handler.getTypeURI(), handler);
    }

    private void setupTypeTripleHandlers() {
        this.addBuiltInTypeTripleHandler(new TypeAntisymmetricPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeClassHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDataPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDatatypeHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeFunctionalDataPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeFunctionalObjectPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeFunctionalPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeInverseFunctionalPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeIrreflexivePropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeObjectPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeReflexivePropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSymmetricPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeTransitivePropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeRestrictionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeObjectRestrictionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDataRestrictionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeListHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeAnnotationPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDeprecatedClassHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDataRangeHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeAllDifferentHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeOntologyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeNegativeObjectPropertyAssertionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeNegativeDataPropertyAssertionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeAxiomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeRDFPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeRDFSClassHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSelfRestrictionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypePropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeAllDisjointClassesHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeAllDisjointPropertiesHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLAtomListHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLBuiltInAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLBuiltInHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLClassAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLDataRangeAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLDataValuedPropertyAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLDifferentIndividualsAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLImpHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLIndividualPropertyAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLSameIndividualAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLVariableHandler(this));
    }

    private void addPredicateHandler(TriplePredicateHandler predicateHandler) {
        this.predicateHandlers.put(predicateHandler.getPredicateURI(), predicateHandler);
    }

    private void setupPredicateHandlers() {
        this.predicateHandlers = CollectionFactory.createMap();
        this.addPredicateHandler(new TPDataPropertDomainHandler(this));
        this.addPredicateHandler(new TPDataPropertyRangeHandler(this));
        this.addPredicateHandler(new TPDifferentFromHandler(this));
        this.addPredicateHandler(new TPDisjointDataPropertiesHandler(this));
        this.addPredicateHandler(new TPDisjointObjectPropertiesHandler(this));
        this.addPredicateHandler(new TPDisjointUnionHandler(this));
        this.addPredicateHandler(new TPDisjointWithHandler(this));
        this.addPredicateHandler(new TPEquivalentClassHandler(this));
        this.addPredicateHandler(new TPEquivalentDataPropertyHandler(this));
        this.addPredicateHandler(new TPEquivalentObjectPropertyHandler(this));
        this.addPredicateHandler(new TPEquivalentPropertyHandler(this));
        this.addPredicateHandler(new TPObjectPropertyDomainHandler(this));
        this.addPredicateHandler(new TPObjectPropertyRangeHandler(this));
        this.addPredicateHandler(new TPPropertyDomainHandler(this));
        this.addPredicateHandler(new TPPropertyRangeHandler(this));
        this.addPredicateHandler(new TPSameAsHandler(this));
        this.addPredicateHandler(new TPSubClassOfHandler(this));
        this.addPredicateHandler(new TPSubDataPropertyOfHandler(this));
        this.addPredicateHandler(new TPSubObjectPropertyOfHandler(this));
        this.addPredicateHandler(new TPSubPropertyOfHandler(this));
        this.addPredicateHandler(new TPTypeHandler(this));
        this.addPredicateHandler(new TPInverseOfHandler(this));
        this.addPredicateHandler(new TPDistinctMembersHandler(this));
        this.addPredicateHandler(new TPImportsHandler(this));
        this.addPredicateHandler(new TPIntersectionOfHandler(this));
        this.addPredicateHandler(new TPUnionOfHandler(this));
        this.addPredicateHandler(new TPComplementOfHandler(this));
        this.addPredicateHandler(new TPOneOfHandler(this));
        this.addPredicateHandler(new TPOnPropertyHandler(this));
        this.addPredicateHandler(new TPSomeValuesFromHandler(this));
        this.addPredicateHandler(new TPAllValuesFromHandler(this));
        this.addPredicateHandler(new TPRestHandler(this));
        this.addPredicateHandler(new TPFirstResourceHandler(this));
        this.addPredicateHandler(new TPDeclaredAsHandler(this));
    }

    public OWLDataFactory getDataFactory() {
        return this.dataFactory;
    }

    private URI getURI(String s) {
        URI uri = this.uriMap.get(s);
        if (uri == null) {
            uri = URI.create(s);
            this.uriMap.put(s, uri);
        }
        return uri;
    }

    public void importsClosureChanged() {
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            this.annotationPropertyURIs.addAll(ont.getAnnotationURIs());
        }
    }

    protected boolean isAnonymousNode(URI uri) {
        return this.anonymousNodeChecker.isAnonymousNode(uri);
    }

    protected void addAxiom(OWLAxiom axiom) throws OWLException {
        this.owlOntologyManager.applyChange(new AddAxiom(this.ontology, axiom));
        this.lastAddedAxiom = axiom;
    }

    public OWLAxiom getLastAddedAxiom() {
        return this.lastAddedAxiom;
    }

    protected void addOWLClass(URI uri) {
        this.owlClassURIs.add(uri);
    }

    protected void addOWLObjectProperty(URI uri) {
        this.objectPropertyURIs.add(uri);
    }

    protected void addIndividual(URI uri) {
        this.individualURIs.add(uri);
    }

    protected boolean isIndividual(URI uri) {
        return this.individualURIs.contains(uri);
    }

    protected void addRDFProperty(URI uri) {
        this.propertyURIs.add(uri);
    }

    protected boolean isRDFProperty(URI uri) {
        return this.propertyURIs.contains(uri);
    }

    protected void addOWLDataProperty(URI uri) {
        this.dataPropertyURIs.add(uri);
    }

    protected void addOWLDatatype(URI uri) {
        this.dataRangeURIs.add(uri);
    }

    public void addOWLDataRange(URI uri) {
        this.dataRangeURIs.add(uri);
    }

    protected void addRestriction(URI uri) {
        this.restrictionURIs.add(uri);
    }

    protected void addSelfRestriction(URI uri) {
        this.selfRestrictionURIs.add(uri);
    }

    public boolean isSelfRestriction(URI uri) {
        return this.selfRestrictionURIs.contains(uri);
    }

    protected void addObjectRestriction(URI uri) {
        this.objectRestrictionURIs.add(uri);
    }

    protected void addDataRestriction(URI uri) {
        this.dataRestrictionURIs.add(uri);
    }

    protected void addAnnotationProperty(URI uri) {
        this.annotationPropertyURIs.add(uri);
        if (this.rdfxmlOntologyFormat != null) {
            this.rdfxmlOntologyFormat.addAnnotationURI(uri);
        }
    }

    public boolean isRestriction(URI uri) {
        return this.restrictionURIs.contains(uri);
    }

    public boolean isObjectRestriction(URI uri) {
        return this.objectRestrictionURIs.contains(uri);
    }

    public boolean isDataRestriction(URI uri) {
        return this.dataRestrictionURIs.contains(uri);
    }

    protected boolean isClass(URI uri) {
        if (this.owlClassURIs.contains(uri)) {
            return true;
        }
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            if (!ont.containsClassReference(uri)) continue;
            return true;
        }
        return false;
    }

    protected boolean isObjectPropertyOnly(URI uri) {
        if (this.dataPropertyURIs.contains(uri)) {
            return false;
        }
        if (this.objectPropertyURIs.contains(uri)) {
            return true;
        }
        boolean containsObjectPropertyReference = false;
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            if (ont.containsDataPropertyReference(uri)) {
                return false;
            }
            if (!ont.containsObjectPropertyReference(uri)) continue;
            containsObjectPropertyReference = true;
        }
        return containsObjectPropertyReference;
    }

    protected boolean isDataPropertyOnly(URI uri) {
        if (this.objectPropertyURIs.contains(uri)) {
            return false;
        }
        if (this.dataPropertyURIs.contains(uri)) {
            return true;
        }
        boolean containsDataPropertyReference = false;
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            if (ont.containsObjectPropertyReference(uri)) {
                return false;
            }
            if (!ont.containsDataPropertyReference(uri)) continue;
            containsDataPropertyReference = true;
        }
        return containsDataPropertyReference;
    }

    protected boolean isOntologyProperty(URI uri) {
        return this.ontologyPropertyURIs.contains(uri);
    }

    protected boolean isAnnotationProperty(URI uri) {
        if (this.annotationPropertyURIs.contains(uri)) {
            return true;
        }
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            if (ont.equals(this.ontology)) continue;
            if (ont.getAnnotationURIs().contains(uri)) {
                this.annotationPropertyURIs.addAll(ont.getAnnotationURIs());
                return this.annotationPropertyURIs.contains(uri);
            }
            OWLOntologyFormat format = this.owlOntologyManager.getOntologyFormat(ont);
            if (!(format instanceof RDFXMLOntologyFormat)) continue;
            RDFXMLOntologyFormat rdfFormat = (RDFXMLOntologyFormat)format;
            this.annotationPropertyURIs.addAll(rdfFormat.getAnnotationURIs());
            return this.annotationPropertyURIs.contains(uri);
        }
        return false;
    }

    protected boolean isOntology(URI uri) {
        return this.ontologyURIs.contains(uri);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }

    protected OWLClass getOWLClass(URI uri) {
        return this.getDataFactory().getOWLClass(uri);
    }

    protected OWLObjectProperty getOWLObjectProperty(URI uri) {
        return this.getDataFactory().getOWLObjectProperty(uri);
    }

    protected OWLDataProperty getOWLDataProperty(URI uri) {
        return this.getDataFactory().getOWLDataProperty(uri);
    }

    protected OWLIndividual getOWLIndividual(URI uri) {
        if (this.isAnonymousNode(uri)) {
            return this.getDataFactory().getOWLAnonymousIndividual(uri);
        }
        return this.getDataFactory().getOWLIndividual(uri);
    }

    protected void consumeTriple(URI subject, URI predicate, URI object) {
        this.isTriplePresent(subject, predicate, object, true);
    }

    protected void consumeTriple(URI subject, URI predicate, OWLConstant con) {
        this.isTriplePresent(subject, predicate, con, true);
    }

    protected void addSWRLRule(URI uri) {
        this.swrlRules.add(uri);
    }

    protected boolean isSWRLRule(URI uri) {
        return this.swrlRules.contains(uri);
    }

    protected void addSWRLIndividualPropertyAtom(URI uri) {
        this.swrlIndividualPropertyAtoms.add(uri);
    }

    protected boolean isSWRLIndividualPropertyAtom(URI uri) {
        return this.swrlIndividualPropertyAtoms.contains(uri);
    }

    protected void addSWRLDataPropertyAtom(URI uri) {
        this.swrlDataValuedPropertyAtoms.add(uri);
    }

    protected boolean isSWRLDataValuedPropertyAtom(URI uri) {
        return this.swrlDataValuedPropertyAtoms.contains(uri);
    }

    protected void addSWRLClassAtom(URI uri) {
        this.swrlClassAtoms.add(uri);
    }

    protected boolean isSWRLClassAtom(URI uri) {
        return this.swrlClassAtoms.contains(uri);
    }

    protected void addSWRLSameAsAtom(URI uri) {
        this.swrlSameAsAtoms.add(uri);
    }

    protected boolean isSWRLSameAsAtom(URI uri) {
        return this.swrlSameAsAtoms.contains(uri);
    }

    protected void addSWRLDifferentFromAtom(URI uri) {
        this.swrlDifferentFromAtoms.add(uri);
    }

    protected boolean isSWRLDifferentFromAtom(URI uri) {
        return this.swrlDifferentFromAtoms.contains(uri);
    }

    protected void addSWRLDataRangeAtom(URI uri) {
        this.swrlDataRangeAtoms.add(uri);
    }

    protected boolean isSWRLDataRangeAtom(URI uri) {
        return this.swrlDataRangeAtoms.contains(uri);
    }

    protected void addSWRLBuiltInAtom(URI uri) {
        this.swrlBuiltInAtoms.add(uri);
    }

    protected boolean isSWRLBuiltInAtom(URI uri) {
        return this.swrlBuiltInAtoms.contains(uri);
    }

    protected void addSWRLVariable(URI uri) {
        this.swrlVariables.add(uri);
    }

    protected boolean isSWRLVariable(URI uri) {
        return this.swrlVariables.contains(uri);
    }

    public void handle(URI subject, URI predicate, URI object) throws OWLException {
        AbstractResourceTripleHandler handler;
        if (predicate.equals(OWLRDFVocabulary.RDF_TYPE.getURI())) {
            BuiltInTypeHandler typeHandler = this.builtInTypeTripleHandlers.get(object);
            if (typeHandler != null) {
                typeHandler.handleTriple(subject, predicate, object);
                return;
            }
            this.addIndividual(subject);
        }
        if ((handler = (AbstractResourceTripleHandler)this.predicateHandlers.get(predicate)) != null) {
            if (handler.canHandle(subject, predicate, object)) {
                handler.handleTriple(subject, predicate, object);
            }
            return;
        }
    }

    public void handle(URI subject, URI predicate, OWLConstant object) throws OWLException {
        for (AbstractLiteralTripleHandler handler : this.literalTripleHandlers) {
            if (!handler.canHandle(subject, predicate, object)) continue;
            handler.handleTriple(subject, predicate, object);
            break;
        }
    }

    private static void printTriple(Object subject, Object predicate, Object object, BufferedWriter w) {
        try {
            w.append(subject.toString());
            w.append(" -> ");
            w.append(predicate.toString());
            w.append(" -> ");
            w.append(object.toString());
            w.append("\n");
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void dumpRemainingTriples() {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        try {
            Set objects;
            Comparable<URI> object;
            Map<URI, Object> map;
            StringWriter sw = new StringWriter();
            BufferedWriter w = new BufferedWriter(sw);
            for (URI predicate : this.singleValuedResTriplesByPredicate.keySet()) {
                map = this.singleValuedResTriplesByPredicate.get(predicate);
                for (URI subject : map.keySet()) {
                    object = (URI)map.get(subject);
                    OWLRDFConsumer.printTriple(subject, predicate, object, w);
                }
            }
            for (URI predicate : this.singleValuedLitTriplesByPredicate.keySet()) {
                map = this.singleValuedLitTriplesByPredicate.get(predicate);
                for (URI subject : map.keySet()) {
                    object = (OWLConstant)map.get(subject);
                    OWLRDFConsumer.printTriple(subject, predicate, object, w);
                }
            }
            for (URI subject : new ArrayList<URI>(this.resTriplesBySubject.keySet())) {
                map = this.resTriplesBySubject.get(subject);
                for (URI predicate : new ArrayList<URI>(map.keySet())) {
                    objects = (Set)map.get(predicate);
                    for (Comparable<URI> object2 : objects) {
                        OWLRDFConsumer.printTriple(subject, predicate, object2, w);
                    }
                }
            }
            for (URI subject : new ArrayList<URI>(this.litTriplesBySubject.keySet())) {
                map = this.litTriplesBySubject.get(subject);
                for (URI predicate : new ArrayList<URI>(map.keySet())) {
                    objects = (Set)map.get(predicate);
                    for (Comparable<URI> object2 : objects) {
                        OWLRDFConsumer.printTriple(subject, predicate, object2, w);
                    }
                }
            }
            w.flush();
            logger.fine(sw.getBuffer().toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void incrementTripleCount() {
        ++this.count;
        if (tripleProcessor.isLoggable(Level.FINE) && this.count % 10000 == 0) {
            tripleProcessor.fine("Parsed: " + this.count + " triples");
        }
    }

    @Override
    public void startModel(String string) throws SAXException {
        this.count = 0;
        this.t0 = System.currentTimeMillis();
    }

    @Override
    public void endModel() throws SAXException {
        try {
            Set<Comparable<URI>> objects;
            Map<URI, Set<Comparable<URI>>> map;
            this.uriMap.clear();
            tripleProcessor.fine("Total number of triples: " + this.count);
            RDFXMLOntologyFormat format = this.getOntologyFormat();
            if (format != null) {
                format.setNumberOfTriplesProcessedDuringLoading(this.count);
            }
            if (!this.ontologyURIs.contains(this.ontology.getURI())) {
                if (this.ontologyURIs.size() == 1) {
                    this.owlOntologyManager.applyChange(new SetOntologyURI(this.ontology, this.firstOntologyURI));
                } else if (this.ontologyURIs.isEmpty()) {
                    if (this.xmlBase == null) {
                        logger.fine("There are no resources which are typed as ontologies.  Cannot determine the URI of the ontology being parsed - using physical URI.");
                    } else {
                        logger.fine("There are no resources which are typed as ontologies.  Cannot determine the URI of the ontology being parsed - using xml:base.");
                        this.owlOntologyManager.applyChange(new SetOntologyURI(this.ontology, this.xmlBase));
                    }
                } else {
                    logger.fine("There are multiple resources which are typed as ontologies.  Using the first encountered ontology URI.");
                    this.owlOntologyManager.applyChange(new SetOntologyURI(this.ontology, this.firstOntologyURI));
                }
            }
            if (tripleProcessor.isLoggable(Level.FINE)) {
                tripleProcessor.fine("Loaded " + this.ontology.getURI());
            }
            SWRLRuleTranslator translator = new SWRLRuleTranslator(this);
            for (URI ruleURI : this.swrlRules) {
                translator.translateRule(ruleURI);
            }
            for (URI subject : new ArrayList<URI>(this.resTriplesBySubject.keySet())) {
                map = this.resTriplesBySubject.get(subject);
                if (map == null) continue;
                for (URI predicate : new ArrayList<URI>(map.keySet())) {
                    objects = map.get(predicate);
                    if (objects == null) continue;
                    for (Comparable<URI> object : new ArrayList<URI>(objects)) {
                        this.handle(subject, predicate, (URI)object);
                    }
                }
            }
            for (URI subject : new ArrayList<URI>(this.resTriplesBySubject.keySet())) {
                map = this.resTriplesBySubject.get(subject);
                if (map == null) continue;
                for (URI predicate : new ArrayList<URI>(map.keySet())) {
                    objects = map.get(predicate);
                    if (objects == null) continue;
                    block8: for (Comparable<URI> object : new ArrayList<URI>(objects)) {
                        for (AbstractResourceTripleHandler resTripHandler : this.resourceTripleHandlers) {
                            if (!resTripHandler.canHandle(subject, predicate, (URI)object)) continue;
                            resTripHandler.handleTriple(subject, predicate, (URI)object);
                            continue block8;
                        }
                    }
                }
            }
            for (URI subject : new ArrayList<URI>(this.litTriplesBySubject.keySet())) {
                map = this.litTriplesBySubject.get(subject);
                if (map == null) continue;
                for (URI predicate : new ArrayList<URI>(map.keySet())) {
                    objects = map.get(predicate);
                    for (Comparable<URI> object : new ArrayList<URI>(objects)) {
                        this.handle(subject, predicate, (OWLConstant)object);
                    }
                }
            }
            this.translateDanglingEntities();
            this.dumpRemainingTriples();
        }
        catch (OWLException e) {
            throw new SAXException(e);
        }
        this.cleanup();
    }

    private void translateDanglingEntities() throws OWLException {
        OWLProperty<OWLObjectPropertyExpression, OWLDescription> prop;
        this.owlClassURIs.remove(OWLRDFVocabulary.OWL_THING.getURI());
        this.owlClassURIs.remove(OWLRDFVocabulary.OWL_NOTHING.getURI());
        for (URI clsURI : this.owlClassURIs) {
            if (this.isAnonymousNode(clsURI)) continue;
            OWLClass cls = this.getDataFactory().getOWLClass(clsURI);
            this.addDeclarationIfNecessary(cls);
        }
        for (URI propURI : this.objectPropertyURIs) {
            if (this.isAnonymousNode(propURI)) continue;
            prop = this.getDataFactory().getOWLObjectProperty(propURI);
            this.addDeclarationIfNecessary(prop);
        }
        for (URI propURI : this.dataPropertyURIs) {
            prop = this.getDataFactory().getOWLDataProperty(propURI);
            this.addDeclarationIfNecessary(prop);
        }
    }

    private void addDeclarationIfNecessary(OWLEntity entity) throws OWLException {
        OWLOntology ont = this.getOntology();
        if (!ont.containsEntityReference(entity)) {
            boolean ref = false;
            for (OWLOntology o : this.getOWLOntologyManager().getImportsClosure(ont)) {
                if (!o.equals(ont) && (ref = o.containsEntityReference(entity))) break;
            }
            if (!ref) {
                this.addAxiom(this.getDataFactory().getOWLDeclarationAxiom(entity));
            }
        }
    }

    private void cleanup() {
        this.owlClassURIs.clear();
        this.objectPropertyURIs.clear();
        this.dataPropertyURIs.clear();
        this.dataRangeURIs.clear();
        this.restrictionURIs.clear();
        this.objectRestrictionURIs.clear();
        this.dataRestrictionURIs.clear();
        this.listFirstLiteralTripleMap.clear();
        this.listFirstResourceTripleMap.clear();
        this.listRestTripleMap.clear();
        this.translatedDescriptions.clear();
        this.listURIs.clear();
        this.resTriplesBySubject.clear();
        this.litTriplesBySubject.clear();
        this.singleValuedLitTriplesByPredicate.clear();
        this.singleValuedResTriplesByPredicate.clear();
    }

    @Override
    public void addModelAttribte(String string, String string1) throws SAXException {
    }

    @Override
    public void includeModel(String string, String string1) throws SAXException {
    }

    @Override
    public void logicalURI(String string) throws SAXException {
    }

    public URI checkForSynonym(URI original) {
        URI synonymURI = this.synonymMap.get(original);
        if (synonymURI != null) {
            return synonymURI;
        }
        return original;
    }

    @Override
    public void statementWithLiteralValue(String subject, String predicate, String object, String lang, String datatype) throws SAXException {
        this.incrementTripleCount();
        try {
            URI subjectURI = this.getURI(subject);
            URI predicateURI = this.getURI(predicate);
            predicateURI = this.checkForSynonym(predicateURI);
            this.handleStreaming(subjectURI, predicateURI, object, datatype, lang);
        }
        catch (OWLException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Override
    public void statementWithResourceValue(String subject, String predicate, String object) throws SAXException {
        try {
            this.incrementTripleCount();
            URI subjectURI = this.getURI(subject);
            URI predicateURI = this.getURI(predicate);
            predicateURI = this.checkForSynonym(predicateURI);
            URI objectURI = this.checkForSynonym(this.getURI(object));
            this.handleStreaming(subjectURI, predicateURI, objectURI);
        }
        catch (OWLException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void handleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        AbstractResourceTripleHandler handler;
        if (predicate.equals(OWLRDFVocabulary.RDF_TYPE.getURI())) {
            handler = this.builtInTypeTripleHandlers.get(object);
            if (handler != null) {
                if (((BuiltInTypeHandler)handler).canHandleStreaming(subject, predicate, object)) {
                    handler.handleTriple(subject, predicate, object);
                    return;
                }
            } else {
                this.addIndividual(subject);
            }
        }
        if ((handler = (AbstractResourceTripleHandler)this.predicateHandlers.get(predicate)) != null && handler.canHandleStreaming(subject, predicate, object)) {
            handler.handleTriple(subject, predicate, object);
            return;
        }
        this.addTriple(subject, predicate, object);
    }

    private void handleStreaming(URI subject, URI predicate, String literal, String datatype, String lang) throws OWLException {
        OWLConstant con = this.getOWLConstant(literal, datatype, lang);
        for (AbstractLiteralTripleHandler handler : this.literalTripleHandlers) {
            if (!handler.canHandleStreaming(subject, predicate, con)) continue;
            handler.handleTriple(subject, predicate, con);
            return;
        }
        this.addTriple(subject, predicate, con);
    }

    private OWLConstant getOWLConstant(String literal, String datatype, String lang) {
        if (datatype != null) {
            return this.dataFactory.getOWLTypedConstant(literal, this.dataFactory.getOWLDataType(this.getURI(datatype)));
        }
        if (lang != null) {
            return this.dataFactory.getOWLUntypedConstant(literal, lang);
        }
        return this.dataFactory.getOWLUntypedConstant(literal);
    }

    public OWLDataRange translateDataRange(URI uri) throws OWLException {
        URI oneOfObject = this.getResourceObject(uri, OWLRDFVocabulary.OWL_ONE_OF.getURI(), true);
        if (oneOfObject != null) {
            Set<OWLConstant> constants = this.translateToConstantSet(oneOfObject);
            HashSet<OWLTypedConstant> typedConstants = new HashSet<OWLTypedConstant>(constants.size());
            for (OWLConstant con : constants) {
                if (con.isTyped()) {
                    typedConstants.add((OWLTypedConstant)con);
                    continue;
                }
                typedConstants.add(this.getDataFactory().getOWLTypedConstant(con.getLiteral(), this.getDataFactory().getOWLDataType(XSDVocabulary.STRING.getURI())));
            }
            return this.getDataFactory().getOWLDataOneOf(typedConstants);
        }
        URI complementOfObject = this.getResourceObject(uri, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getURI(), true);
        if (complementOfObject != null) {
            OWLDataRange operand = this.translateDataRange(complementOfObject);
            return this.getDataFactory().getOWLDataComplementOf(operand);
        }
        URI onDataRangeObject = this.getResourceObject(uri, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getURI(), true);
        if (onDataRangeObject != null) {
            OWLDataRange restrictedDataRange = this.translateDataRange(onDataRangeObject);
            HashSet<OWLDataRangeFacetRestriction> restrictions = new HashSet<OWLDataRangeFacetRestriction>();
            for (URI facetURI : OWLRestrictedDataRangeFacetVocabulary.FACET_URIS) {
                OWLConstant val;
                while ((val = this.getLiteralObject(uri, facetURI, true)) != null) {
                    if (val.isTyped()) {
                        restrictions.add(this.dataFactory.getOWLDataRangeFacetRestriction(OWLRestrictedDataRangeFacetVocabulary.getFacet(facetURI), (OWLTypedConstant)val));
                        continue;
                    }
                    restrictions.add(this.dataFactory.getOWLDataRangeFacetRestriction(OWLRestrictedDataRangeFacetVocabulary.getFacet(facetURI), this.dataFactory.getOWLTypedConstant(val.getLiteral(), OWLDataUtil.getIntDataType(this.dataFactory))));
                }
            }
            return this.dataFactory.getOWLDataRangeRestriction(restrictedDataRange, restrictions);
        }
        return this.getDataFactory().getOWLDataType(uri);
    }

    public OWLDataPropertyExpression translateDataPropertyExpression(URI uri) throws OWLException {
        return this.dataFactory.getOWLDataProperty(uri);
    }

    public OWLObjectPropertyExpression translateObjectPropertyExpression(URI mainNode) throws OWLException {
        if (this.isList(mainNode, false)) {
            throw new OWLRDFParserException("Attempting to translate an object property list as a property expression!");
        }
        this.addOWLObjectProperty(mainNode);
        if (!this.isAnonymousNode(mainNode)) {
            return this.getDataFactory().getOWLObjectProperty(mainNode);
        }
        URI inverseOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_INVERSE_OF.getURI(), true);
        if (inverseOfObject == null) {
            throw new IllegalStateException("Attempting to translate inverse property (anon property), but inverseOf triple is missing (" + mainNode + ")");
        }
        OWLObjectPropertyExpression otherProperty = this.translateObjectPropertyExpression(inverseOfObject);
        return this.getDataFactory().getOWLObjectPropertyInverse(otherProperty);
    }

    public OWLIndividual translateIndividual(URI node) throws OWLException {
        return this.getOWLIndividual(node);
    }

    public OWLDescription translateDescription(URI mainNode) throws OWLException {
        if (!this.isAnonymousNode(mainNode)) {
            return this.getDataFactory().getOWLClass(mainNode);
        }
        OWLDescription desc = this.translatedDescriptions.get(mainNode);
        if (desc == null) {
            DescriptionTranslator translator = this.descriptionTranslatorSelector.getDescriptionTranslator(mainNode);
            if (translator != null) {
                desc = translator.translate(mainNode);
                this.translatedDescriptions.put(mainNode, desc);
                this.restrictionURIs.remove(mainNode);
                this.objectRestrictionURIs.remove(mainNode);
            } else {
                logger.fine("Unable to determine the type of description from the available triples - assuming owl:Class");
                return this.getDataFactory().getOWLClass(mainNode);
            }
        }
        return desc;
    }

    public OWLDescription getDescriptionIfTranslated(URI mainNode) {
        return this.translatedDescriptions.get(mainNode);
    }

    public List<OWLObjectPropertyExpression> translateToObjectPropertyList(URI mainNode) throws OWLException {
        return this.objectPropertyListTranslator.translateList(mainNode);
    }

    public List<OWLDataPropertyExpression> translateToDataPropertyList(URI mainNode) throws OWLException {
        return this.dataPropertyListTranslator.translateList(mainNode);
    }

    public Set<OWLDescription> translateToDescriptionSet(URI mainNode) throws OWLException {
        return this.descriptionListTranslator.translateToSet(mainNode);
    }

    public Set<OWLConstant> translateToConstantSet(URI mainNode) throws OWLException {
        return this.constantListTranslator.translateToSet(mainNode);
    }

    public Set<OWLIndividual> translateToIndividualSet(URI mainNode) throws OWLException {
        return this.individualListTranslator.translateToSet(mainNode);
    }

    public URI getResourceObject(URI subject, URI predicate, boolean consume) {
        Set<URI> objects;
        Map<URI, URI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            URI obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj;
        }
        Map<URI, Set<URI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null && !objects.isEmpty()) {
            URI object = objects.iterator().next();
            if (consume) {
                objects.remove(object);
            }
            if (objects.isEmpty()) {
                predObjMap.remove(predicate);
                if (predObjMap.isEmpty()) {
                    this.resTriplesBySubject.remove(subject);
                }
            }
            return object;
        }
        return null;
    }

    public OWLConstant getLiteralObject(URI subject, URI predicate, boolean consume) {
        Set<OWLConstant> objects;
        Map<URI, OWLConstant> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            OWLConstant obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj;
        }
        Map<URI, Set<OWLConstant>> predObjMap = this.litTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null && !objects.isEmpty()) {
            OWLConstant object = objects.iterator().next();
            if (consume) {
                objects.remove(object);
            }
            if (objects.isEmpty()) {
                predObjMap.remove(predicate);
            }
            return object;
        }
        return null;
    }

    public boolean isTriplePresent(URI subject, URI predicate, URI object, boolean consume) {
        Set<URI> objects;
        Map<URI, URI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            URI obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj != null;
        }
        Map<URI, Set<URI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null) {
            if (objects.contains(object)) {
                if (consume) {
                    objects.remove(object);
                    if (objects.isEmpty()) {
                        predObjMap.remove(predicate);
                        if (predObjMap.isEmpty()) {
                            this.resTriplesBySubject.remove(subject);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isTriplePresent(URI subject, URI predicate, OWLConstant object, boolean consume) {
        Set<OWLConstant> objects;
        Map<URI, OWLConstant> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            OWLConstant obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj != null;
        }
        Map<URI, Set<OWLConstant>> predObjMap = this.litTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null) {
            if (objects.contains(object)) {
                if (consume) {
                    objects.remove(object);
                    if (objects.isEmpty()) {
                        predObjMap.remove(predicate);
                        if (predObjMap.isEmpty()) {
                            this.litTriplesBySubject.remove(subject);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean hasPredicate(URI subject, URI predicate) {
        boolean b;
        Map<URI, URI> resPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (resPredMap != null) {
            return resPredMap.containsKey(subject);
        }
        Map<URI, OWLConstant> litPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (litPredMap != null) {
            return litPredMap.containsKey(subject);
        }
        Map<URI, Set<URI>> resPredObjMap = this.resTriplesBySubject.get(subject);
        if (resPredObjMap != null && (b = resPredObjMap.containsKey(predicate))) {
            return true;
        }
        Map<URI, Set<OWLConstant>> litPredObjMap = this.litTriplesBySubject.get(subject);
        if (litPredObjMap != null) {
            return litPredObjMap.containsKey(predicate);
        }
        return false;
    }

    public boolean hasPredicateObject(URI subject, URI predicate, URI object) throws OWLException {
        Set<URI> objects;
        Map<URI, URI> predMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (predMap != null) {
            URI objectURI = predMap.get(subject);
            if (objectURI == null) {
                return false;
            }
            return objectURI.equals(object);
        }
        Map<URI, Set<URI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null) {
            return objects.contains(object);
        }
        return false;
    }

    public void addList(URI uri) {
        this.listURIs.add(uri);
    }

    public boolean isList(URI uri, boolean consume) {
        if (consume) {
            return this.listURIs.remove(uri);
        }
        return this.listURIs.contains(uri);
    }

    public void addRest(URI subject, URI object) {
        this.listRestTripleMap.put(subject, object);
    }

    public void addFirst(URI subject, URI object) {
        this.listFirstResourceTripleMap.put(subject, object);
    }

    public URI getFirstResource(URI subject, boolean consume) {
        if (consume) {
            return this.listFirstResourceTripleMap.remove(subject);
        }
        return this.listFirstResourceTripleMap.get(subject);
    }

    public OWLConstant getFirstLiteral(URI subject) {
        return this.listFirstLiteralTripleMap.get(subject);
    }

    public URI getRest(URI subject, boolean consume) {
        if (consume) {
            return this.listRestTripleMap.remove(subject);
        }
        return this.listRestTripleMap.get(subject);
    }

    public void addFirst(URI subject, OWLConstant object) {
        this.listFirstLiteralTripleMap.put(subject, object);
    }

    public void addOntology(URI uri) {
        if (this.ontologyURIs.isEmpty()) {
            this.firstOntologyURI = uri;
        }
        this.ontologyURIs.add(uri);
    }

    public void addReifiedAxiom(URI axiomURI, OWLAxiom axiom) {
        this.reifiedAxiomsMap.put(axiomURI, axiom);
    }

    public boolean isAxiom(URI uri) {
        return this.reifiedAxiomsMap.containsKey(uri);
    }

    public OWLAxiom getAxiom(URI uri) {
        return this.reifiedAxiomsMap.get(uri);
    }

    public boolean isDataRange(URI uri) {
        return this.dataRangeURIs.contains(uri);
    }

    public void addTriple(URI subject, URI predicate, URI object) {
        Map<URI, URI> subjObjMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjObjMap != null) {
            subjObjMap.put(subject, object);
        } else {
            Set<URI> objects;
            Map<URI, Set<URI>> map = this.resTriplesBySubject.get(subject);
            if (map == null) {
                map = CollectionFactory.createMap();
                this.resTriplesBySubject.put(subject, map);
            }
            if ((objects = map.get(predicate)) == null) {
                objects = new FakeSet<URI>();
                map.put(predicate, objects);
            }
            objects.add(object);
        }
    }

    public void addTriple(URI subject, URI predicate, OWLConstant con) {
        Map<URI, OWLConstant> subjObjMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjObjMap != null) {
            subjObjMap.put(subject, con);
        } else {
            Set<OWLConstant> objects;
            Map<URI, Set<OWLConstant>> map = this.litTriplesBySubject.get(subject);
            if (map == null) {
                map = CollectionFactory.createMap();
                this.litTriplesBySubject.put(subject, map);
            }
            if ((objects = map.get(predicate)) == null) {
                objects = new FakeSet<OWLConstant>();
                map.put(predicate, objects);
            }
            objects.add(con);
        }
    }

    public void setXMLBase(String base) {
        this.xmlBase = URI.create(base);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakeSet<O>
    extends ArrayList<O>
    implements Set<O> {
        public FakeSet() {
        }

        public FakeSet(Collection<? extends O> c) {
            super(c);
        }
    }
}

