/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.HashSet;
import java.util.logging.Logger;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TPEquivalentPropertyHandler
extends TriplePredicateHandler {
    private static final Logger logger = Logger.getLogger(TPEquivalentPropertyHandler.class.getName());

    public TPEquivalentPropertyHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getURI());
    }

    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        return this.getConsumer().isObjectPropertyOnly(subject) && this.getConsumer().isObjectPropertyOnly(object) || this.getConsumer().isDataPropertyOnly(subject) && this.getConsumer().isDataPropertyOnly(object);
    }

    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        if (this.getConsumer().isObjectPropertyOnly(subject) || this.getConsumer().isObjectPropertyOnly(object)) {
            this.translateEquivalentObjectProperties(subject, predicate, object);
        } else if (this.getConsumer().isDataPropertyOnly(subject) || this.getConsumer().isDataPropertyOnly(object)) {
            HashSet<OWLDataPropertyExpression> props = new HashSet<OWLDataPropertyExpression>();
            props.add(this.translateDataProperty(subject));
            props.add(this.translateDataProperty(object));
            this.addAxiom(this.getDataFactory().getOWLEquivalentDataPropertiesAxiom(props));
            this.consumeTriple(subject, predicate, object);
        } else {
            this.translateEquivalentObjectProperties(subject, predicate, object);
            logger.fine("Assuming equivalent object properties because property types are ambiguous: " + subject + " <-> " + object);
        }
    }

    private void translateEquivalentObjectProperties(URI subject, URI predicate, URI object) throws OWLException {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        props.add(this.translateObjectProperty(subject));
        props.add(this.translateObjectProperty(object));
        this.addAxiom(this.getDataFactory().getOWLEquivalentObjectPropertiesAxiom(props));
        this.consumeTriple(subject, predicate, object);
    }
}

