/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.Set;
import org.coode.owl.rdfxml.parser.BuiltInTypeHandler;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.OWLRDFXMLParserMalformedNodeException;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TypeAllDisjointClassesHandler
extends BuiltInTypeHandler {
    public TypeAllDisjointClassesHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_ALL_DISJOINT_CLASSES.getURI());
    }

    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        this.consumeTriple(subject, predicate, object);
        URI listNode = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_MEMBERS.getURI(), true);
        if (listNode == null) {
            throw new OWLRDFXMLParserMalformedNodeException("Malformed AllDisjointClasses -  members triple not present");
        }
        Set<OWLDescription> desc = this.getConsumer().translateToDescriptionSet(listNode);
        this.addAxiom(this.getDataFactory().getOWLDisjointClassesAxiom(desc));
    }

    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        return false;
    }
}

