/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.owlxml.renderer;

import java.io.IOException;
import java.io.Writer;
import org.coode.owlapi.owlxml.renderer.OWLXMLObjectRenderer;
import org.coode.owlapi.owlxml.renderer.OWLXMLWriter;
import org.coode.xml.OWLOntologyNamespaceManager;
import org.semanticweb.owl.io.AbstractOWLRenderer;
import org.semanticweb.owl.io.OWLRendererException;
import org.semanticweb.owl.io.OWLRendererIOException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.vocab.Namespaces;

public class OWLXMLRenderer
extends AbstractOWLRenderer {
    public OWLXMLRenderer(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
    }

    public void render(OWLOntology ontology, Writer writer) throws OWLRendererException {
        try {
            OWLOntologyNamespaceManager nsm = new OWLOntologyNamespaceManager(this.getOWLOntologyManager(), ontology);
            String defaultNS = nsm.getDefaultNamespace();
            String prefix = nsm.getPrefixForNamespace(defaultNS);
            nsm.setDefaultNamespace(Namespaces.OWL2XML.toString());
            nsm.setPrefix(prefix, defaultNS);
            OWLXMLWriter w = new OWLXMLWriter(writer, nsm, ontology);
            w.startDocument(ontology);
            OWLXMLObjectRenderer ren = new OWLXMLObjectRenderer(ontology, w);
            ontology.accept(ren);
            w.endDocument();
            writer.flush();
        }
        catch (IOException e) {
            throw new OWLRendererIOException(e);
        }
    }
}

