/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.model;

import java.net.URI;
import org.semanticweb.owl.model.OWLOntologyCreationException;

public interface OWLOntologyLoaderListener {
    public void startedLoadingOntology(LoadingStartedEvent var1);

    public void finishedLoadingOntology(LoadingFinishedEvent var1);

    public static class LoadingFinishedEvent
    extends LoadingEvent {
        private OWLOntologyCreationException ex;

        public LoadingFinishedEvent(URI ontologyURI, URI physicalURI, boolean imported, OWLOntologyCreationException ex) {
            super(ontologyURI, physicalURI, imported);
            this.ex = ex;
        }

        public boolean isSuccessful() {
            return this.ex == null;
        }

        public OWLOntologyCreationException getException() {
            return this.ex;
        }
    }

    public static class LoadingStartedEvent
    extends LoadingEvent {
        public LoadingStartedEvent(URI ontologyURI, URI physicalURI, boolean imported) {
            super(ontologyURI, physicalURI, imported);
        }
    }

    public static class LoadingEvent {
        private URI ontologyURI;
        private URI physicalURI;
        private boolean imported;

        public LoadingEvent(URI ontologyURI, URI physicalURI, boolean imported) {
            this.ontologyURI = ontologyURI;
            this.physicalURI = physicalURI;
            this.imported = imported;
        }

        public URI getOntologyURI() {
            return this.ontologyURI;
        }

        public URI getPhysicalURI() {
            return this.physicalURI;
        }

        public boolean isImported() {
            return this.imported;
        }
    }
}

