/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.preditor;

import ch.uzh.ifi.attempto.preditor.MenuEntry;
import ch.uzh.ifi.attempto.preditor.MenuItem;
import ch.uzh.ifi.attempto.preditor.text.TextElement;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MenuBlockContent {
    private ArrayList<MenuItem> items = new ArrayList();
    private String name;
    private String filter;
    private boolean doSort;
    private boolean isSorted = true;

    public MenuBlockContent(String string, boolean bl) {
        this.name = string;
        this.doSort = bl;
    }

    public void addItems(ArrayList<MenuItem> arrayList) {
        for (MenuItem menuItem : arrayList) {
            this.addItem(menuItem);
        }
    }

    public void addItem(MenuItem menuItem) {
        this.items.add(menuItem);
        this.isSorted = false;
    }

    public void addEntries(ArrayList<TextElement> arrayList) {
        for (TextElement textElement : arrayList) {
            this.addEntry(textElement);
        }
    }

    public void addEntry(TextElement textElement) {
        this.items.add(new MenuEntry(textElement));
        this.isSorted = false;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public ArrayList<MenuEntry> getEntries() {
        if (!this.isSorted && this.doSort) {
            this.sort();
        }
        ArrayList<MenuEntry> arrayList = new ArrayList<MenuEntry>();
        for (MenuItem menuItem : this.items) {
            MenuEntry menuEntry;
            if (!(menuItem instanceof MenuEntry) || !(menuEntry = (MenuEntry)menuItem).getTextElement().getText().toLowerCase().startsWith(this.filter)) continue;
            arrayList.add(menuEntry);
        }
        return arrayList;
    }

    public ArrayList<MenuItem> getItems() {
        if (!this.isSorted && this.doSort) {
            this.sort();
        }
        if (this.filter == null || this.filter.length() == 0) {
            return this.items;
        }
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        for (MenuItem menuItem : this.items) {
            if (menuItem instanceof MenuEntry) {
                if (!((MenuEntry)menuItem).getTextElement().getText().toLowerCase().startsWith(this.filter)) continue;
                arrayList.add(menuItem);
                continue;
            }
            arrayList.add(menuItem);
        }
        return arrayList;
    }

    public TextElement getEntry(String string) {
        for (MenuItem menuItem : this.getItems()) {
            TextElement textElement;
            if (!(menuItem instanceof MenuEntry) || !(textElement = ((MenuEntry)menuItem).getTextElement()).getText().toLowerCase().equals(string.toLowerCase())) continue;
            return textElement;
        }
        return null;
    }

    public String getStartString() {
        String string = null;
        for (MenuEntry menuEntry : this.getEntries()) {
            String string2 = menuEntry.getTextElement().getText().toLowerCase();
            if (string == null) {
                string = string2;
                continue;
            }
            for (int i = string.length(); i >= 0 && !string2.startsWith(string.substring(0, i)); --i) {
                string = string.substring(0, i - 1);
            }
        }
        return string;
    }

    public void setFilter(String string) {
        this.filter = string == null ? null : string.toLowerCase();
    }

    private void sort() {
        Collections.sort(this.items);
    }
}

