/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.preditor;

import ch.uzh.ifi.attempto.chartparser.ChartParser;
import ch.uzh.ifi.attempto.chartparser.Terminal;
import ch.uzh.ifi.attempto.preditor.MenuBlockContent;
import ch.uzh.ifi.attempto.preditor.MenuItem;
import ch.uzh.ifi.attempto.preditor.text.RefTextElement;
import ch.uzh.ifi.attempto.preditor.text.RefableTextElement;
import ch.uzh.ifi.attempto.preditor.text.TextContainer;
import ch.uzh.ifi.attempto.preditor.text.TextElement;
import ch.uzh.ifi.attempto.preditor.text.VarTextElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MenuCreator {
    private HashMap<String, MenuBlockContent> contentsMap = new HashMap();
    private List<MenuBlockContent> contentsList = new ArrayList<MenuBlockContent>();
    private ChartParser parser;
    private TextContainer textContainer;

    public abstract void processCategory(Terminal var1);

    public abstract void initMenuCreation();

    public void prepareMenuBlock(String string) {
        this.prepareMenuBlock(string, false);
    }

    public void prepareMenuBlock(String string, boolean bl) {
        if (this.contentsMap.containsKey(string)) {
            return;
        }
        MenuBlockContent menuBlockContent = new MenuBlockContent(string, bl);
        this.contentsMap.put(string, menuBlockContent);
        this.contentsList.add(menuBlockContent);
    }

    public void addMenuItem(String string, MenuItem menuItem) {
        if (!this.contentsMap.containsKey(string)) {
            this.prepareMenuBlock(string);
        }
        this.contentsMap.get(string).addItem(menuItem);
    }

    public void addMenuEntry(String string, TextElement textElement) {
        if (!this.contentsMap.containsKey(string)) {
            this.prepareMenuBlock(string);
        }
        this.contentsMap.get(string).addEntry(textElement);
    }

    public void addReferenceEntries(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TextElement textElement : this.getAccessibleTextElements(string2)) {
            if (!(textElement instanceof RefableTextElement)) continue;
            RefableTextElement refableTextElement = (RefableTextElement)textElement;
            boolean bl = false;
            String string3 = refableTextElement.getReferenceText();
            for (String string4 : arrayList) {
                if (!string4.equals(string3) && !string4.startsWith(string3 + " ")) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(string3);
            this.addMenuEntry(string, new RefTextElement(refableTextElement, string2));
        }
    }

    public void addVariableEntries(String string, int n, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("X");
        arrayList.add("Y");
        arrayList.add("Z");
        for (int i = 1; i <= n; ++i) {
            arrayList.add("X" + i);
            arrayList.add("Y" + i);
            arrayList.add("Z" + i);
        }
        for (TextElement object : this.textContainer.getTextElements()) {
            if (!(object instanceof VarTextElement)) continue;
            arrayList.remove(((VarTextElement)object).getText());
        }
        for (String string3 : arrayList) {
            this.addMenuEntry(string, new VarTextElement(string3, string2));
        }
    }

    public List<TextElement> getAccessibleTextElements(String string) {
        ArrayList<TextElement> arrayList = new ArrayList<TextElement>();
        boolean[] blArray = this.parser.getAccessiblePositions(string);
        for (int i = blArray.length - 1; i >= 0; --i) {
            if (!blArray[i]) continue;
            TextElement textElement = this.textContainer.getTextElements().get(i);
            arrayList.add(textElement);
        }
        return arrayList;
    }

    List<MenuBlockContent> createMenu(ChartParser chartParser, TextContainer textContainer) {
        this.parser = chartParser;
        this.textContainer = textContainer;
        this.contentsMap.clear();
        this.contentsList.clear();
        this.initMenuCreation();
        for (Terminal terminal : chartParser.nextTokens()) {
            this.processCategory(terminal);
        }
        return new ArrayList<MenuBlockContent>(this.contentsList);
    }
}

