/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.preditor.text;

import ch.uzh.ifi.attempto.chartparser.Terminal;
import ch.uzh.ifi.attempto.preditor.text.TextElement;

public class BasicTextElement
implements TextElement {
    private final String originalText;
    private String text;
    private String category;
    private boolean capitalize;

    public BasicTextElement(String string, String string2, boolean bl) {
        this.text = string;
        this.originalText = string;
        this.category = string2;
        this.capitalize = bl;
    }

    public BasicTextElement(String string, String string2) {
        this(string, string2, true);
    }

    public BasicTextElement(int n, String string) {
        this(n + "", string, true);
    }

    public BasicTextElement(String string, boolean bl) {
        this(string, string, bl);
    }

    public BasicTextElement(String string) {
        this(string, string, true);
    }

    public BasicTextElement(int n) {
        this(n + "", n + "", true);
    }

    public BasicTextElement(Terminal terminal, boolean bl) {
        this(terminal.getName(), terminal.getName(), bl);
    }

    public BasicTextElement(Terminal terminal) {
        this(terminal.getName(), terminal.getName(), true);
    }

    public String getCategory() {
        return this.category;
    }

    public String getText() {
        return this.text;
    }

    public void checkNeighborTextElements(TextElement textElement, TextElement textElement2) {
        String string;
        if ((textElement == null || textElement.getText().matches("(\\.|\\?|\\!)")) && this.capitalize) {
            string = this.originalText.substring(0, 1);
            this.text = string.toUpperCase() + this.originalText.substring(1);
        } else {
            this.text = this.originalText;
        }
        if (textElement2 != null && this.text.matches("(A|a)n?")) {
            string = textElement2.getText().toLowerCase();
            boolean bl = false;
            if (string.matches("[aeiou].*")) {
                bl = true;
            }
            if (string.matches("[fhlmnrsx]")) {
                bl = true;
            }
            if (string.matches("[fhlmnrsx]-.*")) {
                bl = true;
            }
            if (string.equals("u")) {
                bl = false;
            }
            if (string.matches("u-.*")) {
                bl = false;
            }
            if (string.matches("u[rtn]i.*")) {
                bl = false;
            }
            if (string.matches("use.*")) {
                bl = false;
            }
            if (string.matches("uk.*")) {
                bl = false;
            }
            this.text = bl ? this.text.substring(0, 1) + "n" : this.text.substring(0, 1);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BasicTextElement) {
            BasicTextElement basicTextElement = (BasicTextElement)object;
            return this.text.equals(basicTextElement.text) && this.category.equals(basicTextElement.category);
        }
        return false;
    }
}

