/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.preditor.text;

import ch.uzh.ifi.attempto.preditor.text.TextElement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextContainer {
    private ArrayList<TextElement> elements = new ArrayList();

    public ArrayList<TextElement> getTextElements() {
        return new ArrayList<TextElement>(this.elements);
    }

    public void setTextElements(List<TextElement> list) {
        this.elements = new ArrayList<TextElement>(list);
        this.updateConnections();
    }

    public void addElement(TextElement textElement) {
        this.elements.add(textElement);
        this.updateConnections();
    }

    public void removeAllElements() {
        this.elements.clear();
    }

    public void removeLastElement() {
        if (this.elements.size() > 0) {
            this.elements.remove(this.elements.size() - 1);
            this.updateConnections();
        }
    }

    public String getText() {
        String string = "";
        for (TextElement textElement : this.elements) {
            if (textElement.getText().matches("[.?!]")) {
                string = string + textElement.getText();
                continue;
            }
            string = string + " " + textElement.getText();
        }
        if (string.startsWith(" ")) {
            string = string.substring(1);
        }
        return string;
    }

    private void updateConnections() {
        for (int i = 1; i < this.elements.size() - 1; ++i) {
            this.elements.get(i).checkNeighborTextElements(this.elements.get(i - 1), this.elements.get(i + 1));
        }
        if (this.elements.size() > 1) {
            this.elements.get(0).checkNeighborTextElements(null, this.elements.get(1));
            this.elements.get(this.elements.size() - 1).checkNeighborTextElements(this.elements.get(this.elements.size() - 2), null);
        }
        if (this.elements.size() == 1) {
            this.elements.get(0).checkNeighborTextElements(null, null);
        }
    }
}

