/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.extras.webcontainer;

import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.app.util.DomUtil;
import nextapp.echo2.extras.app.CalendarSelect;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.image.ImageTools;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CalendarSelectPeer
implements ComponentSynchronizePeer,
ImageRenderSupport,
PropertyUpdateProcessor {
    private static final String IMAGE_ID_BACKGROUND = "background";
    private static final String IMAGE_ID_SELECTED_DATE_BACKGROUND = "selectedDateBackground";
    private static final String IMAGE_ID_ARROW_LEFT = "arrowLeft";
    private static final String IMAGE_ID_ARROW_RIGHT = "arrowRight";
    private static final String IMAGE_PREFIX = "/nextapp/echo2/extras/webcontainer/resource/image/";
    private static final ImageReference DEFAULT_ICON_ARROW_LEFT = new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/ArrowLeft.gif");
    private static final ImageReference DEFAULT_ICON_ARROW_RIGHT = new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/ArrowRight.gif");
    private static final String MESSAGE_RESOURCE = "META-INF/nextapp/echo2extras/Calendar";
    public static final Service CALENDAR_SELECT_SERVICE = JavaScriptService.forResource((String)"Echo2Extras.CalendarSelect", (String)"/nextapp/echo2/extras/webcontainer/resource/js/CalendarSelect.js");
    private PartialUpdateManager partialUpdateManager;
    private PartialUpdateParticipant setDateUpdateParticipant = new PartialUpdateParticipant(){

        public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
            CalendarSelectPeer.this.renderSetDateDirective(rc, (CalendarSelect)update.getParent());
        }

        public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
            return true;
        }
    };

    public CalendarSelectPeer() {
        this.partialUpdateManager = new PartialUpdateManager();
        this.partialUpdateManager.add("date", this.setDateUpdateParticipant);
    }

    public String getContainerId(Component component) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_ARROW_RIGHT.equals(imageId)) {
            return DEFAULT_ICON_ARROW_RIGHT;
        }
        if (IMAGE_ID_ARROW_LEFT.equals(imageId)) {
            return DEFAULT_ICON_ARROW_LEFT;
        }
        if (IMAGE_ID_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("backgroundImage");
            return backgroundImage == null ? null : backgroundImage.getImage();
        }
        if (IMAGE_ID_SELECTED_DATE_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("selectedDateBackgroundImage");
            return backgroundImage == null ? null : backgroundImage.getImage();
        }
        return null;
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        rc.getServerMessage().addLibrary(CALENDAR_SELECT_SERVICE.getId());
        this.renderInitDirective(rc, targetId, (CalendarSelect)component);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        rc.getServerMessage().addLibrary(CALENDAR_SELECT_SERVICE.getId());
        this.renderDisposeDirective(rc, (CalendarSelect)component);
    }

    private void renderDisposeDirective(RenderContext rc, CalendarSelect calendarSelect) {
        String elementId = ContainerInstance.getElementId((Component)calendarSelect);
        ServerMessage serverMessage = rc.getServerMessage();
        Element initElement = serverMessage.appendPartDirective("preremove", "ExtrasCalendarSelect.MessageProcessor", "dispose");
        initElement.setAttribute("eid", elementId);
    }

    private void renderInitDirective(RenderContext rc, String containerId, CalendarSelect calendarSelect) {
        Color adjacentMonthDateForeground;
        FillImage selectedDateBackgroundImage;
        Color selectedDateForeground;
        Color selectedDateBackground;
        FillImage backgroundImage;
        Font font;
        Color foreground;
        Color background;
        String elementId = ContainerInstance.getElementId((Component)calendarSelect);
        ServerMessage serverMessage = rc.getServerMessage();
        Document document = serverMessage.getDocument();
        Element initElement = serverMessage.appendPartDirective("update", "ExtrasCalendarSelect.MessageProcessor", "init");
        initElement.setAttribute("eid", elementId);
        initElement.setAttribute("container-eid", containerId);
        GregorianCalendar calendar = new GregorianCalendar();
        if (calendarSelect.getDate() != null) {
            calendar.setTime(calendarSelect.getDate());
        }
        initElement.setAttribute("year", Integer.toString(calendar.get(1)));
        initElement.setAttribute("month", Integer.toString(calendar.get(2)));
        initElement.setAttribute("date", Integer.toString(calendar.get(5)));
        if (!calendarSelect.isRenderEnabled()) {
            initElement.setAttribute("enabled", "false");
        }
        if ((background = (Color)calendarSelect.getRenderProperty(IMAGE_ID_BACKGROUND)) != null) {
            initElement.setAttribute(IMAGE_ID_BACKGROUND, ColorRender.renderCssAttributeValue((Color)background));
        }
        if ((foreground = (Color)calendarSelect.getRenderProperty("foreground")) != null) {
            initElement.setAttribute("foreground", ColorRender.renderCssAttributeValue((Color)foreground));
        }
        if ((font = (Font)calendarSelect.getRenderProperty("font")) != null) {
            if (font.getTypeface() != null) {
                initElement.setAttribute("font-family", FontRender.renderFontFamilyCssAttributeValue((Font.Typeface)font.getTypeface()));
            }
            if (font.getSize() != null) {
                initElement.setAttribute("font-size", ExtentRender.renderCssAttributeValue((Extent)font.getSize()));
            }
            initElement.setAttribute("font-style", FontRender.renderFontStyleCssAttributeValue((Font)font));
            initElement.setAttribute("font-weight", FontRender.renderFontWeightCssAttributeValue((Font)font));
            initElement.setAttribute("text-decoration", FontRender.renderTextDecorationCssAttributeValue((Font)font));
        }
        if ((backgroundImage = (FillImage)calendarSelect.getRenderProperty("backgroundImage")) != null) {
            CssStyle backgroundImageStyle = new CssStyle();
            FillImageRender.renderToStyle((CssStyle)backgroundImageStyle, (RenderContext)rc, (ImageRenderSupport)this, (Component)calendarSelect, (String)IMAGE_ID_BACKGROUND, (FillImage)backgroundImage, (int)0);
            initElement.setAttribute("background-image", backgroundImageStyle.renderInline());
        }
        if ((selectedDateBackground = (Color)calendarSelect.getRenderProperty(IMAGE_ID_SELECTED_DATE_BACKGROUND)) != null) {
            initElement.setAttribute("selected-date-background", ColorRender.renderCssAttributeValue((Color)selectedDateBackground));
        }
        if ((selectedDateForeground = (Color)calendarSelect.getRenderProperty("selectedDateForeground")) != null) {
            initElement.setAttribute("selected-date-foreground", ColorRender.renderCssAttributeValue((Color)selectedDateForeground));
        }
        if ((selectedDateBackgroundImage = (FillImage)calendarSelect.getRenderProperty("selectedDateBackgroundImage")) != null) {
            CssStyle backgroundImageStyle = new CssStyle();
            FillImageRender.renderToStyle((CssStyle)backgroundImageStyle, (RenderContext)rc, (ImageRenderSupport)this, (Component)calendarSelect, (String)IMAGE_ID_SELECTED_DATE_BACKGROUND, (FillImage)selectedDateBackgroundImage, (int)0);
            initElement.setAttribute("selected-date-background-image", backgroundImageStyle.renderInline());
        }
        if ((adjacentMonthDateForeground = (Color)calendarSelect.getRenderProperty("adjacentMonthDateForeground")) != null) {
            initElement.setAttribute("adjacent-month-date-foreground", ColorRender.renderCssAttributeValue((Color)adjacentMonthDateForeground));
        }
        initElement.setAttribute("arrow-left-image", ImageTools.getUri((RenderContext)rc, (ImageRenderSupport)this, (Component)calendarSelect, (String)IMAGE_ID_ARROW_LEFT));
        initElement.setAttribute("arrow-right-image", ImageTools.getUri((RenderContext)rc, (ImageRenderSupport)this, (Component)calendarSelect, (String)IMAGE_ID_ARROW_RIGHT));
        Border border = (Border)calendarSelect.getRenderProperty("border");
        if (border != null) {
            initElement.setAttribute("border", BorderRender.renderCssAttributeValue((Border)border));
        }
        Locale locale = calendarSelect.getRenderLocale();
        if (!Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(MESSAGE_RESOURCE, locale);
                if (bundle != null) {
                    int i;
                    if (bundle.getString("DayOfWeek0") != null) {
                        Element dayNamesElement = document.createElement("day-names");
                        for (i = 0; i < 7; ++i) {
                            String dayName = bundle.getString("DayOfWeek" + i);
                            if (dayName == null) {
                                throw new IllegalStateException("No day name for day #" + i);
                            }
                            Element dayNameElement = document.createElement("day-name");
                            dayNameElement.setAttribute("value", dayName);
                            dayNamesElement.appendChild(dayNameElement);
                        }
                        initElement.appendChild(dayNamesElement);
                    }
                    if (bundle.getString("Month0") != null) {
                        Element monthNamesElement = document.createElement("month-names");
                        for (i = 0; i < 12; ++i) {
                            String monthName = bundle.getString("Month" + i);
                            if (monthName == null) {
                                throw new IllegalStateException("No month name for month #" + i);
                            }
                            Element monthNameElement = document.createElement("month-name");
                            monthNameElement.setAttribute("value", monthName);
                            monthNamesElement.appendChild(monthNameElement);
                        }
                        initElement.appendChild(monthNamesElement);
                    }
                }
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element element) {
        int date;
        Element selectionElement = DomUtil.getChildElementByTagName((Element)element, (String)"calendar-selection");
        int month = Integer.parseInt(selectionElement.getAttribute("month"));
        int year = Integer.parseInt(selectionElement.getAttribute("year"));
        int n = date = selectionElement.hasAttribute("date") ? Integer.parseInt(selectionElement.getAttribute("date")) : -1;
        if (date == -1) {
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "date", null);
        } else {
            GregorianCalendar calendar = new GregorianCalendar(year, month, date);
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "date", (Object)calendar.getTime());
        }
    }

    private void renderSetDateDirective(RenderContext rc, CalendarSelect calendarSelect) {
        String elementId = ContainerInstance.getElementId((Component)calendarSelect);
        ServerMessage serverMessage = rc.getServerMessage();
        Element setDateElement = serverMessage.appendPartDirective("update", "ExtrasCalendarSelect.MessageProcessor", "set-date");
        setDateElement.setAttribute("eid", elementId);
        GregorianCalendar calendar = new GregorianCalendar();
        if (calendarSelect.getDate() != null) {
            calendar.setTime(calendarSelect.getDate());
            setDateElement.setAttribute("year", Integer.toString(calendar.get(1)));
            setDateElement.setAttribute("month", Integer.toString(calendar.get(2)));
            setDateElement.setAttribute("date", Integer.toString(calendar.get(5)));
        }
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        if (this.partialUpdateManager.canProcess(rc, update)) {
            this.partialUpdateManager.process(rc, update);
        } else {
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        }
        return true;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(CALENDAR_SELECT_SERVICE);
    }
}

