/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.filetransfer;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.RenderIdSupport;
import nextapp.echo2.app.filetransfer.UploadSelect;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.filetransfer.MultipartUploadFactory;
import nextapp.echo2.webcontainer.filetransfer.MultipartUploadSPI;
import nextapp.echo2.webcontainer.filetransfer.UploadEvent;
import nextapp.echo2.webcontainer.filetransfer.UploadFormService;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UploadSelectPeer
implements DomUpdateSupport,
ActionProcessor,
PropertyUpdateProcessor,
ComponentSynchronizePeer {
    private static final Extent DEFAULT_HEIGHT = new Extent(70, 1);
    private static final Extent DEFAULT_WIDTH = new Extent(280, 1);
    private static final Map ID_TO_ACTIVE_UPLOAD_MAP = Collections.synchronizedMap(new HashMap());

    static final void activateUploadSelect(UploadSelect uploadSelect, UploadEvent uploadEvent) {
        ID_TO_ACTIVE_UPLOAD_MAP.put(uploadSelect, uploadEvent);
    }

    static final void deactivateUploadSelect(UploadSelect uploadSelect) {
        ID_TO_ACTIVE_UPLOAD_MAP.remove(uploadSelect);
    }

    public String getContainerId(Component child) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    public void processAction(ContainerInstance ci, Component component, Element propertyElement) {
        UploadSelect uploadSelect = (UploadSelect)component;
        this.processFileUpload(uploadSelect);
    }

    protected void processFileUpload(UploadSelect uploadSelect) {
        UploadEvent event = (UploadEvent)ID_TO_ACTIVE_UPLOAD_MAP.get(uploadSelect);
        if (event != null) {
            try {
                FileInputStream in = new FileInputStream(event.getFile());
                uploadSelect.fileUpload((InputStream)in, event.getFileSize(), event.getContentType(), event.getFileName());
                event.getFile().delete();
                UploadSelectPeer.deactivateUploadSelect(uploadSelect);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAdd((ServerMessage)rc.getServerMessage(), (String)targetId, (DocumentFragment)htmlFragment);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        UploadSelect uploadSelect = (UploadSelect)component;
        UploadSelectPeer.deactivateUploadSelect(uploadSelect);
        DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)component));
    }

    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        UploadSelect uploadSelect = (UploadSelect)component;
        Element parentDiv = parentNode.getOwnerDocument().createElement("div");
        parentDiv.setAttribute("id", ContainerInstance.getElementId((Component)uploadSelect));
        Element iframe = parentNode.getOwnerDocument().createElement("iframe");
        iframe.setAttribute("scrolling", "no");
        CssStyle style = new CssStyle();
        style.setAttribute("border", "none");
        ExtentRender.renderToStyle((CssStyle)style, (String)"height", (Extent)((Extent)uploadSelect.getRenderProperty("height", (Object)DEFAULT_HEIGHT)));
        ExtentRender.renderToStyle((CssStyle)style, (String)"width", (Extent)((Extent)uploadSelect.getRenderProperty("width", (Object)DEFAULT_WIDTH)));
        String id = uploadSelect.getRenderId();
        rc.getContainerInstance().getIdTable().register((RenderIdSupport)uploadSelect);
        String uri = UploadFormService.INSTANCE.createUri(rc.getContainerInstance(), id);
        iframe.setAttribute("style", style.renderInline());
        iframe.setAttribute("src", uri);
        parentDiv.appendChild(iframe);
        parentNode.appendChild(parentDiv);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)update.getParent()));
        this.renderAdd(rc, update, targetId, update.getParent());
        return false;
    }

    static {
        MultipartUploadSPI requestWrapper = MultipartUploadFactory.getMultipartUploadSPI();
        WebRenderServlet.setMultipartRequestWrapper((WebRenderServlet.MultipartRequestWrapper)requestWrapper);
    }
}

