/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.chartparser;

import ch.uzh.ifi.attempto.chartparser.Category;
import ch.uzh.ifi.attempto.chartparser.Edge;
import ch.uzh.ifi.attempto.chartparser.Nonterminal;
import ch.uzh.ifi.attempto.chartparser.StringEntity;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule {
    private final Nonterminal head;
    private final Category[] body;
    private final boolean accessible;

    public Rule(Nonterminal nonterminal, boolean bl, Category ... categoryArray) {
        this.head = nonterminal;
        this.body = categoryArray;
        this.accessible = bl;
    }

    public Rule(Nonterminal nonterminal, Category ... categoryArray) {
        this(nonterminal, true, categoryArray);
    }

    public Rule(List<Category> list, boolean bl) {
        this.accessible = bl;
        this.head = (Nonterminal)list.get(0);
        list.remove(0);
        this.body = list.toArray(new Category[0]);
    }

    public Rule(List<Category> list) {
        this(list, true);
    }

    public Nonterminal getHead() {
        return this.head;
    }

    public Category[] getBody() {
        return this.body;
    }

    public boolean hasEmptyBody() {
        return this.body.length == 0;
    }

    public Category getFirst() {
        return this.body[0];
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    Edge createEdge(int n) {
        return new Edge(n, n, this.getHead(), this.getBody(), this.accessible);
    }

    public Rule deepCopy() {
        return this.deepCopy(new HashMap<Integer, StringEntity>());
    }

    public Rule deepCopy(HashMap<Integer, StringEntity> hashMap) {
        Nonterminal nonterminal = (Nonterminal)this.head.deepCopy(hashMap);
        Category[] categoryArray = new Category[this.body.length];
        for (int i = 0; i < this.body.length; ++i) {
            categoryArray[i] = this.body[i].deepCopy(hashMap);
        }
        return new Rule(nonterminal, this.accessible, categoryArray);
    }

    public String toString() {
        String string = this.head + " ";
        string = this.accessible ? string + "=>" : string + "~>";
        for (Category category : this.body) {
            string = string + " " + category;
        }
        return string;
    }
}

