/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.utils.ATermUtils;

abstract class Branch {
    protected static Log log = LogFactory.getLog(ABox.class);
    ABox abox;
    CompletionStrategy strategy;
    int branch;
    int tryCount;
    int tryNext;
    ATermAppl nodeName;
    Node node;
    Individual ind;
    DependencySet termDepends;
    private DependencySet prevDS;
    int anonCount;
    int nodeCount;
    Map info;

    Branch(ABox abox, CompletionStrategy strategy, Node x, DependencySet ds, int n) {
        this.abox = abox;
        this.strategy = strategy;
        this.node = x;
        if (this.node instanceof Individual) {
            this.ind = (Individual)this.node;
        }
        this.nodeName = this.node.getName();
        this.termDepends = ds;
        this.tryCount = n;
        this.prevDS = DependencySet.EMPTY;
        this.tryNext = 0;
        this.branch = abox.getBranch();
        this.anonCount = abox.anonCount;
        this.nodeCount = abox.nodes.size();
        ATermUtils.assertTrue(this.tryCount > 0);
    }

    public void setLastClash(DependencySet ds) {
        if (this.tryNext >= 0) {
            this.prevDS = this.prevDS.union(ds, this.abox.doExplanation());
            if (PelletOptions.USE_INCREMENTAL_DELETION) {
                this.abox.getKB().getDependencyIndex().addCloseBranchDependency(this, ds);
            }
        }
    }

    public DependencySet getCombinedClash() {
        return this.prevDS;
    }

    public void setStrategy(CompletionStrategy strategy) {
        this.strategy = strategy;
    }

    public boolean tryNext() {
        if (this.abox.isClosed()) {
            return false;
        }
        this.tryBranch();
        if (this.abox.isClosed() && !PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getClash().depends.remove(this.branch);
        }
        return !this.abox.isClosed();
    }

    protected abstract Branch copyTo(ABox var1);

    protected abstract void tryBranch();

    void put(String key, Object obj) {
        if (this.info == null) {
            this.info = new HashMap();
        }
        this.info.put(key, obj);
    }

    Object get(String key) {
        return this.info.get(key);
    }

    public String toString() {
        return "Branch on node " + this.node + "  Branch number: " + this.branch + " " + this.tryNext + "(" + this.tryCount + ")";
    }

    protected abstract void shiftTryNext(int var1);
}

