/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.datatypes.RDFSLiteral;
import org.mindswap.pellet.datatypes.StringValue;
import org.mindswap.pellet.datatypes.UnionDatatype;
import org.mindswap.pellet.utils.ATermUtils;

public class Literal
extends Node {
    private ATermAppl atermValue;
    private Object value;
    private Datatype datatype;
    private boolean hasValue;

    public Literal(ATermAppl name, ATermAppl term, ABox abox) {
        this(name, term, abox, DependencySet.INDEPENDENT);
    }

    public Literal(ATermAppl name, ATermAppl term, ABox abox, DependencySet ds) {
        super(name, abox);
        if (term != null) {
            boolean bl = this.hasValue = !((Object)term.getArgument(2)).equals(ATermUtils.NO_DATATYPE);
            if (this.hasValue) {
                this.value = abox.dtReasoner.getValue(term);
                if (this.value == null) {
                    this.depends.put(name, ds);
                }
            }
            this.atermValue = ATermUtils.makeValue(term);
        } else {
            this.hasValue = false;
        }
    }

    public Literal(Literal literal, ABox abox) {
        super(literal, abox);
        this.atermValue = literal.atermValue;
        this.value = literal.value;
        this.hasValue = literal.hasValue;
    }

    public Node copyTo(ABox abox) {
        return new Literal(this, abox);
    }

    public final boolean isLeaf() {
        return true;
    }

    public int getNominalLevel() {
        return this.isNominal() ? 0 : Integer.MAX_VALUE;
    }

    public boolean isNominal() {
        return this.value != null;
    }

    public boolean isBlockable() {
        return this.value == null;
    }

    public boolean isLiteral() {
        return true;
    }

    public boolean isIndividual() {
        return false;
    }

    public boolean isDifferent(Node node) {
        if (super.isDifferent(node)) {
            return true;
        }
        Literal literal = (Literal)node;
        if (this.hasValue && literal.hasValue) {
            return this.value.getClass().equals(literal.value.getClass()) && !this.value.equals(literal.value);
        }
        return false;
    }

    public boolean hasType(ATerm type) {
        if (super.hasType(type)) {
            return true;
        }
        return this.hasValue && this.atermValue.equals(type);
    }

    public DependencySet getDifferenceDependency(Node node) {
        DependencySet ds = null;
        if (this.isDifferent(node) && (ds = (DependencySet)this.differents.get(node)) == null) {
            ds = DependencySet.INDEPENDENT;
        }
        return ds;
    }

    public void addType(ATermAppl c, DependencySet d) {
        if (this.hasType(c)) {
            return;
        }
        super.addType(c, d);
        this.checkClash();
    }

    public void addAllTypes(Map types, DependencySet ds) {
        for (ATermAppl c : types.keySet()) {
            if (this.hasType(c)) continue;
            DependencySet depends = (DependencySet)types.get(c);
            super.addType(c, depends.union(ds, this.abox.doExplanation()));
        }
        this.checkClash();
    }

    public boolean hasSuccessor(Node x) {
        return false;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public final Literal getSame() {
        return (Literal)super.getSame();
    }

    public ATermAppl getTerm() {
        return this.hasValue ? (ATermAppl)this.atermValue.getArgument(0) : null;
    }

    public String getDatatypeURI() {
        if (this.hasValue) {
            ATermAppl literal = this.getTerm();
            String datatypeURI = ((ATermAppl)literal.getArgument(2)).getName();
            if (datatypeURI.equals("")) {
                return null;
            }
            return datatypeURI;
        }
        if (this.datatype == null) {
            return null;
        }
        if (this.datatype instanceof UnionDatatype) {
            return null;
        }
        if (this.datatype.getURI() != null) {
            return this.datatype.getURI();
        }
        AtomicDatatype primitive = ((AtomicDatatype)this.datatype).getPrimitiveType();
        return primitive.getURI();
    }

    public String getLang() {
        if (this.value != null && this.value instanceof StringValue) {
            return ((StringValue)this.value).getLang();
        }
        return "";
    }

    public String getLexicalValue() {
        if (this.hasValue) {
            return this.value.toString();
        }
        return null;
    }

    private void checkClash() {
        if (this.hasValue && this.value == null) {
            this.abox.setClash(Clash.invalidLiteral(this, this.getDepends(this.name), this.getTerm()));
            return;
        }
        if (this.hasType(ATermUtils.BOTTOM_LIT)) {
            this.abox.setClash(Clash.emptyDatatype(this, this.getDepends(ATermUtils.BOTTOM_LIT)));
            if (this.abox.doExplanation()) {
                System.out.println("1) Literal clash dependency = " + this.abox.getClash());
            }
            return;
        }
        Set<ATermAppl> types = this.getTypes();
        if (types.size() == 1) {
            this.datatype = RDFSLiteral.instance;
            return;
        }
        DatatypeReasoner dtReasoner = this.abox.getDatatypeReasoner();
        ArrayList<ATermAppl> primitives = new ArrayList<ATermAppl>();
        for (ATermAppl type : types) {
            if (type.equals(RDFSLiteral.instance.getName()) || ATermUtils.isAnd(type)) continue;
            primitives.add(type);
        }
        if (primitives.isEmpty()) {
            this.datatype = RDFSLiteral.instance;
            return;
        }
        ATermAppl[] dt = primitives.toArray(new ATermAppl[primitives.size() - 1]);
        this.datatype = dtReasoner.intersection(dt);
        AtomicDatatype litDatatype = (AtomicDatatype)dtReasoner.getDatatype(this.getDatatypeURI());
        if (this.datatype.isEmpty()) {
            DependencySet ds = DependencySet.EMPTY;
            for (int i = 0; i < dt.length; ++i) {
                ds = ds.union(this.getDepends(dt[i]), this.abox.doExplanation());
            }
            this.abox.setClash(Clash.emptyDatatype(this, ds, dt));
        } else if (this.hasValue && !this.datatype.contains(this.value, litDatatype)) {
            DependencySet ds = DependencySet.EMPTY;
            for (int i = 0; i < dt.length; ++i) {
                ds = ds.union(this.getDepends(dt[i]), this.abox.doExplanation());
            }
            if (PelletOptions.USE_TRACING) {
                EdgeList edges = this.getInEdges();
                for (Edge inEdge : edges) {
                    ds = ds.union(inEdge.getDepends(), this.abox.doExplanation());
                }
            }
            if (this.value instanceof StringValue) {
                this.abox.setClash(Clash.missingDatatype(this, ds, this.getTerm(), dt[0]));
            } else {
                this.abox.setClash(Clash.valueDatatype(this, ds, this.getTerm(), dt[0]));
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String toTypedString() {
        if (this.value == null) {
            return this.name.toString();
        }
        String str = "\"" + this.value + "\"";
        String lang = this.getLang();
        if (!lang.equals("")) {
            return str + "@" + lang;
        }
        String datatypeURI = this.getDatatypeURI();
        if (datatypeURI != null) {
            return str + "^^" + datatypeURI;
        }
        return str;
    }

    public final void prune(DependencySet ds) {
        this.pruned = ds;
    }

    public void unprune(int branch) {
        super.unprune(branch);
        this.checkClash();
    }

    public String toString() {
        return this.toTypedString();
    }

    public String debugString() {
        return this.name + " = " + this.getTypes().toString();
    }
}

