/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import java.net.URI;
import java.net.URISyntaxException;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseAtomicDatatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDAnyURI
extends BaseAtomicDatatype
implements AtomicDatatype {
    public static XSDAnyURI instance = new XSDAnyURI();

    XSDAnyURI() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#anyURI"));
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    public Object getValue(String value, String datatypeURI) {
        try {
            return new URI(value.trim());
        }
        catch (URISyntaxException e) {
            if (datatypeURI.equals(XSDAnyURI.instance.name.getName())) {
                DatatypeReasoner.log.warn((Object)("Invalid xsd:anyURI value: '" + value + "'"));
                DatatypeReasoner.log.warn((Object)e);
            }
            return null;
        }
    }

    public boolean contains(Object value) {
        return value instanceof URI && super.contains(value);
    }

    public boolean isFinite() {
        return true;
    }

    public ATermAppl getValue(int n) {
        return ATermUtils.makeTypedLiteral("http://test" + n, this.name.getName());
    }
}

