/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseAtomicDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.relaxng.datatype.DatatypeException;

public class XSDBoolean
extends BaseAtomicDatatype
implements AtomicDatatype {
    public static final XSDBoolean instance = new XSDBoolean();
    private static XSDatatype dt = null;
    static final int NO_VALUES = 0;
    static final int ONLY_TRUE = 1;
    static final int ONLY_FALSE = 2;
    static final int BOTH_VALUES = 3;
    protected int status = 3;

    XSDBoolean() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#boolean"));
    }

    public AtomicDatatype not() {
        return new XSDDerivedBooleanType(3 - this.status);
    }

    public AtomicDatatype intersection(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        int result = 0;
        if (dt instanceof XSDBoolean) {
            XSDBoolean other = (XSDBoolean)dt;
            result = this.status & other.status;
        }
        return new XSDDerivedBooleanType(result);
    }

    public AtomicDatatype union(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        int result = 0;
        if (dt instanceof XSDBoolean) {
            XSDBoolean other = (XSDBoolean)dt;
            result = this.status | other.status;
        }
        return new XSDDerivedBooleanType(result);
    }

    public AtomicDatatype difference(AtomicDatatype dt) {
        return this.intersection(dt.not());
    }

    public int size() {
        if (this.status == 0) {
            return 0;
        }
        if (this.status == 3) {
            return 2;
        }
        return 1;
    }

    public boolean contains(Object value) {
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return this.status == 3 || this.status == 1 && bool != false || this.status == 2 && bool == false;
        }
        return false;
    }

    public Datatype singleton(Object value) {
        if (value instanceof Boolean) {
            boolean bool = (Boolean)value;
            return new XSDDerivedBooleanType(bool ? 1 : 2);
        }
        return null;
    }

    public Object getValue(String value, String datatypeURI) {
        return dt.createValue(value, null);
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    public ATermAppl getValue(int i) {
        switch (this.status) {
            case 0: {
                throw new InternalReasonerException("This datatype is empty!");
            }
            case 1: {
                if (i == 0) {
                    return ATermUtils.makeTypedLiteral("true", this.name.getName());
                }
                throw new InternalReasonerException("No more values!");
            }
            case 2: {
                if (i == 0) {
                    return ATermUtils.makeTypedLiteral("false", this.name.getName());
                }
                throw new InternalReasonerException("No more values!");
            }
            case 3: {
                if (i == 0) {
                    return ATermUtils.makeTypedLiteral("true", this.name.getName());
                }
                if (i == 1) {
                    return ATermUtils.makeTypedLiteral("false", this.name.getName());
                }
                throw new InternalReasonerException("No more values!");
            }
        }
        throw new InternalReasonerException("Invalid status!");
    }

    static {
        try {
            dt = DatatypeFactory.getTypeByName((String)"boolean");
        }
        catch (DatatypeException e) {
            e.printStackTrace();
        }
    }

    public class XSDDerivedBooleanType
    extends XSDBoolean {
        protected XSDDerivedBooleanType(int status) {
            this.status = status;
        }

        public boolean isDerived() {
            return true;
        }
    }
}

