/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.rules.BindingGenerator;
import org.mindswap.pellet.rules.BindingGeneratorImpl;
import org.mindswap.pellet.rules.BindingGeneratorStrategy;
import org.mindswap.pellet.rules.BindingHelper;
import org.mindswap.pellet.rules.DataRangeBindingHelper;
import org.mindswap.pellet.rules.DatavaluePropertyBindingHelper;
import org.mindswap.pellet.rules.ObjectVariableBindingHelper;
import org.mindswap.pellet.rules.TrivialSatisfactionHelpers;
import org.mindswap.pellet.rules.VariableBinding;
import org.mindswap.pellet.rules.VariableUtils;
import org.mindswap.pellet.rules.builtins.BuiltIn;
import org.mindswap.pellet.rules.builtins.BuiltInRegistry;
import org.mindswap.pellet.rules.model.AtomDVariable;
import org.mindswap.pellet.rules.model.AtomIVariable;
import org.mindswap.pellet.rules.model.AtomVariable;
import org.mindswap.pellet.rules.model.BuiltInAtom;
import org.mindswap.pellet.rules.model.DataRangeAtom;
import org.mindswap.pellet.rules.model.DatavaluedPropertyAtom;
import org.mindswap.pellet.rules.model.DefaultRuleAtomVisitor;
import org.mindswap.pellet.rules.model.Rule;
import org.mindswap.pellet.rules.model.RuleAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingGeneratorStrategyImpl
implements BindingGeneratorStrategy {
    private ABox abox;

    public BindingGeneratorStrategyImpl(ABox abox) {
        this.abox = abox;
    }

    @Override
    public BindingGenerator createGenerator(Rule rule) {
        return this.createGenerator(rule, new VariableBinding(this.abox));
    }

    @Override
    public BindingGenerator createGenerator(Rule rule, VariableBinding initialBinding) {
        BodyAtomsToSelectiveHelpersVisitor selectiveVisitor = new BodyAtomsToSelectiveHelpersVisitor();
        HashSet<AtomIVariable> instanceVariables = new HashSet<AtomIVariable>();
        HashSet<AtomDVariable> dataVariables = new HashSet<AtomDVariable>();
        for (RuleAtom pattern : rule.getBody()) {
            pattern.accept(selectiveVisitor);
            instanceVariables.addAll(VariableUtils.getIVars(pattern));
            dataVariables.addAll(VariableUtils.getDVars(pattern));
        }
        List<BindingHelper> helpers = selectiveVisitor.getHelpers();
        HashSet<? extends AtomVariable> selectiveVariables = new HashSet<AtomVariable>();
        for (BindingHelper helper : helpers) {
            selectiveVariables.addAll(helper.getBindableVars());
        }
        if (!selectiveVariables.containsAll(dataVariables)) {
            ABox.log.warn((Object)("IGNORING RULE " + rule + ": Cannot generate bindings for all data variables."));
            return new BindingGeneratorImpl();
        }
        for (AtomIVariable var : instanceVariables) {
            if (selectiveVariables.contains(var)) continue;
            helpers.add(new ObjectVariableBindingHelper(this.abox, var));
        }
        helpers.addAll(new TrivialSatisfactionHelpers(this.abox).getHelpers(rule));
        if (!this.ensureOrdering(helpers, initialBinding)) {
            ABox.log.warn((Object)("IGNORING RULE " + rule + ": Could not generate safe ordering for body constraints."));
            return new BindingGeneratorImpl();
        }
        this.optimize(helpers);
        return new BindingGeneratorImpl(this.abox, initialBinding, helpers);
    }

    private boolean ensureOrdering(List<BindingHelper> helpers, VariableBinding initialBinding) {
        ArrayList<BindingHelper> unsatList = new ArrayList<BindingHelper>();
        HashSet<? extends AtomVariable> bound = new HashSet<AtomVariable>();
        ListIterator<BindingHelper> listIter = helpers.listIterator();
        while (listIter.hasNext()) {
            BindingHelper helper = listIter.next();
            if (bound.containsAll(helper.getPrerequisiteVars())) {
                bound.addAll(helper.getBindableVars());
                ListIterator unsatIter = unsatList.listIterator();
                while (unsatIter.hasNext()) {
                    BindingHelper unsat = (BindingHelper)unsatIter.next();
                    if (!bound.containsAll(unsat.getPrerequisiteVars())) continue;
                    listIter.add(unsat);
                    unsatIter.remove();
                }
                continue;
            }
            unsatList.add(helper);
            listIter.remove();
        }
        return unsatList.size() == 0;
    }

    private void optimize(List<BindingHelper> helpers) {
        HashSet<? extends AtomVariable> bound = new HashSet<AtomVariable>();
        for (int i = 0; i < helpers.size(); ++i) {
            int j = 0;
            while (i + j < helpers.size()) {
                BindingHelper helper = helpers.get(i + j);
                if (bound.containsAll(helper.getBindableVars()) && bound.containsAll(helper.getPrerequisiteVars())) {
                    helpers.remove(i + j);
                    helpers.add(i, helper);
                    ++i;
                    continue;
                }
                ++j;
            }
            if (i >= helpers.size()) continue;
            bound.addAll(helpers.get(i).getBindableVars());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BodyAtomsToSelectiveHelpersVisitor
    extends DefaultRuleAtomVisitor {
        private List<BindingHelper> helpers = new ArrayList<BindingHelper>();

        private BodyAtomsToSelectiveHelpersVisitor() {
        }

        public List<BindingHelper> getHelpers() {
            return this.helpers;
        }

        @Override
        public void visit(BuiltInAtom atom) {
            BuiltIn builtIn = BuiltInRegistry.instance.getBuiltIn((String)atom.getPredicate());
            this.helpers.add(builtIn.createHelper(atom));
        }

        @Override
        public void visit(DataRangeAtom atom) {
            this.helpers.add(new DataRangeBindingHelper(atom));
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            this.helpers.add(new DatavaluePropertyBindingHelper(BindingGeneratorStrategyImpl.this.abox, atom));
        }
    }
}

