/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import aterm.ATermAppl;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.rules.builtins.TestComparison;
import org.mindswap.pellet.rules.builtins.TestEqual;
import org.mindswap.pellet.rules.builtins.TestNotEqual;
import org.mindswap.pellet.utils.ATermUtils;

public class BuiltInTests {
    private ABox abox;
    private KnowledgeBase kb;
    private ATermAppl li_1 = ATermUtils.makeTypedLiteral("-1", "http://www.w3.org/2001/XMLSchema#integer");
    private ATermAppl li0 = ATermUtils.makeTypedLiteral("0", "http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
    private ATermAppl li1 = ATermUtils.makeTypedLiteral("1", "http://www.w3.org/2001/XMLSchema#positiveInteger");
    private ATermAppl lf_1 = ATermUtils.makeTypedLiteral("-1.0", "http://www.w3.org/2001/XMLSchema#float");
    private ATermAppl lf0 = ATermUtils.makeTypedLiteral("0.0", "http://www.w3.org/2001/XMLSchema#float");
    private ATermAppl lf00 = ATermUtils.makeTypedLiteral("0.00", "http://www.w3.org/2001/XMLSchema#float");
    private ATermAppl lp0 = ATermUtils.makePlainLiteral("0");
    private ATermAppl ls0 = ATermUtils.makePlainLiteral("0", "http://www.w3.org/2001/XMLSchema#string");

    @Before
    public void setUp() {
        this.kb = new KnowledgeBase();
        this.abox = this.kb.getABox();
    }

    private boolean equal(Literal l1, Literal l2) {
        return TestEqual.instance.test(new Literal[]{l1, l2});
    }

    private boolean greaterThan(Literal l1, Literal l2) {
        return TestComparison.greaterThan.test(new Literal[]{l1, l2});
    }

    private boolean greaterThanOrEqual(Literal l1, Literal l2) {
        return TestComparison.greaterThanOrEqual.test(new Literal[]{l1, l2});
    }

    private boolean lessThan(Literal l1, Literal l2) {
        return TestComparison.lessThan.test(new Literal[]{l1, l2});
    }

    private boolean lessThanOrEqual(Literal l1, Literal l2) {
        return TestComparison.lessThanOrEqual.test(new Literal[]{l1, l2});
    }

    private boolean notEqual(Literal l1, Literal l2) {
        return TestNotEqual.instance.test(new Literal[]{l1, l2});
    }

    @Ignore(value="Known to fail, see ticket #20")
    @org.junit.Test
    public void testComparisons() {
        Literal l1 = this.abox.addLiteral(this.li_1);
        Literal l2 = this.abox.addLiteral(this.li0);
        Assert.assertFalse((boolean)this.equal(l1, l2));
        Assert.assertFalse((boolean)this.greaterThan(l1, l2));
        Assert.assertTrue((boolean)this.greaterThan(l2, l1));
        Assert.assertFalse((boolean)this.greaterThanOrEqual(l1, l2));
        Assert.assertTrue((boolean)this.lessThan(l1, l2));
        Assert.assertFalse((boolean)this.lessThan(l2, l1));
        Assert.assertTrue((boolean)this.notEqual(l1, l2));
        l1 = this.abox.addLiteral(this.lf0);
        l2 = this.abox.addLiteral(this.lf00);
        Assert.assertTrue((boolean)this.equal(l1, l2));
        Assert.assertFalse((boolean)this.greaterThan(l1, l2));
        Assert.assertTrue((boolean)this.greaterThanOrEqual(l1, l2));
        Assert.assertFalse((boolean)this.lessThan(l1, l2));
        Assert.assertTrue((boolean)this.lessThanOrEqual(l1, l2));
        Assert.assertFalse((boolean)this.notEqual(l1, l2));
        l1 = this.abox.addLiteral(this.lf0);
        l2 = this.abox.addLiteral(this.li0);
        Assert.assertFalse((boolean)this.equal(l1, l2));
        Assert.assertFalse((boolean)this.greaterThan(l1, l2));
        Assert.assertFalse((boolean)this.lessThan(l1, l2));
        Assert.assertTrue((boolean)this.notEqual(l1, l2));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(BuiltInTests.class);
    }
}

