/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class Cache {
    protected Properties cache = new Properties();
    protected String localCacheDirectory = null;
    protected boolean forced = true;

    public void setForced(boolean b) {
        this.forced = b;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setLocalCacheDirectory(String dir) {
        this.localCacheDirectory = dir;
        if (dir == null) {
            this.cache.clear();
            System.out.println("INFO: Local cache directory is disabled");
        } else {
            String indexFileName = this.localCacheDirectory + File.separator + "service.idx";
            try {
                File indexFile = new File(indexFileName);
                this.cache = new Properties();
                this.cache.load(new FileInputStream(indexFile));
                System.out.println("INFO: Cache has been initialized with " + this.cache.size() + " entries");
            }
            catch (FileNotFoundException e) {
                System.err.println("ERROR: Cache index file " + indexFileName + " cannot be found");
                this.localCacheDirectory = null;
            }
            catch (IOException e) {
                System.err.println("ERROR: Cache index file " + indexFileName + " has an invalid format");
                this.localCacheDirectory = null;
            }
        }
    }

    public File getCachedFile(String fileURI) {
        File file = null;
        try {
            String localFileName;
            if (this.cache == null) {
                return null;
            }
            if (fileURI.endsWith("#")) {
                fileURI = fileURI.substring(0, fileURI.length() - 1);
            }
            if ((localFileName = this.cache.getProperty(fileURI)) != null && !(file = this.localCacheDirectory == null ? new File(localFileName) : new File(this.localCacheDirectory + File.separator + localFileName)).exists()) {
                System.out.println("WARNING: Cached file does not exist " + file);
                file = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    public void addCachedFile(String fileURI, String localFile) {
        this.cache.setProperty(fileURI, localFile);
    }
}

