/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.ape;

import ch.uzh.ifi.attempto.ape.ACEParserException;
import ch.uzh.ifi.attempto.ape.ACEParserResult;
import ch.uzh.ifi.attempto.ape.Lexicon;
import ch.uzh.ifi.attempto.ape.OutputType;
import ch.uzh.ifi.attempto.ape.PrologUtils;
import java.io.Reader;
import java.io.StringReader;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class ACEParser {
    private boolean guessingEnabled = false;
    private boolean clexEnabled = true;
    private String uri;

    protected ACEParser() {
    }

    public abstract String getSoloOutput(String var1, Lexicon var2, OutputType var3) throws ACEParserException;

    public final String getSoloOutput(String string, OutputType outputType) throws ACEParserException {
        return this.getSoloOutput(string, null, outputType);
    }

    public abstract ACEParserResult getMultiOutput(String var1, Lexicon var2, OutputType ... var3);

    public final ACEParserResult getMultiOutput(String string, OutputType ... outputTypeArray) {
        return this.getMultiOutput(string, (Lexicon)null, outputTypeArray);
    }

    public void setGuessingEnabled(boolean bl) {
        this.guessingEnabled = bl;
    }

    public boolean isGuessingEnabled() {
        return this.guessingEnabled;
    }

    public void setURI(String string) {
        this.uri = string;
    }

    public String getURI() {
        return this.uri;
    }

    public void setClexEnabled(boolean bl) {
        this.clexEnabled = bl;
    }

    public boolean isClexEnabled() {
        return this.clexEnabled;
    }

    String getOptions() {
        String string = "";
        if (this.isGuessingEnabled()) {
            string = ",guess=on";
        }
        String string2 = ",noclex=on";
        if (this.isClexEnabled()) {
            string2 = ",noclex=off";
        }
        String string3 = "";
        if (this.getURI() != null) {
            string3 = ",uri=" + PrologUtils.escape(this.getURI());
        }
        return string + string2 + string3;
    }

    static String checkForErrors(String string) throws ACEParserException {
        Element element = null;
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            sAXBuilder.setValidation(false);
            element = sAXBuilder.build((Reader)new StringReader(string)).getRootElement();
        }
        catch (Exception exception) {
            return string;
        }
        if (element != null && element.getName().equals("messages")) {
            throw new ACEParserException(element);
        }
        return string;
    }
}

