/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.filetransfer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo2.app.filetransfer.UploadSelect;
import nextapp.echo2.webcontainer.filetransfer.MultipartUploadSPI;

public abstract class AbstractFileUploadProvider
implements MultipartUploadSPI,
Serializable {
    protected static final String TEMPDIR_PATH = System.getProperty("java.io.tmpdir", ".");
    protected static final File TEMPDIR_FILE;
    private static final int DEFAULT_UPLOAD_LIMIT = 0x8000000;
    private static final File DEFAULT_DISK_CACHE_LOCATION;
    private static final int DEFAULT_MEMORY_CACHE_THRESHOLD = 16384;

    public boolean supportsDiskCaching() {
        return true;
    }

    public boolean supportsFileUploadSizeLimit() {
        return true;
    }

    public File getDiskCacheLocation() throws IOException, UnsupportedOperationException {
        return DEFAULT_DISK_CACHE_LOCATION;
    }

    public int getFileUploadSizeLimit() throws UnsupportedOperationException {
        return 0x8000000;
    }

    public int getMemoryCacheThreshold() throws UnsupportedOperationException {
        return 16384;
    }

    public HttpServletRequest getWrappedRequest(HttpServletRequest request) throws IOException, ServletException {
        return request;
    }

    protected File writeTempFile(InputStream in, UploadSelect uploadSelect) throws IOException {
        File file = new File(TEMPDIR_PATH + "/" + System.currentTimeMillis() + uploadSelect.getRenderId() + ".tmp");
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[1024];
        int bytesRead = in.read(buffer);
        while (bytesRead >= 0) {
            out.write(buffer, 0, bytesRead);
            bytesRead = in.read(buffer);
        }
        in.close();
        out.flush();
        out.close();
        return file;
    }

    static {
        DEFAULT_DISK_CACHE_LOCATION = TEMPDIR_FILE = new File(TEMPDIR_PATH);
    }
}

