/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.componentxml.propertypeer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.componentxml.InvalidPropertyException;
import nextapp.echo2.app.componentxml.PropertyXmlPeer;
import org.w3c.dom.Element;

public class ExtentPeer
implements PropertyXmlPeer {
    private static final Map UNITS_TEXT_TO_CONSTANT;

    public static Extent toExtent(String value) {
        int suffixIndex = -1;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (i == 0 && ch == '-' || Character.isDigit(ch)) continue;
            suffixIndex = i;
            break;
        }
        if (suffixIndex < 1) {
            throw new IllegalArgumentException("Invalid Extent value: " + value);
        }
        int size = Integer.parseInt(value.substring(0, suffixIndex));
        String unitsText = value.substring(suffixIndex);
        if (!UNITS_TEXT_TO_CONSTANT.containsKey(unitsText)) {
            throw new IllegalArgumentException("Invalid Extent units: " + value);
        }
        int units = (Integer)UNITS_TEXT_TO_CONSTANT.get(unitsText);
        return new Extent(size, units);
    }

    public Object getValue(ClassLoader classLoader, Class objectClass, Element propertyElement) throws InvalidPropertyException {
        return ExtentPeer.toExtent(propertyElement.getAttribute("value"));
    }

    static {
        HashMap<String, Integer> constantMap = new HashMap<String, Integer>();
        constantMap.put("cm", new Integer(8));
        constantMap.put("em", new Integer(64));
        constantMap.put("ex", new Integer(128));
        constantMap.put("in", new Integer(32));
        constantMap.put("mm", new Integer(16));
        constantMap.put("pc", new Integer(256));
        constantMap.put("pt", new Integer(4));
        constantMap.put("px", new Integer(1));
        constantMap.put("%", new Integer(2));
        UNITS_TEXT_TO_CONSTANT = Collections.unmodifiableMap(constantMap);
    }
}

