/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.button;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.RenderIdSupport;

public class ButtonGroup
implements RenderIdSupport,
Serializable {
    private static final RadioButton[] EMPTY = new RadioButton[0];
    private String id = ApplicationInstance.generateSystemId();
    private Set buttons;

    public void addButton(RadioButton radioButton) {
        if (this.buttons == null) {
            this.buttons = new HashSet();
        }
        this.buttons.add(radioButton);
        this.updateSelection(radioButton);
    }

    public RadioButton[] getButtons() {
        if (this.buttons == null) {
            return EMPTY;
        }
        return this.buttons.toArray(new RadioButton[this.buttons.size()]);
    }

    public String getRenderId() {
        return this.id;
    }

    public void removeButton(RadioButton radioButton) {
        if (this.buttons != null) {
            this.buttons.remove(radioButton);
        }
    }

    public void updateSelection(RadioButton changedButton) {
        if (this.buttons == null || !changedButton.isSelected()) {
            return;
        }
        Iterator buttonIt = this.buttons.iterator();
        while (buttonIt.hasNext()) {
            RadioButton button = (RadioButton)buttonIt.next();
            if (button.equals(changedButton)) continue;
            button.setSelected(false);
        }
    }
}

