/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.componentxml;

import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.MutableStyle;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.componentxml.ComponentIntrospector;
import nextapp.echo2.app.componentxml.ComponentXmlException;
import nextapp.echo2.app.componentxml.InvalidPropertyException;
import nextapp.echo2.app.componentxml.PropertyXmlPeer;
import nextapp.echo2.app.util.DomUtil;
import nextapp.echo2.app.util.PeerFactory;
import org.w3c.dom.Element;

public class PropertyLoader {
    private static final String PROPERTY_XML_PEERS_PATH = "META-INF/nextapp/echo2/PropertyXmlPeers.properties";
    private static final Map classLoaderToPropertyLoaderMap = new HashMap();
    private ClassLoader classLoader;
    private PeerFactory propertyXmlPeerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyLoader forClassLoader(ClassLoader classLoader) {
        Map map = classLoaderToPropertyLoaderMap;
        synchronized (map) {
            PropertyLoader propertyLoader = (PropertyLoader)classLoaderToPropertyLoaderMap.get(classLoader);
            if (propertyLoader == null) {
                propertyLoader = new PropertyLoader(classLoader);
                classLoaderToPropertyLoaderMap.put(classLoader, propertyLoader);
            }
            return propertyLoader;
        }
    }

    private PropertyLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.propertyXmlPeerFactory = new PeerFactory(PROPERTY_XML_PEERS_PATH, classLoader);
    }

    public Style createStyle(Element propertiesElement, String type) throws ComponentXmlException {
        ComponentIntrospector ci;
        MutableStyle propertyStyle = new MutableStyle();
        if (propertiesElement == null) {
            return new MutableStyle();
        }
        try {
            ci = ComponentIntrospector.forName(type, this.classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new ComponentXmlException("Unable to introspect component: " + type, ex);
        }
        Element[] propertyElements = DomUtil.getChildElementsByTagName(propertiesElement, "property");
        for (int i = 0; i < propertyElements.length; ++i) {
            Class<?> propertyClass;
            String propertyName = propertyElements[i].getAttribute("name");
            if (propertyElements[i].hasAttribute("type")) {
                try {
                    propertyClass = Class.forName(propertyElements[i].getAttribute("type"));
                }
                catch (ClassNotFoundException ex) {
                    throw new ComponentXmlException("Custom property class not found: " + propertyElements[i].getAttribute("type"), ex);
                }
            } else {
                propertyClass = ci.getPropertyClass(propertyName);
            }
            if (propertyClass == null) {
                throw new ComponentXmlException("Property does not exist: " + propertyName, null);
            }
            Object propertyValue = this.getPropertyValue(ci.getObjectClass(), propertyClass, propertyElements[i]);
            if (ci.isIndexedProperty(propertyName)) {
                try {
                    int index = Integer.parseInt(propertyElements[i].getAttribute("index"));
                    propertyStyle.setIndexedProperty(propertyName, index, propertyValue);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new ComponentXmlException("Index not set.", ex);
                }
            }
            propertyStyle.setProperty(propertyName, propertyValue);
        }
        return propertyStyle;
    }

    public Object getPropertyValue(Class objectClass, Class propertyClass, Element propertyElement) throws InvalidPropertyException {
        PropertyXmlPeer propertyXmlPeer = (PropertyXmlPeer)this.propertyXmlPeerFactory.getPeerForObject(propertyClass, false);
        if (propertyXmlPeer == null) {
            throw new InvalidPropertyException("Peer not found for property class: " + propertyClass, null);
        }
        Object propertyValue = propertyXmlPeer.getValue(this.classLoader, objectClass, propertyElement);
        return propertyValue;
    }

    public PropertyXmlPeer getPropertyXmlPeer(Class propertyClass) {
        return (PropertyXmlPeer)this.propertyXmlPeerFactory.getPeerForObject(propertyClass, false);
    }
}

