/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.componentxml.propertypeer;

import nextapp.echo2.app.componentxml.ComponentIntrospector;
import nextapp.echo2.app.componentxml.InvalidPropertyException;
import nextapp.echo2.app.componentxml.PropertyXmlPeer;
import org.w3c.dom.Element;

public class IntegerPeer
implements PropertyXmlPeer {
    public Object getValue(ClassLoader classLoader, Class objectClass, Element propertyElement) throws InvalidPropertyException {
        String stringValue = propertyElement.getAttribute("value");
        try {
            return new Integer(stringValue);
        }
        catch (NumberFormatException ex) {
            return this.introspectConstantValue(classLoader, objectClass, stringValue);
        }
    }

    public Integer introspectConstantValue(ClassLoader classLoader, Class objectClass, String value) throws InvalidPropertyException {
        try {
            Object constantValue;
            ComponentIntrospector ci = ComponentIntrospector.forName(objectClass.getName(), classLoader);
            if (value.startsWith(objectClass.getName())) {
                value = value.substring(objectClass.getName().length() + 1);
            }
            if ((constantValue = ci.getConstantValue(value)) instanceof Integer) {
                return (Integer)constantValue;
            }
            return null;
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidPropertyException("Object class not found.", ex);
        }
    }
}

