// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.acewiki.core.text;

import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.preditor.text.TextElement;

/**
 * This is an implementation of the OntologyTextElement interface.
 * 
 * @author Tobias Kuhn
 */
class OntoTextElem implements OntologyTextElement {

	private OntologyElement ontologyElement;
	private int wordNumber;
	private String category;
	private boolean capitalize = false;
	
	OntoTextElem(OntologyElement ontologyElement, int wordNumber, String category) {
		if (ontologyElement.getWord(wordNumber) == null) {
			throw new RuntimeException(ontologyElement + " has no word number " + wordNumber);
		}
		this.ontologyElement = ontologyElement;
		this.wordNumber = wordNumber;
		this.category = category;
	}
	
	public String getUnderscoredText() {
		String t = ontologyElement.getWord(wordNumber);
		if (capitalize) {
			return t.substring(0,1).toUpperCase() + t.substring(1);
		} else {
			return t;
		}
	}
	
	public String getText() {
		String t = ontologyElement.getPrettyWord(wordNumber);
		if (capitalize) {
			return t.substring(0,1).toUpperCase() + t.substring(1);
		} else {
			return t;
		}
	}
	
	public int getWordNumber() {
		return wordNumber;
	}
	
	public String getCategory() {
		return category;
	}

	public void checkNeighborTextElements(TextElement precedingTextElement, TextElement nextTextElement) {
		if (precedingTextElement == null || precedingTextElement.getText().matches("[.?]")) {
			capitalize = true;
		} else {
			capitalize = false;
		}
	}

	public OntologyElement getOntologyElement() {
		return ontologyElement;
	}
	
	public boolean equals(Object obj) {
		if (obj instanceof OntoTextElem) {
			OntoTextElem other = ((OntoTextElem) obj);
			return (ontologyElement == other.ontologyElement && wordNumber == other.wordNumber && category.equals(other.category));
		}
		return false;
	}

}
