// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.acewiki.gui;

import ch.uzh.ifi.attempto.echocomp.Style;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import echopointng.DropDown;

/**
 * This class represents drop down menus that are shown in front of the ACE sentences as
 * small triangles.
 * 
 * @author Tobias Kuhn
 */
public class DropDownMenu extends DropDown implements ActionListener {

	private static final long serialVersionUID = 3646511994109953476L;
	
	private Column menuColumn = new Column();
	private ActionListener actionListener;
	private Column menuSeparator = null;
	
	/**
	 * Creates a empty drop down menu with an icon of the given color.
	 * 
	 * @param color The color of the icon, one of "blue", "light-blue", or "red".
	 * @param actionListener The actionlistener.
	 */
	public DropDownMenu(String color, ActionListener actionListener) {
		this.actionListener = actionListener;
		setWidth(new Extent(13));
		setPopUp(menuColumn);
		setPopUpBorder(new Border(1, Color.BLACK, Border.STYLE_OUTSET));
		setPopUpAlignment(new Alignment(Alignment.RIGHT, Alignment.BOTTOM));
		setPopUpInsets(new Insets(0, 0));
		setPopUpOutsets(new Insets(15, -15, 0, 0));
		String img1 = null;
		String img2 = null;
		if (color.equals("blue")) {
			img1 = "ch/uzh/ifi/attempto/acewiki/gui/img/DropDown1.png";
			img2 = "ch/uzh/ifi/attempto/acewiki/gui/img/DropDown2.png";
		} else if (color.equals("red")) {
			img1 = "ch/uzh/ifi/attempto/acewiki/gui/img/DropDownRed1.png";
			img2 = "ch/uzh/ifi/attempto/acewiki/gui/img/DropDownRed2.png";
		} else if (color.equals("light-blue")) {
			img1 = "ch/uzh/ifi/attempto/acewiki/gui/img/DropDownLBlue1.png";
			img2 = "ch/uzh/ifi/attempto/acewiki/gui/img/DropDownLBlue2.png";
		}
		setToggleIcon(new ResourceImageReference(img1));
		setToggleRolloverIcon(new ResourceImageReference(img2));
		setTogglePressedIcon(new ResourceImageReference(img2));
		setBorder(new Border(0, Color.BLACK, Border.STYLE_SOLID));
		setRolloverBorder(new Border(0, Color.BLACK, Border.STYLE_SOLID));
	}
	
	/**
	 * Adds a menu entry to the drop down menu.
	 * 
	 * @param text The text of the menu entry.
	 */
	public void addMenuEntry(String text) {
		if (menuSeparator != null) {
			menuColumn.add(menuSeparator);
			menuSeparator = null;
		}
		Button menuEntry = new Button(text);
		menuEntry.setActionCommand(text);
		menuEntry.setHeight(new Extent(16));
		menuEntry.setWidth(new Extent(130));
		menuEntry.setBackground(Style.mediumBackground);
		menuEntry.setForeground(Style.darkForeground);
		menuEntry.setRolloverEnabled(true);
		menuEntry.setRolloverForeground(Style.lightForeground);
		menuEntry.setRolloverBackground(Style.darkBackground);
		menuEntry.setInsets(new Insets(2, 0));
		menuEntry.setAlignment(new Alignment(Alignment.LEFT, Alignment.CENTER));
		menuEntry.setTextAlignment(new Alignment(Alignment.LEFT, Alignment.CENTER));
		menuEntry.setFont(new Font(Style.fontTypeface, Font.ITALIC, new Extent(13)));
		menuEntry.addActionListener(this);
		menuColumn.add(menuEntry);
	}
	
	/**
	 * Adds a separator to the menu.
	 */
	public void addMenuSeparator() {
		if (menuColumn.getComponentCount() == 0) return;
		menuSeparator = new Column();
		menuSeparator.setInsets(new Insets(2, 0, 2, 0));
		menuSeparator.setBackground(Style.mediumBackground);
		Column line = new Column();
		line.setBackground(Style.darkBackground);
		line.setInsets(new Insets(0, 1, 0, 0));
		menuSeparator.add(line);
	}
	
	public void actionPerformed(ActionEvent e) {
		setExpanded(false);
		actionListener.actionPerformed(new ActionEvent(this, e.getActionCommand()));
	}

}
