// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.acewiki.gui.page;

import java.util.Stack;

/**
 * This class generates the colored syntax boxes on the basis of the syntax tree of an ACE sentence.
 * This is actually the wrong place for doing this. It should be done in Prolog within the APE package.
 * 
 * @author Tobias Kuhn
 */
class SyntaxBoxes {
	
	private static final String[] sNodes = new String[] {"s", "cond_s", "neg_s", "s_coord", "top_s", "question"};
	private static final String[] vpNodes = new String[] {"vp", "vp_coord", "neg_vp"};
	private static final String[] npNodes = new String[] {"np"};
	
	private final boolean showS, showVP, showNP;
	private Stack<String> stack = new Stack<String>();
	
	private SyntaxBoxes(boolean showS, boolean showVP, boolean showNP) {
		this.showS = showS;
		this.showVP = showVP;
		this.showNP = showNP;
	}
	
	public static String getBoxesHtml(String p, boolean showS, boolean showVP, boolean showNP) {
		String s = new SyntaxBoxes(showS, showVP, showNP).createBoxes(p);
		String c = s.replace("'", "").replace("{", "").replace("}", "").replace("_that_", "that");
		String r =
			"<table>\n" +
			"<style type=\"text/css\">\n" +
			"table.np { padding: 0.1em 0.1em 0.1em 0.1em; border: 1px solid #55F; background-color: #BBF; white-space: nowrap }\n" +
			"table.vp { padding: 0.1em 0.1em 0.1em 0.1em; border: 1px solid #AA2; background-color: #FF5; white-space: nowrap }\n" +
			"table.s  { padding: 0.1em 0.1em 0.1em 0.1em; border: 1px solid #AAA; background-color: #EEE; white-space: nowrap }\n" +
			"</style>\n\n" +
			"<tr>\n" +
			c +
			"</tr>\n" +
			"</table>";
		// This style-element is actually not allowed at this position. But it works.
		
		return r;
	}
	
	private String createBoxes(String p) {
		if (p.length() == 0) {
			return "";
		} else if (p.startsWith(", ")) {
			return createBoxes(p.substring(2));
		} else if (p.startsWith("[[")) {
			stack.push("");
			return createBoxes(p.substring(1));
		} else if (p.startsWith("[]")) {
			return createBoxes(p.substring(2));
		} else if (p.startsWith("[")) {
			if (showS) {
				for (String s : sNodes) {
					if (p.startsWith("[" + s + ", ")) {
						stack.push("</tr></table></td>");
						return "<td><table class=\"s\"><tr>" + createBoxes(p.substring(s.length()+3));
					}
				}
			}
			if (showVP) {
				for (String s : vpNodes) {
					if (p.startsWith("[" + s + ", ")) {
						stack.push("</tr></table></td>");
						return "<td><table class=\"vp\"><tr>" + createBoxes(p.substring(s.length()+3));
					}
				}
			}
			if (showNP) {
				
				for (String s : npNodes) {
					if (p.startsWith("[" + s + ", ")) {
						stack.push("</tr></table></td>");
						return "<td><table class=\"np\"><tr>" + createBoxes(p.substring(s.length()+3));
					}
				}
			}
			if (p.indexOf(", ") > 0) {
				stack.push("");
				return createBoxes(p.substring(p.indexOf(", ")+2));
			}
		} else if (p.startsWith("]")) {
			String t = stack.pop();
			return t + createBoxes(p.substring(1));
		} else if (p.indexOf("]") > 0) {
			int ci = p.indexOf(",");
			int bi = p.indexOf("]");
			int i = bi;
			if (ci > 0 && ci < bi) i = ci;
			String a = p.substring(0, i);
			String b = p.substring(i);
			return "<td>" + a + "</td> " + createBoxes(b);
		}
		return " ERROR(" + p + ")ERROR ";
	}

}
