// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.chartparser;

import java.util.ArrayList;


class StringEntity {
	
	private static int nextID = 0;
	
	private String string;
	private final int id;
	private ArrayList<StringRef> stringRefs = new ArrayList<StringRef>();
	
	
	public StringEntity(String string) {
		this.string = string;
		id = nextID++;
	}
	
	public String getString() {
		return string;
	}
	
	void addReference(StringRef r) {
		stringRefs.add(r);
		r.setStringEntity(this);
	}
	
	public void unify(StringEntity e) throws UnificationFailedException {
		if (string == null) {
			string = e.string;
		} else if (e.string != null && !string.equals(e.string)) {
			throw new UnificationFailedException();
		}
		stringRefs.addAll(e.stringRefs);
		for (StringRef r : e.stringRefs) {
			r.setStringEntity(this);
		}
	}
	
	public int getID() {
		return id;
	}
	
	public StringRef newStringRef() {
		return new StringRef(this);
	}

}
