// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.preditor;

import ch.uzh.ifi.attempto.echocomp.Style;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;

/**
 * This abstract class represents an item of a menu of the predictive editor. 
 * 
 * @author Tobias Kuhn
 */
public abstract class MenuItem extends Button implements Comparable<MenuItem> {
	
	/**
	 * Initializes a new menu item.
	 */
	public MenuItem() {
        setWidth(new Extent(146));
        setHeight(new Extent(15));
        setInsets(new Insets(2,0));
		setBackground(Style.mediumBackground);
		setForeground(Style.darkForeground);
		setRolloverEnabled(true);
		setRolloverForeground(Style.lightForeground);
		setRolloverBackground(Style.darkBackground);
        setLineWrap(false);
        setFont(new Font(Style.fontTypeface, Font.PLAIN, new Extent(12)));
	}

	public int compareTo(MenuItem m) {
		String s1 = getText();
		String s2 = m.getText();
		
		if (this instanceof SpecialMenuItem && m instanceof SpecialMenuItem) {
			return s1.compareToIgnoreCase(s2);
		} else if (this instanceof SpecialMenuItem) {
			return -1;
		} else if (m instanceof SpecialMenuItem) {
			return 1;
		}
		
		Integer i1 = null;
		Integer i2 = null;
		
		try {
			i1 = Integer.parseInt(s1);
		} catch (NumberFormatException ex) {}
		try {
			i2 = Integer.parseInt(s2);
		} catch (NumberFormatException ex) {}
		
		if (i1 == null && i2 == null) {
			return s1.compareToIgnoreCase(s2);
		} else if (i1 == null) {
			return 1;
		} else if (i2 == null) {
			return -1;
		} else {
			return i1 - i2;
		}
	}
        
}
