// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.preditor.text;

/**
 * This interface describes text elements that can be referred to at a later position in
 * the text.
 * 
 * @see RefTextElement
 * @see NounTextElement
 * @author Tobias Kuhn
 */
public interface RefableTextElement extends TextElement {
	
	/**
	 * This method should return the text how a reference to this text element has to look like.
	 * 
	 * @return The text of a possible reference.
	 */
	public abstract String getReferenceText();

}
