% This file is part of the Attempto Java Packages.
% Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
%
% The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
% terms of the GNU Lesser General Public License as published by the Free Software Foundation,
% either version 3 of the License, or (at your option) any later version.
%
% The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
% WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
% PURPOSE. See the GNU Lesser General Public License for more details.
%
% You should have received a copy of the GNU Lesser General Public License along with the Attempto
% Java Packages. If not, see http://www.gnu.org/licenses/.

%===================================================================================================
% This is the AceWiki grammar in the ACGN format. It covers a subset of ACE.
%
% Author: Tobias Kuhn
%===================================================================================================

text ~>
	[].

text ~>
	textelement,
	text.

textelement ~>
	declaration.
	
textelement ~>
	question.

declaration ~>
	sentence,
	['.'].

question ~>
	simple_sentence_2(whin:right, whout:left),
	['?'].

sentence =>
	sentence_coord_1.

sentence ~>
	['for every'],
	noun_constr,
	sentence_coord_1.

sentence ~>
	[if],
	sentence_coord_1,
	[then],
	sentence_coord_1.

sentence_coord_1 =>
	sentence_coord_2.

sentence_coord_1 ~>
	sentence_coord_2,
	[or],
	sentence_coord_1.

sentence_coord_2 =>
	simple_sentence.

sentence_coord_2 =>
	simple_sentence,
	[and],
	sentence_coord_2.

simple_sentence ~>
	['it is false that'],
	simple_sentence_2(whin:minus, whout:minus).

simple_sentence =>
	['there is'],
	nounphrase(exist:plus, def:minus, pl:minus, verb:be, whin:minus, whout:minus).

simple_sentence =>
	['there is'],
	nounphrase(exist:plus, def:minus, pl:minus, verb:be, whin:minus, whout:minus),
	['such that'],
	simple_sentence.

simple_sentence =>
	['there are'],
	nounphrase(exist:plus, def:minus, pl:plus, whin:minus, whout:minus).

simple_sentence =>
	simple_sentence_2(whin:minus, whout:minus).

simple_sentence_2(whin:WhIn, whout:WhOut) =>
	nounphrase(exist:plus, pl:PL, whin:WhIn, whout:WhTemp),
	verbphrase_coord_1(pl:PL, whin:WhTemp, whout:WhOut).

simple_sentence_2(whin:minus, whout:minus) ~>
	nounphrase(exist:minus),
	verbphrase_coord_1(pl:minus, whin:minus, whout:minus).

verbphrase_coord_1(pl:PL, whin:WhIn, whout:WhOut) =>
	verbphrase_coord_2(pl:PL, whin:WhIn, whout:WhOut).

verbphrase_coord_1(pl:PL, whin:Wh, whout:Wh) ~>
	verbphrase_coord_2(pl:PL, whin:Wh, whout:Wh),
	[or],
	verbphrase_coord_1(pl:PL, whin:Wh, whout:Wh).

verbphrase_coord_2(pl:PL, whin:WhIn, whout:WhOut) =>
	verbphrase_cut(pl:PL, whin:WhIn, whout:WhOut).

verbphrase_coord_2(pl:PL, whin:Wh, whout:Wh) =>
	verbphrase_cut(pl:PL, whin:Wh, whout:Wh),
	[and],
	verbphrase_coord_2(pl:PL, whin:Wh, whout:Wh).

verbphrase_cut(that:T, pl:PL, whin:WhIn, whout:WhOut) =>
	verbphrase(neg:minus, that:T, pl:PL, whin:WhIn, whout:WhOut).

verbphrase_cut(that:T, pl:PL, whin:WhIn, whout:WhOut) ~>
	verbphrase(neg:plus, that:T, pl:PL, whin:WhIn, whout:WhOut).

verbphrase(neg:Neg, that:T, pl:PL, whin:WhIn, whout:WhOut) =>
	verb(verb:full, pl:PL, neg:Neg),
	nounphrase_cut(that:T, verb:full, whin:WhIn, whout:WhOut).

verbphrase(neg:Neg, that:T, pl:PL, whin:WhIn, whout:WhOut) =>
	verb(verb:be, pl:PL, neg:Neg),
	nounphrase_cut(of:plus, that:T, pl:minus, verb:be, whin:WhIn, whout:WhOut).

verbphrase(neg:Neg, that:T, pl:minus, whin:WhIn, whout:WhOut) =>
	verb(verb:be, pl:minus, neg:Neg),
	nounphrase_cut(of:minus, that:T, pl:minus, verb:be, whin:WhIn, whout:WhOut).

verbphrase(neg:Neg, that:T, pl:PL, whin:WhIn, whout:WhOut) =>
	verb(verb:be, pl:PL, neg:Neg),
	['TRADJ'],
	nounphrase_cut(that:T, verb:full, whin:WhIn, whout:WhOut).

verbphrase(neg:Neg, that:T, pl:PL, whin:WhIn, whout:WhOut) =>
	verb(verb:be, pl:PL, neg:Neg),
	['PVERB'],
	nounphrase_cut(that:T, verb:full, whin:WhIn, whout:WhOut).

nounphrase_cut(exist:plus, that:T, of:Of, def:Def, pl:PL, verb:V, whin:WhIn, whout:WhOut) =>
	nounphrase(exist:plus, that:T, of:Of, def:Def, pl:PL, verb:V, whin:WhIn, whout:WhOut).

nounphrase_cut(exist:minus, that:T, of:Of, def:Def, pl:PL, verb:V, whin:WhIn, whout:WhOut) ~>
	nounphrase(exist:minus, that:T, of:Of, def:Def, pl:PL, verb:V, whin:WhIn, whout:WhOut).

nounphrase(exist:plus, that:T, of:minus, def:plus, pl:minus, whin:WhIn, whout:WhOut) =>
	['PROPERNAME'],
	that_phrase(that:T, whin:WhIn, whout:WhOut).

nounphrase(exist:plus, that:minus, of:minus, def:plus, pl:minus, whin:Wh, whout:Wh) =>
	['VARIABLE'].

nounphrase(exist:plus, that:minus, of:minus, def:plus, pl:minus, whin:Wh, whout:Wh) =>
	['REFERENCE'].

nounphrase(exist:plus, that:T, of:O, pl:minus, whin:WhIn, whout:WhOut) =>
	[a],
	noun_constr(that:T, of:O, whin:WhIn, whout:WhOut).

nounphrase(exist:plus, that:T, of:O, pl:minus, whin:WhIn, whout:WhOut) =>
	[an],
	noun_constr(that:T, of:O, whin:WhIn, whout:WhOut).

nounphrase(exist:plus, that:T, of:minus, pl:minus, whin:WhIn, whout:WhOut) =>
	exist_anon,
	['VARIABLE'],
 	that_phrase(that:T, whin:WhIn, whout:WhOut).

nounphrase(exist:plus, that:T, of:minus, pl:minus, whin:WhIn, whout:WhOut) =>
	exist_anon,
	that_phrase(that:T, whin:WhIn, whout:WhOut).

nounphrase(exist:plus, that:minus, of:minus, pl:plus, verb:full, whin:Wh, whout:Wh) =>
	num_quant,
	['NUMBER', 'NOUNPL'].

nounphrase(exist:plus, that:minus, of:minus, pl:minus, verb:full, whin:Wh, whout:Wh) =>
	num_quant,
	[1, 'NOUN'].

nounphrase(exist:plus, that:minus, of:minus, pl:minus, whin:right, whout:left) =>
	[what].

nounphrase(exist:plus, that:minus, of:minus, pl:minus, whin:right, whout:left) =>
	[who].

nounphrase(exist:plus, that:T, of:O, pl:minus, whin:right, whout:left) =>
	[which],
	noun_constr(that:T, of:O, whin:left, whout:left).

nounphrase(exist:plus, that:minus, of:minus, pl:plus, whin:right, whout:left) =>
	[which, 'NOUNPL'].

nounphrase(exist:minus, that:T, of:O, pl:minus, whin:minus, whout:minus) =>
	[every],
	noun_constr(that:T, of:O, whin:minus, whout:minus).

nounphrase(exist:minus, that:T, of:minus, pl:minus, whin:minus, whout:minus) =>
	univ_anon,
	['VARIABLE'],
	that_phrase(that:T, whin:minus, whout:minus).

nounphrase(exist:minus, that:T, of:minus, pl:minus, whin:minus, whout:minus) =>
	univ_anon,
	that_phrase(that:T, whin:minus, whout:minus).

nounphrase(exist:minus, that:T, of:O, pl:minus, whin:minus, whout:minus) =>
	[no],
	noun_constr(that:T, of:O, whin:minus, whout:minus).

nounphrase(exist:minus, that:T, of:minus, pl:minus, whin:minus, whout:minus) =>
	neg_anon,
	['VARIABLE'],
	that_phrase(that:T, whin:minus, whout:minus).

nounphrase(exist:minus, that:T, of:minus, pl:minus, whin:minus, whout:minus) =>
	neg_anon,
	that_phrase(that:T, whin:minus, whout:minus).

noun_constr(that:T, of:minus, whin:WhIn, whout:WhOut) =>
	['NOUN', 'VARIABLE'],
	that_phrase(that:T, whin:WhIn, whout:WhOut).

noun_constr(that:T, of:minus, whin:WhIn, whout:WhOut) =>
	['NOUN'],
	that_phrase(that:T, whin:WhIn, whout:WhOut).

noun_constr(that:T, of:plus, whin:WhIn, whout:WhOut) =>
	['NOUNOF'],
	nounphrase_cut(that:T, whin:WhIn, whout:WhOut).

verb(verb:be, neg:minus, pl:minus) =>
	[is].

verb(verb:be, neg:plus, pl:minus) =>
	['is not'].
	
verb(verb:be, neg:plus, pl:minus) =>
	[is, not].

verb(verb:be, neg:minus, pl:plus) =>
	[are].

verb(verb:be, neg:plus, pl:plus) =>
	['are not'].
	
verb(verb:be, neg:plus, pl:plus) =>
	[are, not].

verb(verb:full, neg:minus, pl:minus) =>
	['VERB'].

verb(verb:full, neg:plus, pl:minus) =>
	['does not', 'VERBINF'].

verb(verb:full, neg:minus, pl:plus) =>
	['VERBINF'].

verb(verb:full, neg:plus, pl:plus) =>
	['do not', 'VERBINF'].

that_phrase(that:minus, whin:Wh, whout:Wh) =>
	[].

that_phrase(that:plus, whin:WhIn, whout:WhOut) =>
	rel_pron,
	that_phrase_1(whin:WhIn, whout:WhOut).

that_phrase_1(whin:WhIn, whout:WhOut) =>
	that_phrase_2(whin:WhIn, whout:WhOut).

that_phrase_1(whin:Wh, whout:Wh) ~>
	that_phrase_2(whin:Wh, whout:Wh),
	or_rel_pron,
	that_phrase_1(whin:Wh, whout:Wh).

that_phrase_2(whin:WhIn, whout:WhOut) =>
	verbphrase_cut(pl:minus, whin:WhIn, whout:WhOut).

that_phrase_2(whin:WhIn, whout:WhOut) =>
	nounphrase_cut(that:minus, verb:full, pl:PL, whin:WhIn, whout:WhOut),
	verb(verb:full, pl:PL).

that_phrase_2(whin:Wh, whout:Wh) =>
	verbphrase_cut(that:minus, pl:minus, whin:Wh, whout:Wh),
	and_rel_pron,
	that_phrase_2(whin:Wh, whout:Wh).

rel_pron =>
	[that].

or_rel_pron =>
	[or],
	rel_pron.

or_rel_pron =>
	['or that'].

and_rel_pron =>
	[and],
	rel_pron.

and_rel_pron =>
	['and that'].

exist_anon =>
	[something].

exist_anon =>
	[somebody].

univ_anon =>
	[everything].

univ_anon =>
	[everybody].

neg_anon =>
	[nothing].

neg_anon =>
	[nobody].

num_quant =>
	['at least'].

num_quant =>
	['at most'].

num_quant =>
	['less than'].

num_quant =>
	['more than'].

num_quant =>
	['exactly'].
