// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.preditor;

import java.util.ArrayList;
import java.util.Collections;

import ch.uzh.ifi.attempto.preditor.text.TextElement;


class MenuBlockContent {
	
	private ArrayList<MenuItem> items = new ArrayList<MenuItem>();
	private String name;
	private String filter;
	private boolean doSort;
	private boolean isSorted = true;
	
	
	public MenuBlockContent(String name, boolean doSort) {
		this.name = name;
		this.doSort = doSort;
	}
	
	public void addItems(ArrayList<MenuItem> items) {
		for (MenuItem item : items) {
			addItem(item);
		}
	}
	
	public void addItem(MenuItem item) {
		items.add(item);
		isSorted = false;
	}
	
	public void addEntries(ArrayList<TextElement> textElements) {
		for (TextElement textElement : textElements) {
			addEntry(textElement);
		}
	}
	
	public void addEntry(TextElement textElement) {
		items.add(new MenuEntry(textElement));
		isSorted = false;
	}
	
	public String getName() {
		return name;
	}
	
	public boolean isEmpty() {
		return items.isEmpty();
	}
	
	public ArrayList<MenuEntry> getEntries() {
		if (!isSorted && doSort) {
			sort();
		}
		ArrayList<MenuEntry> filteredEntries = new ArrayList<MenuEntry>();
		for (MenuItem item : items) {
			if (item instanceof MenuEntry) {
				MenuEntry entry = (MenuEntry) item;
				if (entry.getTextElement().getText().toLowerCase().startsWith(filter)) {
					filteredEntries.add(entry);
				}
			}
		}
		return filteredEntries;
	}
	
	public ArrayList<MenuItem> getItems() {
		if (!isSorted && doSort) {
			sort();
		}
		if (filter == null || filter.length() == 0) {
			return items;
		}
		
		ArrayList<MenuItem> filteredItems = new ArrayList<MenuItem>();
		for (MenuItem item : items) {
			if (item instanceof MenuEntry) {
				if (((MenuEntry) item).getTextElement().getText().toLowerCase().startsWith(filter)) {
					filteredItems.add(item);
				}
			} else {
				filteredItems.add(item);
			}
		}
		return filteredItems;
	}
	
	public TextElement getEntry(String entryText) {
		for (MenuItem mi : getItems()) {
			if (mi instanceof MenuEntry) {
				TextElement t = ((MenuEntry) mi).getTextElement();
				if (t.getText().toLowerCase().equals(entryText.toLowerCase())) return t;
			}
		}
		return null;
	}
	
	public String getStartString() {
		String startString = null;
		for (MenuEntry entry : getEntries()) {
			String c = entry.getTextElement().getText().toLowerCase();
			if (startString == null) {
				startString = c;
			} else {
				for (int i = startString.length(); i >= 0; i--) {
					if (c.startsWith(startString.substring(0, i))) break;
					startString = startString.substring(0, i-1);
				}
			}
		}
		return startString;
	}
	
	public void setFilter(String filter) {
		if (filter == null) {
			this.filter = null;
		} else {
			this.filter = filter.toLowerCase();
		}
	}
	
	private void sort() {
		Collections.sort(items);
	}

}
