// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.preditor.example;

import ch.uzh.ifi.attempto.chartparser.Grammar;
import ch.uzh.ifi.attempto.chartparser.Nonterminal;
import ch.uzh.ifi.attempto.chartparser.Rule;
import ch.uzh.ifi.attempto.chartparser.Terminal;

/**
 * This class is an examplary implementation of a grammar. See the
 * <a href="{@docRoot}/src-html/ch/uzh/ifi/attempto/preditor/example/ExampleGrammar.html#line.1">source code</a>.
 * 
 * @author Tobias Kuhn
 */
public class ExampleGrammar extends Grammar {

	/**
	 * Creates a new grammar instance.
	 */
	public ExampleGrammar() {
		// "text" is the start symbol
		super("text");
		
		// Now the grammar rules are added. The comment lines show how the rules would be expressed in ACGN.
		
		// text => [].
		addRule(new Rule(new Nonterminal("text"), true));
		
		// text => s, ['.'], text.
		addRule(new Rule(new Nonterminal("text"), true, new Nonterminal("s"), new Terminal("."), new Nonterminal("text")));
		
		// s => exist_np, vp.
		addRule(new Rule(new Nonterminal("s"), true, new Nonterminal("exist_np"), new Nonterminal("vp")));
		
		// s ~> univ_np, vp.
		addRule(new Rule(new Nonterminal("s"), false, new Nonterminal("univ_np"), new Nonterminal("vp")));
		
		// univ_np => [every, 'N'], var.
		addRule(new Rule(new Nonterminal("univ_np"), true, new Terminal("every"), new Terminal("N"), new Nonterminal("var")));
		
		// univ_np => [no, 'N'], var.
		addRule(new Rule(new Nonterminal("univ_np"), true, new Terminal("no"), new Terminal("N"), new Nonterminal("var")));
		
		// exist_np => [a, 'N'], var.
		addRule(new Rule(new Nonterminal("exist_np"), true, new Terminal("a"), new Terminal("N"), new Nonterminal("var")));
		
		// exist_np => ['PN'].
		addRule(new Rule(new Nonterminal("exist_np"), true, new Terminal("PN")));
		
		// exist_np => ['REF'].
		addRule(new Rule(new Nonterminal("exist_np"), true, new Terminal("REF")));
		
		// var => [].
		addRule(new Rule(new Nonterminal("var"), true));
		
		// var => ['VAR'].
		addRule(new Rule(new Nonterminal("var"), true, new Terminal("VAR")));
		
		// vp => ['IV'].
		addRule(new Rule(new Nonterminal("vp"), true, new Terminal("IV")));
		
		// vp => ['TV'], exist_np.
		addRule(new Rule(new Nonterminal("vp"), true, new Terminal("TV"), new Nonterminal("exist_np")));
		
		// vp ~> ['TV'], univ_np.
		addRule(new Rule(new Nonterminal("vp"), false, new Terminal("TV"), new Nonterminal("univ_np")));
		
	}

}
