// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.preditor.example;

import ch.uzh.ifi.attempto.chartparser.Terminal;
import ch.uzh.ifi.attempto.preditor.MenuCreator;
import ch.uzh.ifi.attempto.preditor.text.BasicTextElement;
import ch.uzh.ifi.attempto.preditor.text.NounTextElement;

/**
 * This class is an examplary implementation of a menu creator. See the
 * <a href="{@docRoot}/src-html/ch/uzh/ifi/attempto/preditor/example/ExampleMenuCreator.html#line.1">source code</a>.
 * 
 * @author Tobias Kuhn
 */
public class ExampleMenuCreator extends MenuCreator {
	
	/**
	 * Creates a new menu creator instance.
	 */
	public ExampleMenuCreator() {
	}
	
	public void initMenuCreation() {
		// Here we can define the order of the menu blocks and whether they should be sorted or not:
		prepareMenuBlock("function word", true);
		prepareMenuBlock("determiner", true);
		prepareMenuBlock("noun", true);
		prepareMenuBlock("proper name", true);
		prepareMenuBlock("intransitive verb", true);
		prepareMenuBlock("transitive verb", true);
	}

	public void processCategory(Terminal category) {
		String n = category.getName();
		
		if (n.equals("DET")) {
			addMenuEntry("determiner", new BasicTextElement("a", n));
			addMenuEntry("determiner", new BasicTextElement("no", n));
			addMenuEntry("determiner", new BasicTextElement("every", n));
		} else if (n.equals("N")) {
			addMenuEntry("noun", new NounTextElement("man", n));
			addMenuEntry("noun", new NounTextElement("woman", n));
			addMenuEntry("noun", new NounTextElement("human", n));
			addMenuEntry("noun", new NounTextElement("dog", n));
			addMenuEntry("noun", new NounTextElement("house", n));
			addMenuEntry("noun", new NounTextElement("car", n));
		} else if (n.equals("PN")) {
			addMenuEntry("proper name", new BasicTextElement("John", n));
			addMenuEntry("proper name", new BasicTextElement("Bill", n));
			addMenuEntry("proper name", new BasicTextElement("Mary", n));
			addMenuEntry("proper name", new BasicTextElement("Sue", n));
			addMenuEntry("proper name", new BasicTextElement("Tom", n));
			addMenuEntry("proper name", new BasicTextElement("Rick", n));
			addMenuEntry("proper name", new BasicTextElement("Paul", n));
		} else if (n.equals("IV")) {
			addMenuEntry("intransitive verb", new BasicTextElement("waits", n));
			addMenuEntry("intransitive verb", new BasicTextElement("sleeps", n));
			addMenuEntry("intransitive verb", new BasicTextElement("works", n));
			addMenuEntry("intransitive verb", new BasicTextElement("eats", n));
			addMenuEntry("intransitive verb", new BasicTextElement("drinks", n));
		} else if (n.equals("TV")) {
			addMenuEntry("transitive verb", new BasicTextElement("sees", n));
			addMenuEntry("transitive verb", new BasicTextElement("knows", n));
			addMenuEntry("transitive verb", new BasicTextElement("owns", n));
			addMenuEntry("transitive verb", new BasicTextElement("uses", n));
			addMenuEntry("transitive verb", new BasicTextElement("buys", n));
			addMenuEntry("transitive verb", new BasicTextElement("sells", n));
			addMenuEntry("transitive verb", new BasicTextElement("drives", n));
			addMenuEntry("transitive verb", new BasicTextElement("likes", n));
		} else if (n.equals("REF")) {
			addReferenceEntries("reference", n);
		} else if (n.equals("VAR")) {
			addVariableEntries("variable", 10, n);
		} else {
			addMenuEntry("function word", new BasicTextElement(n));
		}
	}

}
