/*
 * Decompiled with CFR 0.152.
 */
package jpl;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import jpl.Atom;
import jpl.Compound;
import jpl.Integer;
import jpl.JPLException;
import jpl.Query;
import jpl.Term;
import jpl.Variable;
import jpl.fli.term_t;

public final class Util {
    public static Term termArrayToList(Term[] termArray) {
        Compound compound = new Atom("[]");
        for (int i = termArray.length - 1; i >= 0; --i) {
            compound = new Compound(".", new Term[]{termArray[i], compound});
        }
        return compound;
    }

    public static Term[] bindingsToTermArray(Map map) {
        Term[] termArray = new Term[map.size()];
        for (Variable variable : map.keySet()) {
            termArray[variable.index] = (Term)map.get(variable);
        }
        return termArray;
    }

    public static String toString(Map map) {
        if (map == null) {
            return "[no solution]";
        }
        Iterator iterator = map.keySet().iterator();
        String string = "Bindings: ";
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string = string + string2 + "=" + map.get(string2).toString() + "; ";
        }
        return string;
    }

    public static Map namevarsToMap(Term term) {
        try {
            Hashtable<term_t, Variable> hashtable = new Hashtable<term_t, Variable>();
            while (term.hasFunctor(".", 2) && term.arg(1).hasFunctor("=", 2)) {
                hashtable.put(((Variable)term.arg((int)1).arg((int)2)).term_, new Variable(term.arg(1).arg(1).name()));
                term = term.arg(2);
            }
            return hashtable;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static Term textToTerm(String string) {
        Query query = new Query(new Compound("atom_to_term", new Term[]{new Atom(string), new Variable("Term"), new Variable("NVdict")}));
        query.open();
        Hashtable hashtable = query.getSubstWithNameVars();
        if (hashtable != null) {
            query.close();
            return (Term)hashtable.get("Term");
        }
        return null;
    }

    public static Term textParamsToTerm(String string, Term[] termArray) {
        return Util.textToTerm(string).putParams(termArray);
    }

    public static Term stringArrayToList(String[] stringArray) {
        Compound compound = new Atom("[]");
        for (int i = stringArray.length - 1; i >= 0; --i) {
            compound = new Compound(".", new Term[]{new Atom(stringArray[i]), compound});
        }
        return compound;
    }

    public static Term intArrayToList(int[] nArray) {
        Compound compound = new Atom("[]");
        for (int i = nArray.length - 1; i >= 0; --i) {
            compound = new Compound(".", new Term[]{new Integer(nArray[i]), compound});
        }
        return compound;
    }

    public static Term intArrayArrayToList(int[][] nArray) {
        Compound compound = new Atom("[]");
        for (int i = nArray.length - 1; i >= 0; --i) {
            compound = new Compound(".", new Term[]{Util.intArrayToList(nArray[i]), compound});
        }
        return compound;
    }

    public static int listToLength(Term term) {
        int n = 0;
        Term term2 = term;
        while (term2.hasFunctor(".", 2)) {
            ++n;
            term2 = term2.arg(2);
        }
        return term2.hasFunctor("[]", 0) ? n : -1;
    }

    public static Term[] listToTermArray(Term term) {
        try {
            int n = term.listLength();
            Term[] termArray = new Term[n];
            for (int i = 0; i < n; ++i) {
                termArray[i] = term.arg(1);
                term = term.arg(2);
            }
            return termArray;
        }
        catch (JPLException jPLException) {
            throw new JPLException("Util.listToTermArray: term is not a proper list");
        }
    }

    public static String[] atomListToStringArray(Term term) {
        int n = Util.listToLength(term);
        if (n < 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        Term term2 = term;
        while (term2.hasFunctor(".", 2)) {
            Term term3 = term2.arg(1);
            if (!term3.isAtom()) {
                return null;
            }
            stringArray[n2++] = term3.name();
            term2 = term2.arg(2);
        }
        return term2.hasFunctor("[]", 0) ? stringArray : null;
    }
}

